/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.triplestore.api.PropertyBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCLink {
    private double r;
    private double ratedUdc;
    private final PropertyBag converter1;
    private final PropertyBag converter2;
    private final PropertyBag dcLine1;
    private final PropertyBag dcLine2;
    private static final Logger LOG = LoggerFactory.getLogger(DCLink.class);

    public DCLink(PropertyBag converter1, PropertyBag converter2, PropertyBag dcLine1, PropertyBag dcLine2) {
        this.converter1 = converter1;
        this.converter2 = converter2;
        this.dcLine1 = dcLine1;
        this.dcLine2 = dcLine2;
        this.computeR();
        this.computeRatedUdc();
    }

    private void computeR() {
        double r1 = this.dcLine1.asDouble("r");
        double d = r1 = Double.isNaN(r1) ? 0.1 : r1;
        if (this.dcLine2 == null) {
            this.r = r1;
        } else {
            double r2 = this.dcLine2.asDouble("r", 0.1);
            r2 = Double.isNaN(r2) ? 0.1 : r2;
            this.r = r1 + r2;
        }
        if (this.r < 0.0) {
            String dcLine1Id = this.dcLine1.getId("DCLineSegment");
            LOG.warn("Invalid r for DCLink with DCLineSegment: {}. Was: {}, fixed to 0.1.", (Object)dcLine1Id, (Object)this.r);
            this.r = 0.1;
        }
    }

    private void computeRatedUdc() {
        this.ratedUdc = this.converter1.asDouble("ratedUdc");
        if (this.ratedUdc == 0.0) {
            this.ratedUdc = this.converter2.asDouble("ratedUdc");
        }
    }

    public double getR() {
        return this.r;
    }

    public double getRatedUdc() {
        return this.ratedUdc;
    }

    public PropertyBag getConverter1() {
        return this.converter1;
    }

    public PropertyBag getConverter2() {
        return this.converter2;
    }

    public PropertyBag getDcLine1() {
        return this.dcLine1;
    }

    public PropertyBag getDcLine2() {
        return this.dcLine2;
    }
}

