/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.triplestore.api.PropertyBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCLinkUpdate {
    private HvdcLine.ConvertersMode mode;
    private double targetP;
    private double pDcInverter;
    private double lossFactor1;
    private double lossFactor2;
    private final DefaultData defaultData;
    private final HvdcLine hvdcLine;
    private final PropertyBag converter1;
    private final PropertyBag converter2;
    private static final String OPERATING_MODE = "operatingMode";
    private static final String TARGET_PPCC = "targetPpcc";
    private static final String POLE_LOSS_P = "poleLossP";
    private static final Logger LOG = LoggerFactory.getLogger(DCLinkUpdate.class);

    public DCLinkUpdate(HvdcLine hvdcLine, PropertyBag converter1, PropertyBag converter2, DefaultData defaultData) {
        this.hvdcLine = hvdcLine;
        this.converter1 = converter1;
        this.converter2 = converter2;
        this.defaultData = defaultData;
        this.computeMode();
        this.computeActivePowers();
        this.computeLossFactors();
    }

    private void computeMode() {
        String mode1 = this.converter1.getLocal(OPERATING_MODE);
        String mode2 = this.converter2.getLocal(OPERATING_MODE);
        if (this.isRectifier(mode1) && this.isInverter(mode2)) {
            this.mode = HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
        } else if (this.isInverter(mode1) && this.isRectifier(mode2)) {
            this.mode = HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
        } else if (this.targetPpcc1() > 0.0 || this.targetPpcc2() < 0.0) {
            this.mode = HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
        } else if (this.targetPpcc1() < 0.0 || this.targetPpcc2() > 0.0) {
            this.mode = HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
        } else {
            this.mode = this.defaultData.mode();
            String dcLine1Id = this.hvdcLine.getId();
            LOG.info("Default mode: {} for DCLink with DCLineSegment: {}.", (Object)this.mode, (Object)dcLine1Id);
        }
    }

    private boolean isRectifier(String operatingMode) {
        return operatingMode != null && operatingMode.toLowerCase().endsWith("rectifier");
    }

    private boolean isInverter(String operatingMode) {
        return operatingMode != null && operatingMode.toLowerCase().endsWith("inverter");
    }

    private double targetPpcc1() {
        double targetPpcc = this.converter1.asDouble(TARGET_PPCC);
        return Double.isNaN(targetPpcc) ? 0.0 : targetPpcc;
    }

    private double targetPpcc2() {
        double targetPpcc = this.converter2.asDouble(TARGET_PPCC);
        return Double.isNaN(targetPpcc) ? 0.0 : targetPpcc;
    }

    private double pole1Losses() {
        double poleLosses = this.converter1.asDouble(POLE_LOSS_P);
        return Double.isNaN(poleLosses) ? 0.0 : poleLosses;
    }

    private double pole2Losses() {
        double poleLosses = this.converter2.asDouble(POLE_LOSS_P);
        return Double.isNaN(poleLosses) ? 0.0 : poleLosses;
    }

    private void computeActivePowers() {
        if (this.getTargetPpccRectifier() != 0.0) {
            this.targetP = this.getTargetPpccRectifier();
            double pDcRectifier = this.targetP - this.getPoleLossesRectifier();
            this.pDcInverter = -1.0 * (pDcRectifier - this.resistiveLossesFromPdcRectifier(pDcRectifier));
        } else if (this.getTargetPpccInverter() != 0.0) {
            this.pDcInverter = -1.0 * (Math.abs(this.getTargetPpccInverter()) + this.getPoleLossesInverter());
            double pDcRectifier = Math.abs(this.pDcInverter) + this.resistiveLossesFromPdcInverter(this.pDcInverter);
            this.targetP = pDcRectifier + this.getPoleLossesRectifier();
        } else {
            this.targetP = this.defaultData.targetP();
        }
    }

    private double getTargetPpccRectifier() {
        if (this.mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            return this.targetPpcc1();
        }
        return this.targetPpcc2();
    }

    private double getTargetPpccInverter() {
        if (this.mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            return this.targetPpcc2();
        }
        return this.targetPpcc1();
    }

    private double getPoleLossesRectifier() {
        if (this.mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            return this.pole1Losses();
        }
        return this.pole2Losses();
    }

    private double getPoleLossesInverter() {
        if (this.mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            return this.pole2Losses();
        }
        return this.pole1Losses();
    }

    private double resistiveLossesFromPdcRectifier(double pDcRectifier) {
        double r = this.hvdcLine.getR();
        double ratedUdc = this.hvdcLine.getNominalV();
        double idc = ratedUdc != 0.0 ? pDcRectifier / ratedUdc : 0.0;
        return r * idc * idc;
    }

    private double resistiveLossesFromPdcInverter(double pDcInverter) {
        double r = this.hvdcLine.getR();
        double ratedUdc = this.hvdcLine.getNominalV();
        double idc = r != 0.0 ? (ratedUdc - Math.sqrt(ratedUdc * ratedUdc - 4.0 * r * Math.abs(pDcInverter))) / (2.0 * r) : 0.0;
        return r * idc * idc;
    }

    private void computeLossFactors() {
        if (this.targetP == 0.0 || this.targetP == this.defaultData.targetP()) {
            this.lossFactor1 = this.defaultData.lossFactor1();
            this.lossFactor2 = this.defaultData.lossFactor2();
        } else if (this.mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER) {
            this.lossFactor1 = this.getPoleLossesRectifier() / this.targetP * 100.0;
            this.lossFactor2 = this.getPoleLossesInverter() / Math.abs(this.pDcInverter) * 100.0;
        } else {
            this.lossFactor1 = this.getPoleLossesInverter() / Math.abs(this.pDcInverter) * 100.0;
            this.lossFactor2 = this.getPoleLossesRectifier() / this.targetP * 100.0;
        }
    }

    public HvdcLine.ConvertersMode getMode() {
        return this.mode;
    }

    public double getTargetP() {
        return this.targetP;
    }

    public double getLossFactor1() {
        return this.lossFactor1;
    }

    public double getLossFactor2() {
        return this.lossFactor2;
    }

    public record DefaultData(HvdcLine.ConvertersMode mode, double targetP, double lossFactor1, double lossFactor2) {
    }
}

