/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForVscConverters;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractReactiveLimitsOwnerConversion;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.triplestore.api.PropertyBag;

public class HvdcConverterConversion
extends AbstractReactiveLimitsOwnerConversion {
    private final PropertyBag converter;
    private static final String TARGET_QPCC = "targetQpcc";
    private static final String REACTIVE_PCC = "reactivePcc";
    private static final String VOLTAGE_PCC = "voltagePcc";
    private static final String TARGET_UPCC = "targetUpcc";
    private static final double DEFAULT_LOSS_FACTOR = 0.0;
    private static final double DEFAULT_POWER_FACTOR = 0.8;

    public HvdcConverterConversion(PropertyBag converter, Context context) {
        super("ACDCConverter", converter, context);
        this.converter = converter;
    }

    @Override
    public void convert() {
        if (HvdcConverterStation.HvdcType.VSC == this.getHvdcType()) {
            VscConverterStationAdder adder = (VscConverterStationAdder)this.voltageLevel().newVscConverterStation().setLossFactor(0.0f);
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
            RegulatingControlMappingForVscConverters.initialize(adder);
            VscConverterStation c = adder.add();
            this.addAliasesAndProperties((Identifiable<?>)c);
            this.convertedTerminalsWithOnlyEq(c.getTerminal());
            this.convertReactiveLimits((ReactiveLimitsHolder)c);
            this.context.regulatingControlMapping().forVscConverters().add(c.getId(), this.p);
        } else {
            LccConverterStationAdder adder = ((LccConverterStationAdder)this.voltageLevel().newLccConverterStation().setLossFactor(0.0f)).setPowerFactor(0.8f);
            this.identify((IdentifiableAdder<?, ?>)adder);
            this.connectWithOnlyEq((InjectionAdder<?, ?>)adder);
            LccConverterStation c = adder.add();
            this.addAliasesAndProperties((Identifiable<?>)c);
            this.convertedTerminalsWithOnlyEq(c.getTerminal());
        }
    }

    @Override
    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        super.addAliasesAndProperties(identifiable);
        identifiable.addAlias(this.converter.getId("DCTerminal1"), "CGMES.DCTerminal1");
        identifiable.addAlias(this.converter.getId("DCTerminal2"), "CGMES.DCTerminal2");
    }

    private HvdcConverterStation.HvdcType getHvdcType() {
        if ("VsConverter".equals(this.converter.getLocal("type"))) {
            return HvdcConverterStation.HvdcType.VSC;
        }
        return HvdcConverterStation.HvdcType.LCC;
    }

    static void update(LccConverterStation lccConverter, PropertyBag cgmesDataConverter, double lossFactor, Context context) {
        lccConverter.setLossFactor((float)lossFactor);
        lccConverter.setPowerFactor((float)HvdcConverterConversion.getPowerFactor(cgmesDataConverter, lccConverter, context));
    }

    private static double getPowerFactor(PropertyBag cgmesDataConverter, LccConverterStation lccConverter, Context context) {
        double q;
        double defaultPowerFactor = HvdcConverterConversion.getDefaultPowerFactor(lccConverter, context);
        double p = cgmesDataConverter.asDouble("p");
        double powerFactor = p / Math.hypot(p, q = cgmesDataConverter.asDouble("q"));
        if (Double.isNaN(powerFactor)) {
            return defaultPowerFactor;
        }
        return powerFactor;
    }

    private static double getDefaultPowerFactor(LccConverterStation lccConverter, Context context) {
        return HvdcConverterConversion.getDefaultValue(null, Double.valueOf(lccConverter.getPowerFactor()), 0.8, 0.8, context);
    }

    static void update(VscConverterStation vscConverter, PropertyBag cgmesDataConverter, double lossFactor, Context context) {
        double defaultTargetV;
        double targetV;
        vscConverter.setLossFactor((float)lossFactor);
        VscRegulation vscRegulation = HvdcConverterConversion.getVscRegulation(cgmesDataConverter, vscConverter, context);
        if (vscRegulation == VscRegulation.VOLTAGE && HvdcConverterConversion.isValidTargetV(targetV = HvdcConverterConversion.findTargetV(cgmesDataConverter, TARGET_UPCC, defaultTargetV = HvdcConverterConversion.getDefaultTargetV(vscConverter, context), AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED))) {
            vscConverter.setVoltageSetpoint(targetV).setReactivePowerSetpoint(0.0).setVoltageRegulatorOn(true);
            return;
        }
        double targetQ = HvdcConverterConversion.getValidTargetQ(cgmesDataConverter, vscConverter, context);
        vscConverter.setVoltageRegulatorOn(false).setVoltageSetpoint(0.0).setReactivePowerSetpoint(targetQ);
    }

    private static VscRegulation getVscRegulation(PropertyBag cgmesDataConverter, VscConverterStation vscConverter, Context context) {
        String qPccControl = cgmesDataConverter.getLocal("qPccControl");
        if (qPccControl != null) {
            if (qPccControl.endsWith(VOLTAGE_PCC)) {
                return VscRegulation.VOLTAGE;
            }
            if (qPccControl.endsWith(REACTIVE_PCC)) {
                return VscRegulation.REACTIVE_POWER;
            }
        }
        return HvdcConverterConversion.getDefaultVscRegulation(vscConverter, context);
    }

    private static VscRegulation getDefaultVscRegulation(VscConverterStation vscConverter, Context context) {
        boolean defaultVoltageRegulationOn = HvdcConverterConversion.getDefaultVoltageRegulationOn(vscConverter, context);
        return defaultVoltageRegulationOn ? VscRegulation.VOLTAGE : VscRegulation.REACTIVE_POWER;
    }

    private static boolean getDefaultVoltageRegulationOn(VscConverterStation vscConverter, Context context) {
        return HvdcConverterConversion.getDefaultValue(false, vscConverter.isVoltageRegulatorOn(), false, false, context);
    }

    private static double getDefaultTargetV(VscConverterStation vscConverter, Context context) {
        return HvdcConverterConversion.getDefaultValue(null, vscConverter.getVoltageSetpoint(), Double.NaN, Double.NaN, context);
    }

    private static double getValidTargetQ(PropertyBag cgmesDataConverter, VscConverterStation vscConverter, Context context) {
        double defaultTargetQ = HvdcConverterConversion.getDefaultTargetQ(vscConverter, context);
        return HvdcConverterConversion.findTargetQ(cgmesDataConverter, TARGET_QPCC, -HvdcConverterConversion.findTerminalSign(vscConverter), defaultTargetQ, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_VALID);
    }

    private static double getDefaultTargetQ(VscConverterStation vscConverter, Context context) {
        double previousTargetQ = Double.isFinite(vscConverter.getReactivePowerSetpoint()) ? vscConverter.getReactivePowerSetpoint() : 0.0;
        return HvdcConverterConversion.getDefaultValue(0.0, previousTargetQ, 0.0, 0.0, context);
    }

    static enum VscRegulation {
        REACTIVE_POWER,
        VOLTAGE;

    }
}

