/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.dc;

import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractIdentifiedObjectConversion;
import com.powsybl.cgmes.conversion.elements.dc.DCLink;
import com.powsybl.cgmes.conversion.elements.dc.DCLinkUpdate;
import com.powsybl.cgmes.conversion.elements.dc.HvdcConverterConversion;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.triplestore.api.PropertyBag;

public class HvdcLineConversion
extends AbstractIdentifiedObjectConversion {
    private final DCLink dcLink;
    private static final double DEFAULT_MAXP_FACTOR = 1.2;

    public HvdcLineConversion(DCLink dcLink, Context context) {
        super("DCLineSegment", dcLink.getDcLine1(), context);
        this.dcLink = dcLink;
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void convert() {
        double maxP = 0.0;
        double activePowerSetpoint = 0.0;
        HvdcLineAdder adder = this.context.network().newHvdcLine().setR(this.dcLink.getR()).setNominalV(this.dcLink.getRatedUdc()).setMaxP(maxP).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setActivePowerSetpoint(activePowerSetpoint).setConverterStationId1(this.context.namingStrategy().getIidmId("ACDCConverter", this.dcLink.getConverter1().getId("ACDCConverter"))).setConverterStationId2(this.context.namingStrategy().getIidmId("ACDCConverter", this.dcLink.getConverter2().getId("ACDCConverter")));
        this.identify((IdentifiableAdder<?, ?>)adder);
        HvdcLine hvdcLine = adder.add();
        hvdcLine.addAlias(this.dcLink.getDcLine1().getId("DCTerminal1"), "CGMES.DCTerminal1");
        hvdcLine.addAlias(this.dcLink.getDcLine1().getId("DCTerminal2"), "CGMES.DCTerminal2");
        if (this.dcLink.getDcLine2() != null) {
            hvdcLine.addAlias(this.dcLink.getDcLine2().getId("DCLineSegment"), "CGMES.DCLineSegment2");
        }
    }

    public static void update(HvdcLine hvdcLine, PropertyBag cgmesDataAcDcConverter1, PropertyBag cgmesDataAcDcConverter2, Context context) {
        AbstractConductingEquipmentConversion.updateTerminals(hvdcLine.getConverterStation1(), context, new Terminal[]{hvdcLine.getConverterStation1().getTerminal()});
        AbstractConductingEquipmentConversion.updateTerminals(hvdcLine.getConverterStation2(), context, new Terminal[]{hvdcLine.getConverterStation2().getTerminal()});
        DCLinkUpdate dcLinkUpdate = HvdcLineConversion.updateHvdcLine(hvdcLine, cgmesDataAcDcConverter1, cgmesDataAcDcConverter2, context);
        if (hvdcLine.getConverterStation1().getHvdcType() == HvdcConverterStation.HvdcType.LCC) {
            HvdcConverterConversion.update((LccConverterStation)hvdcLine.getConverterStation1(), cgmesDataAcDcConverter1, dcLinkUpdate.getLossFactor1(), context);
            HvdcConverterConversion.update((LccConverterStation)hvdcLine.getConverterStation2(), cgmesDataAcDcConverter2, dcLinkUpdate.getLossFactor2(), context);
        } else {
            HvdcConverterConversion.update((VscConverterStation)hvdcLine.getConverterStation1(), cgmesDataAcDcConverter1, dcLinkUpdate.getLossFactor1(), context);
            HvdcConverterConversion.update((VscConverterStation)hvdcLine.getConverterStation2(), cgmesDataAcDcConverter2, dcLinkUpdate.getLossFactor2(), context);
        }
    }

    private static DCLinkUpdate updateHvdcLine(HvdcLine hvdcLine, PropertyBag cgmesDataAcDcConverter1, PropertyBag cgmesDataAcDcConverter2, Context context) {
        DCLinkUpdate.DefaultData defaultData = HvdcLineConversion.getDefaultData(hvdcLine, context);
        DCLinkUpdate dcLinkUpdate = new DCLinkUpdate(hvdcLine, cgmesDataAcDcConverter1, cgmesDataAcDcConverter2, defaultData);
        hvdcLine.setConvertersMode(dcLinkUpdate.getMode()).setActivePowerSetpoint(dcLinkUpdate.getTargetP()).setMaxP(1.2 * dcLinkUpdate.getTargetP());
        return dcLinkUpdate;
    }

    private static DCLinkUpdate.DefaultData getDefaultData(HvdcLine hvdcLine, Context context) {
        boolean defaultRectifierOnSide1 = HvdcLineConversion.getDefaultValue(null, HvdcLineConversion.isRectifierOnSide1(hvdcLine.getConvertersMode()), true, true, context);
        HvdcLine.ConvertersMode defaultMode = defaultRectifierOnSide1 ? HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER : HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER;
        double defaultTargetP = HvdcLineConversion.getDefaultValue(null, hvdcLine.getActivePowerSetpoint(), 0.0, 0.0, context);
        double lossFactor1 = HvdcLineConversion.getDefaultValue(null, Double.valueOf(hvdcLine.getConverterStation1().getLossFactor()), 0.0, 0.0, context);
        double lossFactor2 = HvdcLineConversion.getDefaultValue(null, Double.valueOf(hvdcLine.getConverterStation2().getLossFactor()), 0.0, 0.0, context);
        return new DCLinkUpdate.DefaultData(defaultMode, defaultTargetP, lossFactor1, lossFactor2);
    }

    private static boolean isRectifierOnSide1(HvdcLine.ConvertersMode mode) {
        return mode == HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER;
    }
}

