/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.elements.transformers;

import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.Context;
import com.powsybl.cgmes.conversion.ConversionException;
import com.powsybl.cgmes.conversion.RegulatingControlMappingForTransformers;
import com.powsybl.cgmes.conversion.elements.AbstractConductingEquipmentConversion;
import com.powsybl.cgmes.conversion.elements.AbstractObjectConversion;
import com.powsybl.cgmes.conversion.elements.transformers.TapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.CgmesTapChangersAdder;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class AbstractTransformerConversion
extends AbstractConductingEquipmentConversion {
    protected static final String END_NUMBER = "endNumber";

    AbstractTransformerConversion(String type, PropertyBags ends, Context context) {
        super(type, ends, context);
    }

    protected static void setToIidmRatioTapChanger(TapChanger rtc, RatioTapChangerAdder rtca) {
        boolean isLtcFlag = rtc.isLtcFlag();
        int lowStep = rtc.getLowTapPosition();
        int position = rtc.getTapPosition();
        Integer solvedPosition = rtc.getSolvedTapPosition();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)rtca.setLoadTapChangingCapabilities(isLtcFlag)).setLowTapPosition(lowStep)).setTapPosition(position)).setSolvedTapPosition(solvedPosition);
        rtc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double r = step.getR();
            double x = step.getX();
            double b1 = step.getB1();
            double g1 = step.getG1();
            ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtca.beginStep()).setRho(1.0 / ratio)).setR(r)).setX(x)).setB(b1)).setG(g1)).endStep();
        });
        rtca.add();
    }

    protected static void setToIidmPhaseTapChanger(TapChanger ptc, PhaseTapChangerAdder ptca, Context context) {
        boolean isLtcFlag = ptc.isLtcFlag();
        int lowStep = ptc.getLowTapPosition();
        int position = ptc.getTapPosition();
        Integer solvedPosition = ptc.getSolvedTapPosition();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ptca.setLoadTapChangingCapabilities(isLtcFlag)).setLowTapPosition(lowStep)).setTapPosition(position)).setSolvedTapPosition(solvedPosition);
        ptc.getSteps().forEach(step -> {
            double ratio = step.getRatio();
            double angle = step.getAngle();
            double r = step.getR();
            double x = step.getX();
            if (Double.isNaN(x)) {
                context.fixed("ptc.step.x", "ptc.step.x is undefined", x, 0.0);
                x = 0.0;
            }
            double b1 = step.getB1();
            double g1 = step.getG1();
            ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptca.beginStep()).setRho(1.0 / ratio)).setAlpha(-angle)).setR(r)).setX(x)).setB(b1)).setG(g1)).endStep();
        });
        ptca.add();
    }

    protected RegulatingControlMappingForTransformers.CgmesRegulatingControlRatio setContextRegulatingDataRatio(TapChanger tc) {
        if (tc != null) {
            return this.context.regulatingControlMapping().forTransformers().buildRegulatingControlRatio(tc.getId(), tc.getRegulatingControlId(), tc.getTculControlMode());
        }
        return null;
    }

    protected RegulatingControlMappingForTransformers.CgmesRegulatingControlPhase setContextRegulatingDataPhase(TapChanger tc) {
        if (tc != null) {
            return this.context.regulatingControlMapping().forTransformers().buildRegulatingControlPhase(tc.getId(), tc.getRegulatingControlId());
        }
        return null;
    }

    @Override
    protected void addAliasesAndProperties(Identifiable<?> identifiable) {
        String aliasType;
        String alias;
        super.addAliasesAndProperties(identifiable);
        for (PropertyBag end : this.ps) {
            alias = end.getId("TransformerEnd");
            aliasType = "CGMES.TransformerEnd" + end.getLocal(END_NUMBER);
            identifiable.addAlias(alias, aliasType);
        }
        for (PropertyBag rtc : this.context.ratioTapChangers(identifiable.getId())) {
            alias = rtc.getId("RatioTapChanger");
            aliasType = "CGMES.RatioTapChanger" + rtc.getLocal(END_NUMBER);
            identifiable.addAlias(alias, aliasType, this.context.config().isEnsureIdAliasUnicity());
        }
        for (PropertyBag ptc : this.context.phaseTapChangers(identifiable.getId())) {
            alias = ptc.getId("PhaseTapChanger");
            aliasType = "CGMES.PhaseTapChanger" + ptc.getLocal(END_NUMBER);
            identifiable.addAlias(alias, aliasType, this.context.config().isEnsureIdAliasUnicity());
        }
    }

    protected static <C extends Connectable<C>> void addCgmesReferences(C transformer, TapChanger tc) {
        if (tc == null || tc.getId() == null) {
            return;
        }
        TapChanger tch = tc.getHiddenCombinedTapChanger();
        CgmesTapChangers tapChangers = (CgmesTapChangers)transformer.getExtension(CgmesTapChangers.class);
        if (tapChangers == null) {
            ((CgmesTapChangersAdder)transformer.newExtension(CgmesTapChangersAdder.class)).add();
            tapChangers = (CgmesTapChangers)transformer.getExtension(CgmesTapChangers.class);
        }
        tapChangers.newTapChanger().setId(tc.getId()).setType(tc.getType()).setStep(tc.getTapPosition().intValue()).setControlId(tc.getRegulatingControlId()).add();
        if (tch != null) {
            tapChangers.newTapChanger().setId(tch.getId()).setCombinedTapChangerId(tc.getId()).setHiddenStatus(true).setStep(tch.getTapPosition().intValue()).setType(tch.getType()).add();
        }
    }

    static <C extends Connectable<C>> void updateRatioTapChanger(Connectable<C> tw, RatioTapChanger rtc, Context context, boolean isRegulatingAllowed) {
        AbstractTransformerConversion.updateRatioTapChanger(tw, rtc, "", context, isRegulatingAllowed);
    }

    static <C extends Connectable<C>> void updateRatioTapChanger(Connectable<C> tw, RatioTapChanger rtc, ThreeSides side, Context context, boolean isRegulatingAllowed) {
        AbstractTransformerConversion.updateRatioTapChanger(tw, rtc, String.valueOf(side.getNum()), context, isRegulatingAllowed);
    }

    static <C extends Connectable<C>> void updatePhaseTapChanger(Connectable<C> tw, PhaseTapChanger ptc, Context context, boolean isRegulatingAllowed) {
        AbstractTransformerConversion.updatePhaseTapChanger(tw, ptc, "", context, isRegulatingAllowed);
    }

    static <C extends Connectable<C>> void updatePhaseTapChanger(Connectable<C> tw, PhaseTapChanger ptc, ThreeSides side, Context context, boolean isRegulatingAllowed) {
        AbstractTransformerConversion.updatePhaseTapChanger(tw, ptc, String.valueOf(side.getNum()), context, isRegulatingAllowed);
    }

    private static <C extends Connectable<C>> void updateRatioTapChanger(Connectable<C> tw, RatioTapChanger rtc, String end, Context context, boolean isRegulatingAllowed) {
        String ratioTapChangerId = AbstractTransformerConversion.findTapChangerId(tw, "CGMES.RatioTapChanger" + end);
        int defaultTapPosition = AbstractTransformerConversion.getDefaultTapPosition(tw, rtc, ratioTapChangerId, AbstractTransformerConversion.getClosestNeutralStep(rtc), context);
        rtc.setTapPosition(AbstractTransformerConversion.findValidTapPosition(rtc, ratioTapChangerId, defaultTapPosition, context));
        AbstractTransformerConversion.findValidSolvedTapPosition(rtc, ratioTapChangerId, context).ifPresent(arg_0 -> ((RatioTapChanger)rtc).setSolvedTapPosition(arg_0));
        if (rtc.getRegulationTerminal() != null) {
            boolean regulating;
            boolean validTargetDeadband;
            Optional<PropertyBag> cgmesRegulatingControl = AbstractTransformerConversion.findCgmesRegulatingControl(tw, ratioTapChangerId, context);
            double defaultTargetV = AbstractTransformerConversion.getDefaultTargetV(rtc, context);
            double targetV = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findTargetV(propertyBag, defaultTargetV, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetV);
            double defaultTargetDeadband = AbstractTransformerConversion.getDefaultTargetDeadband(rtc, context);
            double targetDeadband = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findTargetDeadband(propertyBag, defaultTargetDeadband, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetDeadband);
            boolean defaultRegulatingOn = AbstractTransformerConversion.getDefaultRegulatingOn(rtc, context);
            boolean regulatingOn = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
            boolean validTargetV = AbstractTransformerConversion.isValidTargetV(targetV);
            if (!validTargetV) {
                context.invalid(ratioTapChangerId, "Regulating control has a bad target voltage " + targetV);
                CgmesReports.badVoltageTargetValueRegulatingControlReport(context.getReportNode(), ratioTapChangerId, targetV);
            }
            if (!(validTargetDeadband = AbstractTransformerConversion.isValidTargetDeadband(targetDeadband))) {
                context.invalid(ratioTapChangerId, "Regulating control has a bad target deadband " + targetDeadband);
                CgmesReports.badTargetDeadbandRegulatingControlReport(context.getReportNode(), ratioTapChangerId, targetDeadband);
                targetDeadband = Double.NaN;
            }
            boolean bl = regulating = regulatingOn && isRegulatingAllowed && validTargetV && validTargetDeadband;
            if (regulating && !rtc.hasLoadTapChangingCapabilities()) {
                CgmesReports.badLoadTapChangingCapabilityTapChangerReport(context.getReportNode(), ratioTapChangerId);
                rtc.setLoadTapChangingCapabilities(true);
            }
            AbstractTransformerConversion.setRegulation(rtc, targetV, targetDeadband, regulating);
        }
    }

    private static <C extends Connectable<C>> Optional<PropertyBag> findCgmesRegulatingControl(Connectable<C> tw, String tapChangerId, Context context) {
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)tw.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && tapChangerId != null) {
            CgmesTapChanger cgmesTc = cgmesTcs.getTapChanger(tapChangerId);
            return cgmesTc != null ? Optional.ofNullable(context.regulatingControl(cgmesTc.getControlId())) : Optional.empty();
        }
        return Optional.empty();
    }

    private static void setRegulation(RatioTapChanger rtc, double targetV, double targetDeadband, boolean regulatingOn) {
        if (regulatingOn) {
            ((RatioTapChanger)rtc.setTargetV(targetV).setTargetDeadband(targetDeadband)).setRegulating(true);
        } else {
            ((RatioTapChanger)rtc.setRegulating(false)).setTargetV(targetV).setTargetDeadband(targetDeadband);
        }
    }

    private static <C extends Connectable<C>> void updatePhaseTapChanger(Connectable<C> tw, PhaseTapChanger ptc, String end, Context context, boolean isRegulatingAllowed) {
        String phaseTapChangerId = AbstractTransformerConversion.findTapChangerId(tw, "CGMES.PhaseTapChanger" + end);
        int defaultTapPosition = AbstractTransformerConversion.getDefaultTapPosition(tw, ptc, phaseTapChangerId, AbstractTransformerConversion.getClosestNeutralStep(ptc), context);
        ptc.setTapPosition(AbstractTransformerConversion.findValidTapPosition(ptc, phaseTapChangerId, defaultTapPosition, context));
        AbstractTransformerConversion.findValidSolvedTapPosition(ptc, phaseTapChangerId, context).ifPresent(arg_0 -> ((PhaseTapChanger)ptc).setSolvedTapPosition(arg_0));
        if (ptc.getRegulationTerminal() != null) {
            boolean regulating;
            Optional<PropertyBag> cgmesRegulatingControl = AbstractTransformerConversion.findCgmesRegulatingControl(tw, phaseTapChangerId, context);
            double defaultTargetValue = AbstractTransformerConversion.getDefaultTargetValue(ptc, context);
            double targetValue = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findTargetValue(propertyBag, AbstractTransformerConversion.findTerminalSign(tw, end), defaultTargetValue, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetValue);
            double defaultTargetDeadband = AbstractTransformerConversion.getDefaultTargetDeadband(ptc, context);
            double targetDeadband = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findTargetDeadband(propertyBag, defaultTargetDeadband, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultTargetDeadband);
            boolean defaultRegulatingOn = AbstractTransformerConversion.getDefaultRegulatingOn(ptc, context);
            boolean regulatingOn = cgmesRegulatingControl.map(propertyBag -> AbstractTransformerConversion.findRegulatingOn(propertyBag, defaultRegulatingOn, AbstractConductingEquipmentConversion.DefaultValueUse.NOT_DEFINED)).orElse(defaultRegulatingOn);
            boolean validTargetValue = AbstractTransformerConversion.isValidTargetValue(targetValue);
            if (!validTargetValue) {
                context.invalid(phaseTapChangerId, "Regulating control has a bad target value " + targetValue);
                CgmesReports.badTargetValueRegulatingControlReport(context.getReportNode(), phaseTapChangerId, targetValue);
            } else if (ptc.getRegulationMode() == PhaseTapChanger.RegulationMode.CURRENT_LIMITER && targetValue < 0.0) {
                context.fixed(tw.getId(), "PhaseTapChanger " + end + " : Regulating value is negative while regulationMode is set to CURRENT_LIMITER : fixed to absolute value");
                targetValue = Math.abs(targetValue);
            }
            boolean validTargetDeadband = AbstractTransformerConversion.isValidTargetDeadband(targetDeadband);
            if (!validTargetDeadband) {
                context.invalid(phaseTapChangerId, "Regulating control has a bad target deadband " + targetDeadband);
                CgmesReports.badTargetDeadbandRegulatingControlReport(context.getReportNode(), phaseTapChangerId, targetDeadband);
                targetDeadband = Double.NaN;
            }
            boolean bl = regulating = regulatingOn && isRegulatingAllowed && AbstractTransformerConversion.isValidTargetValue(targetValue) && validTargetDeadband;
            if (regulating && !ptc.hasLoadTapChangingCapabilities()) {
                CgmesReports.badLoadTapChangingCapabilityTapChangerReport(context.getReportNode(), phaseTapChangerId);
                ptc.setLoadTapChangingCapabilities(true);
            }
            AbstractTransformerConversion.setRegulation(ptc, targetValue, targetDeadband, regulating);
        }
    }

    private static void setRegulation(PhaseTapChanger ptc, double targetValue, double targetDeadband, boolean regulatingOn) {
        if (regulatingOn) {
            ((PhaseTapChanger)ptc.setRegulationValue(targetValue).setTargetDeadband(targetDeadband)).setRegulating(true);
        } else {
            ((PhaseTapChanger)ptc.setRegulating(false)).setRegulationValue(targetValue).setTargetDeadband(targetDeadband);
        }
    }

    private static Optional<PropertyBag> findCgmesRatioTapChanger(String ratioTapChangerId, Context context) {
        return ratioTapChangerId != null ? Optional.ofNullable(context.ratioTapChanger(ratioTapChangerId)) : Optional.empty();
    }

    private static Optional<PropertyBag> findCgmesPhaseTapChanger(String phaseTapChangerId, Context context) {
        return phaseTapChangerId != null ? Optional.ofNullable(context.phaseTapChanger(phaseTapChangerId)) : Optional.empty();
    }

    private static int findValidTapPosition(RatioTapChanger ratioTapChanger, String ratioTapChangerId, int defaultTapPosition, Context context) {
        int tapPosition = AbstractTransformerConversion.findCgmesRatioTapChanger(ratioTapChangerId, context).map(propertyBag -> AbstractTransformerConversion.findTapPosition(propertyBag, defaultTapPosition)).orElse(defaultTapPosition);
        return AbstractTransformerConversion.isValidTapPosition(ratioTapChanger, tapPosition) ? tapPosition : defaultTapPosition;
    }

    private static int findValidTapPosition(PhaseTapChanger phaseTapChanger, String phaseTapChangerId, int defaultTapPosition, Context context) {
        int tapPosition = AbstractTransformerConversion.findCgmesPhaseTapChanger(phaseTapChangerId, context).map(propertyBag -> AbstractTransformerConversion.findTapPosition(propertyBag, defaultTapPosition)).orElse(defaultTapPosition);
        return AbstractTransformerConversion.isValidTapPosition(phaseTapChanger, tapPosition) ? tapPosition : defaultTapPosition;
    }

    private static int findTapPosition(PropertyBag p, int defaultTapPosition) {
        OptionalInt tapPosition = AbstractTransformerConversion.findTapPosition(p);
        return tapPosition.isPresent() ? tapPosition.getAsInt() : defaultTapPosition;
    }

    private static <C extends Connectable<C>> int getDefaultTapPosition(Connectable<C> tw, com.powsybl.iidm.network.TapChanger<?, ?, ?, ?> tapChanger, String tapChangerId, int closestNeutralTapPosition, Context context) {
        OptionalInt normalStep = AbstractTransformerConversion.getNormalStep(tw, tapChangerId);
        OptionalInt neutralPosition = tapChanger.getNeutralPosition();
        return AbstractTransformerConversion.getDefaultValue(normalStep.isPresent() ? Integer.valueOf(normalStep.getAsInt()) : null, tapChanger.getTapPosition(), neutralPosition.isPresent() ? Integer.valueOf(neutralPosition.getAsInt()) : null, closestNeutralTapPosition, context);
    }

    private static boolean isValidTapPosition(com.powsybl.iidm.network.TapChanger<?, ?, ?, ?> tapChanger, int tapPosition) {
        return tapChanger.getLowTapPosition() <= tapPosition && tapPosition <= tapChanger.getHighTapPosition();
    }

    private static OptionalInt findTapPosition(PropertyBag p) {
        double tapPosition = p.asDouble("step", p.asDouble("SVtapStep"));
        return Double.isFinite(tapPosition) ? OptionalInt.of(AbstractObjectConversion.fromContinuous(tapPosition)) : OptionalInt.empty();
    }

    private static OptionalInt findValidSolvedTapPosition(RatioTapChanger ratioTapChanger, String ratioTapChangerId, Context context) {
        OptionalInt tap;
        Optional<PropertyBag> propertyBag = AbstractTransformerConversion.findCgmesRatioTapChanger(ratioTapChangerId, context);
        if (propertyBag.isPresent() && (tap = AbstractTransformerConversion.findSolvedTapPosition(propertyBag.get())).isPresent() && AbstractTransformerConversion.isValidTapPosition(ratioTapChanger, tap.getAsInt())) {
            return tap;
        }
        return OptionalInt.empty();
    }

    private static OptionalInt findValidSolvedTapPosition(PhaseTapChanger phaseTapChanger, String phaseTapChangerId, Context context) {
        OptionalInt tap;
        Optional<PropertyBag> propertyBag = AbstractTransformerConversion.findCgmesPhaseTapChanger(phaseTapChangerId, context);
        if (propertyBag.isPresent() && (tap = AbstractTransformerConversion.findSolvedTapPosition(propertyBag.get())).isPresent() && AbstractTransformerConversion.isValidTapPosition(phaseTapChanger, tap.getAsInt())) {
            return tap;
        }
        return OptionalInt.empty();
    }

    private static OptionalInt findSolvedTapPosition(PropertyBag p) {
        double tapPosition = p.asDouble("SVtapStep");
        return Double.isFinite(tapPosition) ? OptionalInt.of(AbstractObjectConversion.fromContinuous(tapPosition)) : OptionalInt.empty();
    }

    private static <C extends Connectable<C>> String findTapChangerId(Connectable<C> tw, String propertyTag) {
        List<String> tcIds = tw.getAliases().stream().filter(alias -> AbstractTransformerConversion.isValidTapChangerIdAlias(tw, alias, tw.getAliasType(alias).orElse(null), propertyTag)).toList();
        if (tcIds.size() == 1) {
            return tcIds.get(0);
        }
        throw new ConversionException("unexpected tapChangerId for transformer " + tw.getId());
    }

    private static boolean isValidTapChangerIdAlias(Connectable<?> connectable, String alias, String aliasType, String propertyTag) {
        return alias != null && aliasType != null && aliasType.contains(propertyTag) && !AbstractTransformerConversion.isHiddenTapChanger(connectable, alias);
    }

    private static <C extends Connectable<C>> boolean isHiddenTapChanger(Connectable<C> tw, String tapChangerId) {
        CgmesTapChanger cgmesTc;
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)tw.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && (cgmesTc = cgmesTcs.getTapChanger(tapChangerId)) != null) {
            return cgmesTc.isHidden();
        }
        return false;
    }

    private static double getDefaultTargetV(RatioTapChanger ratioTapChanger, Context context) {
        return AbstractTransformerConversion.getDefaultValue(null, ratioTapChanger.getTargetV(), Double.NaN, Double.NaN, context);
    }

    private static double getDefaultTargetValue(PhaseTapChanger phaseTapChanger, Context context) {
        return AbstractTransformerConversion.getDefaultValue(null, phaseTapChanger.getRegulationValue(), Double.NaN, Double.NaN, context);
    }

    private static double getDefaultTargetDeadband(com.powsybl.iidm.network.TapChanger<?, ?, ?, ?> tapChanger, Context context) {
        return AbstractTransformerConversion.getDefaultValue(0.0, tapChanger.getTargetDeadband(), 0.0, 0.0, context);
    }

    private static boolean getDefaultRegulatingOn(com.powsybl.iidm.network.TapChanger<?, ?, ?, ?> tapChanger, Context context) {
        return AbstractTransformerConversion.getDefaultValue(false, tapChanger.isRegulating(), false, false, context);
    }

    static boolean checkOnlyOneEnabled(boolean isAllowedToRegulate, boolean previousTapChangerIsRegulatingOn) {
        return isAllowedToRegulate && !previousTapChangerIsRegulatingOn;
    }

    public static <C extends Connectable<C>> OptionalInt getNormalStep(Connectable<C> tw, String tapChangerId) {
        CgmesTapChanger cgmesTc;
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)tw.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && (cgmesTc = cgmesTcs.getTapChanger(tapChangerId)) != null) {
            return cgmesTc.getStep();
        }
        return OptionalInt.empty();
    }

    public static int getClosestNeutralStep(RatioTapChanger rtc) {
        return rtc.getAllSteps().entrySet().stream().min(Comparator.comparingDouble(entry -> Math.abs(((RatioTapChangerStep)entry.getValue()).getRho() - 1.0))).map(Map.Entry::getKey).orElse(rtc.getLowTapPosition());
    }

    public static int getClosestNeutralStep(PhaseTapChanger ptc) {
        return ptc.getAllSteps().entrySet().stream().min(Comparator.comparingDouble(entry -> Math.abs(((PhaseTapChangerStep)entry.getValue()).getAlpha()))).map(Map.Entry::getKey).orElse(ptc.getLowTapPosition());
    }
}

