/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.google.re2j.Pattern;
import com.powsybl.cgmes.conversion.CgmesReports;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.CgmesTapChangersAdder;
import com.powsybl.cgmes.extensions.CgmesTopologyKind;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PropertiesHolder;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CgmesExportUtil {
    private static final DecimalFormatSymbols DOUBLE_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.##############", DOUBLE_FORMAT_SYMBOLS);
    private static final DecimalFormat SCIENTIFIC_FORMAT = new DecimalFormat("0.######E0", DOUBLE_FORMAT_SYMBOLS);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyy-MM-dd'T'HH:mm:ssXXX").withZone(ZoneOffset.UTC);
    private static final Pattern CIM_MRID_PATTERN = Pattern.compile((String)"(?i)_?[a-f\\d]{8}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{12}");
    private static final Pattern URN_UUID_PATTERN = Pattern.compile((String)"(?i)urn:uuid:[a-f\\d]{8}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{12}");
    private static final Pattern ENTSOE_BD_EXCEPTIONS_PATTERN1 = Pattern.compile((String)"(?i)[a-f\\d]{8}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{4}-[a-f\\d]{7}");
    private static final Pattern ENTSOE_BD_EXCEPTIONS_PATTERN2 = Pattern.compile((String)"(?i)[a-f\\d]{8}[a-f\\d]{4}[a-f\\d]{4}[a-f\\d]{4}[a-f\\d]{12}");
    private static final Logger LOG = LoggerFactory.getLogger(CgmesExportUtil.class);

    private CgmesExportUtil() {
    }

    private static double fixValue(double value, double defaultValue) {
        return Double.isNaN(value) ? defaultValue : value;
    }

    public static String format(double value) {
        return CgmesExportUtil.format(value, 0.0);
    }

    public static String format(double value, double defaultValue) {
        if (value >= 3.4028234663852886E38 || value <= -3.4028234663852886E38) {
            float value1 = value >= 3.4028234663852886E38 ? Float.MAX_VALUE : -3.4028235E38f;
            return CgmesExportUtil.scientificFormat(value1, defaultValue);
        }
        return DOUBLE_FORMAT.format(CgmesExportUtil.fixValue(value, defaultValue));
    }

    public static String scientificFormat(double value) {
        return CgmesExportUtil.scientificFormat(value, 0.0);
    }

    private static String scientificFormat(double value, double defaultValue) {
        return SCIENTIFIC_FORMAT.format(CgmesExportUtil.fixValue(value, defaultValue));
    }

    public static String format(int value) {
        return String.valueOf(value);
    }

    public static String format(boolean value) {
        return String.valueOf(value);
    }

    public static boolean isValidCimMasterRID(String id) {
        return CIM_MRID_PATTERN.matcher((CharSequence)id).matches() || URN_UUID_PATTERN.matcher((CharSequence)id).matches() || ENTSOE_BD_EXCEPTIONS_PATTERN1.matcher((CharSequence)id).matches() || ENTSOE_BD_EXCEPTIONS_PATTERN2.matcher((CharSequence)id).matches();
    }

    public static String getUniqueRandomId() {
        return UUID.randomUUID().toString();
    }

    public static void writeRdfRoot(String cimNamespace, String euPrefix, String euNamespace, XMLStreamWriter writer) throws XMLStreamException {
        writer.setPrefix(euPrefix, euNamespace);
        writer.setPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        writer.setPrefix("cim", cimNamespace);
        writer.setPrefix("md", "http://iec.ch/TC57/61970-552/ModelDescription/1#");
        writer.writeStartElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
        writer.writeNamespace(euPrefix, euNamespace);
        writer.writeNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        writer.writeNamespace("cim", cimNamespace);
        writer.writeNamespace("md", "http://iec.ch/TC57/61970-552/ModelDescription/1#");
    }

    public static void initializeModelId(Network network, CgmesMetadataModel model, CgmesExportContext context) {
        CgmesObjectReference[] modelRef = new CgmesObjectReference[]{CgmesObjectReference.refTyped(network), CgmesObjectReference.ref(model.getSubset()), CgmesObjectReference.ref(DATE_TIME_FORMATTER.format(context.getScenarioTime())), CgmesObjectReference.ref(String.valueOf(model.getVersion())), CgmesObjectReference.ref(context.getBusinessProcess()), CgmesObjectReference.Part.FULL_MODEL};
        String modelId = "urn:uuid:" + context.getNamingStrategy().getCgmesId(modelRef);
        model.setId(modelId);
    }

    public static void writeModelDescription(Network network, CgmesSubset subset, XMLStreamWriter writer, CgmesMetadataModel modelDescription, CgmesExportContext context) throws XMLStreamException {
        if (modelDescription.getId() == null || modelDescription.getId().isEmpty()) {
            CgmesExportUtil.initializeModelId(network, modelDescription, context);
        }
        writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "FullModel");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", modelDescription.getId());
        CgmesReports.exportedModelIdentifierReport(context.getReportNode(), modelDescription.getId(), subset.getIdentifier(), network.getId());
        writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.scenarioTime");
        writer.writeCharacters(DATE_TIME_FORMATTER.format(context.getScenarioTime()));
        writer.writeEndElement();
        writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.created");
        writer.writeCharacters(DATE_TIME_FORMATTER.format(ZonedDateTime.now()));
        writer.writeEndElement();
        if (modelDescription.getDescription() != null) {
            writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.description");
            writer.writeCharacters(modelDescription.getDescription());
            writer.writeEndElement();
        }
        writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.version");
        writer.writeCharacters(CgmesExportUtil.format(modelDescription.getVersion()));
        writer.writeEndElement();
        for (String dependentOn : modelDescription.getDependentOn()) {
            writer.writeEmptyElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.DependentOn");
            writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", dependentOn);
        }
        for (String supersedes : modelDescription.getSupersedes()) {
            writer.writeEmptyElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.Supersedes");
            writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", supersedes);
        }
        if (subset == CgmesSubset.EQUIPMENT && context.getTopologyKind() == CgmesTopologyKind.NODE_BREAKER && context.getCimVersion() < 100) {
            modelDescription.addProfiles(List.of(context.getCim().getProfileUri("EQ_OP")));
        }
        for (String profile : modelDescription.getProfiles()) {
            writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.profile");
            writer.writeCharacters(profile);
            writer.writeEndElement();
        }
        writer.writeStartElement("http://iec.ch/TC57/61970-552/ModelDescription/1#", "Model.modelingAuthoritySet");
        writer.writeCharacters(modelDescription.getModelingAuthoritySet());
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static String toRdfId(String id, CgmesExportContext context) {
        return context.encode((String)(id.startsWith("_") ? id : "_" + id));
    }

    private static String toMasterResourceId(String id, CgmesExportContext context) {
        return context.encode(id.startsWith("_") ? id.substring(1) : id);
    }

    public static void writeStartId(String className, String id, boolean writeMasterResourceId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        writer.writeStartElement(cimNamespace, className);
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID", CgmesExportUtil.toRdfId(id, context));
        if (writeMasterResourceId && context.getCim().getVersion() >= 100) {
            writer.writeStartElement(cimNamespace, "IdentifiedObject.mRID");
            writer.writeCharacters(CgmesExportUtil.toMasterResourceId(id, context));
            writer.writeEndElement();
        }
    }

    public static void writeStartIdName(String className, String id, String name, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartId(className, id, true, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "IdentifiedObject.name");
        writer.writeCharacters(name.length() > 32 ? name.substring(0, 32) : name);
        writer.writeEndElement();
    }

    public static void writeReference(String refName, String referredId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        writer.writeEmptyElement(cimNamespace, refName);
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "#" + CgmesExportUtil.toRdfId(referredId, context));
    }

    public static void writeStartAbout(String className, String id, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        writer.writeStartElement(cimNamespace, className);
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", "#" + CgmesExportUtil.toRdfId(id, context));
    }

    public static String loadClassName(Load load) {
        String originalClassName = load.getProperty("CGMES.originalClass", "undefined");
        double p0 = load.getP0();
        LoadDetail loadDetail = (LoadDetail)load.getExtension(LoadDetail.class);
        if (originalClassName.equals("AsynchronousMachine") || originalClassName.equals("SvInjection") || originalClassName.equals("EnergySource") && p0 <= 0.0 || originalClassName.equals("EnergyConsumer") && p0 >= 0.0 && !CgmesExportUtil.isConformLoad(loadDetail) && !CgmesExportUtil.isNonConformLoad(loadDetail) || originalClassName.equals("ConformLoad") && p0 >= 0.0 && !CgmesExportUtil.isNonConformLoad(loadDetail) || originalClassName.equals("NonConformLoad") && p0 >= 0.0 && !CgmesExportUtil.isConformLoad(loadDetail) || originalClassName.equals("StationSupply") && p0 >= 0.0 && !CgmesExportUtil.isConformLoad(loadDetail) && !CgmesExportUtil.isNonConformLoad(loadDetail)) {
            return originalClassName;
        }
        return CgmesExportUtil.calculatedLoadClassName(p0, loadDetail);
    }

    private static String calculatedLoadClassName(double p0, LoadDetail loadDetail) {
        return p0 < 0.0 ? "EnergySource" : CgmesExportUtil.loadDetailClassName(loadDetail);
    }

    public static String loadDetailClassName(LoadDetail loadDetail) {
        if (loadDetail != null) {
            if (CgmesExportUtil.isConformLoad(loadDetail)) {
                return "ConformLoad";
            }
            if (CgmesExportUtil.isNonConformLoad(loadDetail)) {
                return "NonConformLoad";
            }
            return "NonConformLoad";
        }
        LOG.warn("It is not possible to determine the type of load");
        return "EnergyConsumer";
    }

    private static boolean isConformLoad(LoadDetail loadDetail) {
        return loadDetail != null && loadDetail.getFixedActivePower() == 0.0 && loadDetail.getFixedReactivePower() == 0.0 && (loadDetail.getVariableActivePower() != 0.0 || loadDetail.getVariableReactivePower() != 0.0);
    }

    private static boolean isNonConformLoad(LoadDetail loadDetail) {
        return loadDetail != null && loadDetail.getVariableActivePower() == 0.0 && loadDetail.getVariableReactivePower() == 0.0 && (loadDetail.getFixedActivePower() != 0.0 || loadDetail.getFixedReactivePower() != 0.0);
    }

    public static String switchClassname(SwitchKind kind) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case SwitchKind.BREAKER -> "Breaker";
            case SwitchKind.DISCONNECTOR -> "Disconnector";
            case SwitchKind.LOAD_BREAK_SWITCH -> "LoadBreakSwitch";
        };
    }

    public static int getTerminalSequenceNumber(Terminal t) {
        Connectable c = t.getConnectable();
        if (c.getTerminals().size() == 1) {
            return 1;
        }
        if (c instanceof Branch) {
            Branch branch = (Branch)c;
            return branch.getSide(t).getNum();
        }
        if (c instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)c;
            return twt.getSide(t).getNum();
        }
        throw new PowsyblException("Unexpected Connectable instance: " + String.valueOf(c.getClass()));
    }

    public static boolean isConverterStationRectifier(HvdcConverterStation<?> converterStation) {
        if (converterStation.getHvdcLine().getConvertersMode().equals((Object)HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER)) {
            return converterStation.getHvdcLine().getConverterStation1().equals(converterStation);
        }
        return converterStation.getHvdcLine().getConverterStation2().equals(converterStation);
    }

    public static String converterClassName(HvdcConverterStation<?> converterStation) {
        if (converterStation instanceof LccConverterStation) {
            return "CsConverter";
        }
        if (converterStation instanceof VscConverterStation) {
            return "VsConverter";
        }
        throw new PowsyblException("Invalid converter type");
    }

    public static <C extends Connectable<C>> Optional<String> cgmesTapChangerType(C eq, String tcId) {
        CgmesTapChanger cgmesTc;
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)eq.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && (cgmesTc = cgmesTcs.getTapChanger(tcId)) != null) {
            return Optional.ofNullable(cgmesTc.getType());
        }
        return Optional.empty();
    }

    public static <C extends Connectable<C>> void setCgmesTapChangerType(C eq, String tapChangerId, String type) {
        CgmesTapChanger cgmesTc;
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)eq.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && (cgmesTc = cgmesTcs.getTapChanger(tapChangerId)) != null) {
            cgmesTc.setType(type);
        }
    }

    static void addUpdateCgmesTapChangerExtension(TwoWindingsTransformer twt, CgmesExportContext context) {
        twt.getOptionalRatioTapChanger().ifPresent(rtc -> CgmesExportUtil.addTapChangerExtension(twt, "RatioTapChanger", CgmesExportUtil.getTapChangerId(twt, "RatioTapChanger", context), rtc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(rtc), context));
        twt.getOptionalPhaseTapChanger().ifPresent(ptc -> CgmesExportUtil.addTapChangerExtension(twt, "PhaseTapChanger", CgmesExportUtil.getTapChangerId(twt, "PhaseTapChanger", context), ptc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(ptc), context));
    }

    static void addUpdateCgmesTapChangerExtension(ThreeWindingsTransformer twt, CgmesExportContext context) {
        twt.getLeg1().getOptionalRatioTapChanger().ifPresent(rtc -> CgmesExportUtil.addTapChangerExtension(twt, "RatioTapChanger", CgmesExportUtil.getTapChangerId(twt, "RatioTapChanger", 1, context), rtc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(rtc), context));
        twt.getLeg1().getOptionalPhaseTapChanger().ifPresent(ptc -> CgmesExportUtil.addTapChangerExtension(twt, "PhaseTapChanger", CgmesExportUtil.getTapChangerId(twt, "PhaseTapChanger", 1, context), ptc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(ptc), context));
        twt.getLeg2().getOptionalRatioTapChanger().ifPresent(rtc -> CgmesExportUtil.addTapChangerExtension(twt, "RatioTapChanger", CgmesExportUtil.getTapChangerId(twt, "RatioTapChanger", 2, context), rtc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(rtc), context));
        twt.getLeg2().getOptionalPhaseTapChanger().ifPresent(ptc -> CgmesExportUtil.addTapChangerExtension(twt, "PhaseTapChanger", CgmesExportUtil.getTapChangerId(twt, "PhaseTapChanger", 2, context), ptc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(ptc), context));
        twt.getLeg3().getOptionalRatioTapChanger().ifPresent(rtc -> CgmesExportUtil.addTapChangerExtension(twt, "RatioTapChanger", CgmesExportUtil.getTapChangerId(twt, "RatioTapChanger", 3, context), rtc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(rtc), context));
        twt.getLeg3().getOptionalPhaseTapChanger().ifPresent(ptc -> CgmesExportUtil.addTapChangerExtension(twt, "PhaseTapChanger", CgmesExportUtil.getTapChangerId(twt, "PhaseTapChanger", 3, context), ptc.getTapPosition(), CgmesExportUtil.regulatingControlIsDefined(ptc), context));
    }

    private static <C extends Connectable<C>> String getTapChangerId(C twt, String cgmesTapChangerTag, CgmesExportContext context) {
        String aliasType1 = "CGMES." + cgmesTapChangerTag + "1";
        Optional optionalTapChangerId1 = twt.getAliasFromType(aliasType1);
        if (optionalTapChangerId1.isPresent()) {
            return (String)optionalTapChangerId1.get();
        }
        String aliasType2 = "CGMES." + cgmesTapChangerTag + "2";
        Optional optionalTapChangerId2 = twt.getAliasFromType(aliasType2);
        if (optionalTapChangerId2.isEmpty()) {
            CgmesObjectReference.Part ratioPhasePart = Objects.equals(cgmesTapChangerTag, "RatioTapChanger") ? CgmesObjectReference.Part.RATIO_TAP_CHANGER : CgmesObjectReference.Part.PHASE_TAP_CHANGER;
            String newTapChangerId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(twt), ratioPhasePart);
            twt.addAlias(newTapChangerId, aliasType1);
            return newTapChangerId;
        }
        return (String)optionalTapChangerId2.get();
    }

    private static <C extends Connectable<C>> String getTapChangerId(C twt, String cgmesTapChangerTag, int endNumber, CgmesExportContext context) {
        String aliasType = "CGMES." + cgmesTapChangerTag + endNumber;
        Optional optionalTapChangerId = twt.getAliasFromType(aliasType);
        if (optionalTapChangerId.isEmpty()) {
            CgmesObjectReference.Part ratioPhasePart = Objects.equals(cgmesTapChangerTag, "RatioTapChanger") ? CgmesObjectReference.Part.RATIO_TAP_CHANGER : CgmesObjectReference.Part.PHASE_TAP_CHANGER;
            String newTapChangerId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(twt), ratioPhasePart);
            twt.addAlias(newTapChangerId, aliasType);
            return newTapChangerId;
        }
        return (String)optionalTapChangerId.get();
    }

    static boolean regulatingControlIsDefined(RatioTapChanger rtc) {
        return !Double.isNaN(rtc.getRegulationValue()) && rtc.getRegulationTerminal() != null;
    }

    static boolean regulatingControlIsDefined(PhaseTapChanger ptc) {
        return !Double.isNaN(ptc.getRegulationValue()) && !Double.isNaN(ptc.getTargetDeadband()) && ptc.getRegulationTerminal() != null;
    }

    static boolean targetDeadbandIsDefined(double targetDeadband) {
        return !Double.isNaN(targetDeadband) && targetDeadband >= 0.0;
    }

    private static <C extends Connectable<C>> void addTapChangerExtension(C twt, String cgmesTapChangerTag, String tapChangerId, int tapPosition, boolean regulatingControlIsDefined, CgmesExportContext context) {
        CgmesTapChangers cgmesTapChangers = (CgmesTapChangers)twt.getExtension(CgmesTapChangers.class);
        if (cgmesTapChangers == null) {
            ((CgmesTapChangersAdder)twt.newExtension(CgmesTapChangersAdder.class)).add();
            cgmesTapChangers = (CgmesTapChangers)twt.getExtension(CgmesTapChangers.class);
        }
        CgmesObjectReference.Part refTapChanger = Objects.equals(cgmesTapChangerTag, "RatioTapChanger") ? CgmesObjectReference.Part.RATIO_TAP_CHANGER : CgmesObjectReference.Part.PHASE_TAP_CHANGER;
        CgmesTapChanger cgmesTapChanger = cgmesTapChangers.getTapChanger(tapChangerId);
        if (cgmesTapChanger == null) {
            cgmesTapChanger = cgmesTapChangers.newTapChanger().setId(tapChangerId).setStep(tapPosition).add();
        }
        if (regulatingControlIsDefined && cgmesTapChanger.getControlId() == null) {
            cgmesTapChanger.setControlId(context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(twt), refTapChanger, CgmesObjectReference.Part.REGULATING_CONTROL));
        }
    }

    public static String getTerminalId(Terminal t, CgmesExportContext context) {
        Object aliasType;
        Connectable c = t.getConnectable();
        if (c instanceof DanglingLine) {
            aliasType = "CGMES.Terminal1";
        } else {
            int sequenceNumber = CgmesExportUtil.getTerminalSequenceNumber(t);
            aliasType = "CGMES.Terminal" + sequenceNumber;
        }
        return context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)c, (String)aliasType);
    }

    public static List<DanglingLine> getBoundaryDanglingLines(Network network) {
        return network.getBoundaryElements().stream().filter(DanglingLine.class::isInstance).map(DanglingLine.class::cast).sorted(Comparator.comparing(Identifiable::getId)).toList();
    }

    public static boolean isEquivalentShuntWithZeroSectionCount(Connectable<?> c) {
        if (c instanceof ShuntCompensator) {
            ShuntCompensator shuntCompensator = (ShuntCompensator)c;
            return "true".equals(c.getProperty("CGMES.isEquivalentShunt")) && shuntCompensator.getSectionCount() == 0;
        }
        return false;
    }

    static <I extends ReactiveLimitsHolder & Injection<I>> ReactiveCapabilityCurve obtainCurve(I i) {
        return i.getReactiveLimits().getKind().equals((Object)ReactiveLimitsKind.CURVE) ? (ReactiveCapabilityCurve)i.getReactiveLimits(ReactiveCapabilityCurve.class) : null;
    }

    static <I extends ReactiveLimitsHolder & Injection<I>> String obtainSynchronousMachineKind(I i, double minP, double maxP, ReactiveCapabilityCurve curve) {
        String kind = ((PropertiesHolder)i).getProperty("CGMES.synchronousMachineType");
        String calculatedKind = CgmesExportUtil.obtainCalculatedSynchronousMachineKind(minP, maxP, curve, kind);
        if (kind == null) {
            return calculatedKind;
        }
        if (calculatedKind.contains(kind)) {
            return kind;
        }
        LOG.warn("original synchronousMachineKind {} has been modified to {} according to the limits", (Object)kind, (Object)calculatedKind);
        return calculatedKind;
    }

    static String obtainCalculatedSynchronousMachineKind(double minP, double maxP, ReactiveCapabilityCurve curve, String originalKind) {
        double max;
        double min = curve != null ? curve.getMinP() : minP;
        double d = max = curve != null ? curve.getMaxP() : maxP;
        String kind = min > 0.0 ? "generator" : (max < 0.0 ? "motor" : (min == 0.0 && max == 0.0 ? "condenser" : (min == 0.0 ? "generatorOrCondenser" : (max == 0.0 ? "motorOrCondenser" : (originalKind != null && (originalKind.equals("generatorOrMotor") || originalKind.equals("generatorOrCondenserOrMotor")) ? originalKind : "generatorOrCondenserOrMotor")))));
        return kind;
    }

    public static boolean isValidVoltageSetpoint(double v) {
        return Double.isFinite(v) && v > 0.0;
    }

    public static boolean isValidReactivePowerSetpoint(double q) {
        return Double.isFinite(q);
    }

    public static String getGeneratorRegulatingControlMode(Generator generator, RemoteReactivePowerControl rrpc) {
        if (rrpc == null) {
            return "RegulatingControlModeKind.voltage";
        }
        boolean enabledVoltageControl = generator.isVoltageRegulatorOn();
        boolean enabledReactivePowerControl = rrpc.isEnabled();
        if (enabledVoltageControl) {
            return "RegulatingControlModeKind.voltage";
        }
        if (enabledReactivePowerControl) {
            return "RegulatingControlModeKind.reactivePower";
        }
        boolean validVoltageSetpoint = CgmesExportUtil.isValidVoltageSetpoint(generator.getTargetV());
        boolean validReactiveSetpoint = CgmesExportUtil.isValidReactivePowerSetpoint(rrpc.getTargetQ());
        if (validReactiveSetpoint && !validVoltageSetpoint) {
            return "RegulatingControlModeKind.reactivePower";
        }
        return "RegulatingControlModeKind.voltage";
    }

    public static String getSvcMode(StaticVarCompensator svc) {
        if (svc.getRegulationMode().equals((Object)StaticVarCompensator.RegulationMode.VOLTAGE)) {
            return "RegulatingControlModeKind.voltage";
        }
        if (svc.getRegulationMode().equals((Object)StaticVarCompensator.RegulationMode.REACTIVE_POWER)) {
            return "RegulatingControlModeKind.reactivePower";
        }
        boolean validVoltageSetpoint = CgmesExportUtil.isValidVoltageSetpoint(svc.getVoltageSetpoint());
        boolean validReactiveSetpoint = CgmesExportUtil.isValidReactivePowerSetpoint(svc.getReactivePowerSetpoint());
        if (validReactiveSetpoint && !validVoltageSetpoint) {
            return "RegulatingControlModeKind.reactivePower";
        }
        return "RegulatingControlModeKind.voltage";
    }

    public static String getTcMode(RatioTapChanger rtc) {
        if (rtc.getRegulationMode() == null) {
            throw new PowsyblException("Regulation mode not defined for RTC.");
        }
        return switch (rtc.getRegulationMode()) {
            default -> throw new MatchException(null, null);
            case RatioTapChanger.RegulationMode.VOLTAGE -> "RegulatingControlModeKind.voltage";
            case RatioTapChanger.RegulationMode.REACTIVE_POWER -> "RegulatingControlModeKind.reactivePower";
        };
    }

    public static String getPhaseTapChangerRegulationMode(PhaseTapChanger ptc) {
        return switch (ptc.getRegulationMode()) {
            default -> throw new MatchException(null, null);
            case PhaseTapChanger.RegulationMode.CURRENT_LIMITER -> "RegulatingControlModeKind.currentFlow";
            case PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL -> "RegulatingControlModeKind.activePower";
        };
    }

    public static boolean isMinusOrMaxValue(double value) {
        return value == -1.7976931348623157E308 || value == Double.MAX_VALUE;
    }
}

