/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.powsybl.cgmes.conversion.CgmesExport;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.iidm.network.util.SwitchesFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateVariablesExport {
    private static final String SV_VOLTAGE_ANGLE = "SvVoltage.angle";
    private static final String SV_VOLTAGE_V = "SvVoltage.v";
    private static final String SV_VOLTAGE_TOPOLOGICAL_NODE = "SvVoltage.TopologicalNode";
    private static final Logger LOG = LoggerFactory.getLogger(StateVariablesExport.class);

    public static void write(Network network, XMLStreamWriter writer) {
        StateVariablesExport.write(network, writer, new CgmesExportContext(network).setExportEquipment(false));
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context) {
        CgmesMetadataModel model = CgmesExport.initializeModelForExport(network, CgmesSubset.STATE_VARIABLES, context, true, false);
        StateVariablesExport.write(network, writer, context, model);
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context, CgmesMetadataModel model) {
        try {
            String cimNamespace = context.getCim().getNamespace();
            CgmesExportUtil.writeRdfRoot(cimNamespace, context.getCim().getEuPrefix(), context.getCim().getEuNamespace(), writer);
            if (context.getCimVersion() >= 16) {
                CgmesExportUtil.writeModelDescription(network, CgmesSubset.STATE_VARIABLES, writer, model, context);
                StateVariablesExport.writeTopologicalIslands(network, context, writer);
            }
            StateVariablesExport.writeVoltagesForTopologicalNodes(network, context, writer);
            StateVariablesExport.writeVoltagesForBoundaryNodes(network, cimNamespace, writer, context);
            StateVariablesExport.writeSvInjectionsForSlacks(network, cimNamespace, writer, context);
            StateVariablesExport.writePowerFlows(network, cimNamespace, writer, context);
            StateVariablesExport.writeShuntCompensatorSections(network, cimNamespace, writer, context);
            StateVariablesExport.writeTapSteps(network, cimNamespace, writer, context);
            StateVariablesExport.writeStatus(network, cimNamespace, writer, context);
            StateVariablesExport.writeConverters(network, cimNamespace, writer, context);
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeTopologicalIslands(Network network, CgmesExportContext context, XMLStreamWriter writer) throws XMLStreamException {
        Map<String, String> angleRefs = StateVariablesExport.buildAngleRefs(network, context);
        List<TopologicalIsland> islands = StateVariablesExport.buildIslands(network, context);
        String cimNamespace = context.getCim().getNamespace();
        for (TopologicalIsland island : islands) {
            if (!angleRefs.containsKey(island.key)) {
                Supplier<String> log = () -> String.format("Synchronous component  %s does not have a defined angle reference bus: it is ignored", island.key);
                LOG.info(log.get());
                continue;
            }
            String islandId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.ref(island.key), CgmesObjectReference.Part.TOPOLOGICAL_ISLAND);
            CgmesExportUtil.writeStartIdName("TopologicalIsland", islandId, islandId, cimNamespace, writer, context);
            CgmesExportUtil.writeReference("TopologicalIsland.AngleRefTopologicalNode", angleRefs.get(island.key), cimNamespace, writer, context);
            if (context.isExportLoadFlowStatus()) {
                writer.writeStartElement(cimNamespace, "IdentifiedObject.description");
                writer.writeCharacters(island.loadFlowStatus);
                writer.writeEndElement();
            }
            for (String tn : island.topologicalNodes) {
                CgmesExportUtil.writeReference("TopologicalIsland.TopologicalNodes", tn, cimNamespace, writer, context);
            }
            writer.writeEndElement();
        }
    }

    private static Map<String, String> buildAngleRefs(Network network, CgmesExportContext context) {
        HashMap<String, String> angleRefs = new HashMap<String, String>();
        ReferenceTerminals.getTerminals((Network)network).forEach(t -> StateVariablesExport.buildAngleRefs(t, (Map<String, String>)angleRefs, context));
        return angleRefs;
    }

    private static void buildAngleRefs(Terminal referenceTerminal, Map<String, String> angleRefs, CgmesExportContext context) {
        if (referenceTerminal != null) {
            Bus bus = referenceTerminal.getBusBreakerView().getBus();
            if (bus != null && bus.getSynchronousComponent() != null) {
                StateVariablesExport.buildAngleRefs(bus.getSynchronousComponent().getNum(), bus, angleRefs, context);
            } else if (bus != null) {
                StateVariablesExport.buildAngleRefs(bus, angleRefs, context);
            } else {
                Supplier<String> message = () -> String.format("Reference terminal at equipment %s is not connected and is not used to export angle references", referenceTerminal.getConnectable().getId());
                LOG.info(message.get());
            }
        }
    }

    private static void buildAngleRefs(int synchronousComponentNum, Bus bus, Map<String, String> angleRefs, CgmesExportContext context) {
        String componentNum = String.valueOf(synchronousComponentNum);
        if (angleRefs.containsKey(componentNum)) {
            Supplier<String> log = () -> String.format("Several slack buses are defined for synchronous component %s: only first slack bus (%s) is taken into account", componentNum, angleRefs.get(componentNum));
            LOG.info(log.get());
            return;
        }
        String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus);
        angleRefs.put(componentNum, topologicalNodeId);
    }

    private static void buildAngleRefs(Bus bus, Map<String, String> angleRefs, CgmesExportContext context) {
        String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus);
        angleRefs.put(topologicalNodeId, topologicalNodeId);
    }

    private static List<TopologicalIsland> buildIslands(Network network, CgmesExportContext context) {
        HashMap<String, TopologicalIsland> islands = new HashMap<String, TopologicalIsland>();
        for (Bus b : network.getBusBreakerView().getBuses()) {
            ArrayList<String> topologicalNodeIds = new ArrayList<String>();
            String busTnId = context.getNamingStrategy().getCgmesId((Identifiable<?>)b);
            topologicalNodeIds.add(busTnId);
            b.getDanglingLines().forEach(dl -> topologicalNodeIds.add(dl.getProperty("CGMES.TopologicalNode_Boundary")));
            if (b.getSynchronousComponent() != null) {
                String key = String.valueOf(b.getSynchronousComponent().getNum());
                TopologicalIsland island = islands.computeIfAbsent(key, k -> TopologicalIsland.fromSynchronousComponent(k, context));
                for (String topologicalNodeId : topologicalNodeIds) {
                    island.addNode(topologicalNodeId, b, context.isExportLoadFlowStatus());
                }
                continue;
            }
            islands.put(busTnId, TopologicalIsland.fromTopologicalNodes(topologicalNodeIds, context));
        }
        return islands.values().stream().toList();
    }

    private static void writeVoltagesForTopologicalNodes(Network network, CgmesExportContext context, XMLStreamWriter writer) throws XMLStreamException {
        String cimNamespace = context.getCim().getNamespace();
        for (Map.Entry<String, Bus> e : context.getTopologicalNodes(network).entrySet()) {
            StateVariablesExport.writeVoltage(e.getKey(), e.getValue() != null ? e.getValue().getV() : 0.0, e.getValue() != null ? e.getValue().getAngle() : 0.0, cimNamespace, writer, context);
        }
    }

    private static void writeVoltagesForBoundaryNodes(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (DanglingLine dl : network.getDanglingLines(DanglingLineFilter.ALL)) {
            Bus b = dl.getTerminal().getBusView().getBus();
            String topologicalNode = dl.getProperty("CGMES.TopologicalNode_Boundary");
            if (topologicalNode == null) continue;
            if (dl.hasProperty("v") && dl.hasProperty("angle")) {
                StateVariablesExport.writeVoltage(topologicalNode, Double.parseDouble(dl.getProperty("v", "NaN")), Double.parseDouble(dl.getProperty("angle", "NaN")), cimNamespace, writer, context);
                continue;
            }
            if (b != null) {
                StateVariablesExport.writeVoltage(topologicalNode, dl.getBoundary().getV(), dl.getBoundary().getAngle(), cimNamespace, writer, context);
                continue;
            }
            StateVariablesExport.writeVoltage(topologicalNode, 0.0, 0.0, cimNamespace, writer, context);
        }
    }

    private static void writeVoltage(String topologicalNode, double v, double angle, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartId("SvVoltage", CgmesExportUtil.getUniqueRandomId(), false, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, SV_VOLTAGE_ANGLE);
        writer.writeCharacters(CgmesExportUtil.format(angle));
        writer.writeEndElement();
        writer.writeStartElement(cimNamespace, SV_VOLTAGE_V);
        writer.writeCharacters(CgmesExportUtil.format(v));
        writer.writeEndElement();
        CgmesExportUtil.writeReference(SV_VOLTAGE_TOPOLOGICAL_NODE, topologicalNode, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeSvInjectionsForSlacks(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        if (context.isExportSvInjectionsForSlacks()) {
            for (VoltageLevel vl : network.getVoltageLevels()) {
                Bus bus;
                Optional<Bus> optionalBusViewBus;
                SlackTerminal st = (SlackTerminal)vl.getExtension(SlackTerminal.class);
                if (st == null || st.getTerminal() == null || !(optionalBusViewBus = BusTools.getBusViewBus(bus = st.getTerminal().getBusBreakerView().getBus())).isPresent()) continue;
                Bus busViewBus = optionalBusViewBus.get();
                StateVariablesExport.computeMismatchAndWriteSvInjection(bus, busViewBus, cimNamespace, writer, context);
            }
        }
    }

    private static void computeMismatchAndWriteSvInjection(Bus bus, Bus busViewBus, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        double sumP = BusTools.sum(busViewBus, Terminal::getP);
        double sumQ = BusTools.sum(busViewBus, Terminal::getQ);
        if (Math.abs(sumP) > context.getMaxPMismatchConverged() || Math.abs(sumQ) > context.getMaxQMismatchConverged()) {
            String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus);
            String svInjectionId = CgmesExportUtil.getUniqueRandomId();
            StateVariablesExport.writeSvInjection(svInjectionId, -sumP, -sumQ, topologicalNodeId, cimNamespace, writer, context);
        }
    }

    private static void writePowerFlows(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        StateVariablesExport.writeInjectionsPowerFlows(network, cimNamespace, writer, context, Network::getLoadStream);
        StateVariablesExport.writeInjectionsPowerFlows(network, cimNamespace, writer, context, Network::getGeneratorStream);
        StateVariablesExport.writeInjectionsPowerFlows(network, cimNamespace, writer, context, Network::getBatteryStream);
        StateVariablesExport.writeInjectionsPowerFlows(network, cimNamespace, writer, context, Network::getShuntCompensatorStream);
        StateVariablesExport.writeInjectionsPowerFlows(network, cimNamespace, writer, context, Network::getStaticVarCompensatorStream);
        for (Load load : network.getLoads()) {
            if (!load.isFictitious()) continue;
            StateVariablesExport.writeSvInjection(load, cimNamespace, writer, context);
        }
        HashMap equivalentInjectionTerminalP = new HashMap();
        HashMap equivalentInjectionTerminalQ = new HashMap();
        network.getDanglingLines(DanglingLineFilter.ALL).forEach(dl -> {
            if (context.exportBoundaryPowerFlows()) {
                StateVariablesExport.writePowerFlowTerminalFromAlias(dl, "CGMES.Terminal_Boundary", dl.getBoundary().getP(), dl.getBoundary().getQ(), cimNamespace, writer, context);
            }
            StateVariablesExport.writePowerFlowTerminalFromAlias(dl, "CGMES.Terminal1", dl.getTerminal().getP(), dl.getTerminal().getQ(), cimNamespace, writer, context);
            context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjectionTerminal");
            equivalentInjectionTerminalP.compute(context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjectionTerminal"), (k, v) -> v == null ? -dl.getBoundary().getP() : v - dl.getBoundary().getP());
            equivalentInjectionTerminalQ.compute(context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjectionTerminal"), (k, v) -> v == null ? -dl.getBoundary().getQ() : v - dl.getBoundary().getQ());
        });
        equivalentInjectionTerminalP.keySet().forEach(eiId -> StateVariablesExport.writePowerFlow(eiId, (Double)equivalentInjectionTerminalP.get(eiId), (Double)equivalentInjectionTerminalQ.get(eiId), cimNamespace, writer, context));
        network.getTwoWindingsTransformerStream().forEach(b -> StateVariablesExport.writeConnectableBranchPowerFlow(cimNamespace, writer, context, b));
        network.getLineStream().forEach(b -> StateVariablesExport.writeConnectableBranchPowerFlow(cimNamespace, writer, context, b));
        network.getThreeWindingsTransformerStream().forEach(twt -> {
            StateVariablesExport.writePowerFlowTerminalFromAlias(twt, "CGMES.Terminal1", twt.getLeg1().getTerminal(), cimNamespace, writer, context);
            StateVariablesExport.writePowerFlowTerminalFromAlias(twt, "CGMES.Terminal2", twt.getLeg2().getTerminal(), cimNamespace, writer, context);
            StateVariablesExport.writePowerFlowTerminalFromAlias(twt, "CGMES.Terminal3", twt.getLeg3().getTerminal(), cimNamespace, writer, context);
        });
        if (context.exportFlowsForSwitches()) {
            network.getVoltageLevelStream().forEach(vl -> StateVariablesExport.writePowerFlowForSwitchesInVoltageLevel(vl, cimNamespace, writer, context));
        }
    }

    private static void writePowerFlowForSwitchesInVoltageLevel(VoltageLevel vl, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        SlackTerminal st = (SlackTerminal)vl.getExtension(SlackTerminal.class);
        Terminal slackTerminal = st != null ? st.getTerminal() : null;
        SwitchesFlow swflows = new SwitchesFlow(vl, slackTerminal);
        vl.getSwitches().forEach(sw -> {
            if (context.isExportedEquipment((Identifiable<?>)sw)) {
                StateVariablesExport.writePowerFlowTerminalFromAlias(sw, "CGMES.Terminal1", swflows.getP1(sw.getId()), swflows.getQ1(sw.getId()), cimNamespace, writer, context);
                StateVariablesExport.writePowerFlowTerminalFromAlias(sw, "CGMES.Terminal2", swflows.getP2(sw.getId()), swflows.getQ2(sw.getId()), cimNamespace, writer, context);
            }
        });
    }

    private static void writeConnectableBranchPowerFlow(String cimNamespace, XMLStreamWriter writer, CgmesExportContext context, Branch<?> b) {
        StateVariablesExport.writePowerFlowTerminalFromAlias(b, "CGMES.Terminal1", b.getTerminal1(), cimNamespace, writer, context);
        StateVariablesExport.writePowerFlowTerminalFromAlias(b, "CGMES.Terminal2", b.getTerminal2(), cimNamespace, writer, context);
    }

    private static <I extends Injection<I>> void writeInjectionsPowerFlows(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context, Function<Network, Stream<I>> getInjectionStream) {
        getInjectionStream.apply(network).forEach(i -> {
            if (context.isExportedEquipment((Identifiable<?>)i)) {
                StateVariablesExport.writePowerFlow(i.getTerminal(), cimNamespace, writer, context);
            }
        });
    }

    private static void writePowerFlow(Terminal terminal, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        String cgmesTerminal = CgmesExportUtil.getTerminalId(terminal, context);
        if (cgmesTerminal != null) {
            StateVariablesExport.writePowerFlow(cgmesTerminal, terminal.getP(), terminal.getQ(), cimNamespace, writer, context);
        } else {
            LOG.error("No defined CGMES terminal for {}", (Object)terminal.getConnectable().getId());
        }
    }

    private static void writeSvInjection(Load load, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        Bus bus = load.getTerminal().getBusBreakerView().getBus();
        if (bus == null) {
            LOG.warn("Fictitious load does not have a BusView bus. No SvInjection is written");
        } else {
            String topologicalNode = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus);
            String svInjectionId = context.getNamingStrategy().getCgmesId((Identifiable<?>)load);
            StateVariablesExport.writeSvInjection(svInjectionId, load.getP0(), load.getQ0(), topologicalNode, cimNamespace, writer, context);
        }
    }

    private static void writePowerFlowTerminalFromAlias(Identifiable<?> c, String aliasTypeForTerminalId, Terminal t, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        StateVariablesExport.writePowerFlowTerminalFromAlias(c, aliasTypeForTerminalId, t.getP(), t.getQ(), cimNamespace, writer, context);
    }

    private static void writePowerFlowTerminalFromAlias(Identifiable<?> c, String aliasTypeForTerminalId, double p, double q, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        if (c.getAliasFromType(aliasTypeForTerminalId).isPresent()) {
            String cgmesTerminalId = context.getNamingStrategy().getCgmesIdFromAlias(c, aliasTypeForTerminalId);
            StateVariablesExport.writePowerFlow(cgmesTerminalId, p, q, cimNamespace, writer, context);
        } else {
            LOG.error("Exporting CGMES SvPowerFlow. Missing alias for {} {}: {}", new Object[]{c.getType(), c.getId(), aliasTypeForTerminalId});
        }
    }

    private static void writePowerFlow(String cgmesTerminalId, double p, double q, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            CgmesExportUtil.writeStartId("SvPowerFlow", CgmesExportUtil.getUniqueRandomId(), false, cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "SvPowerFlow.p");
            writer.writeCharacters(CgmesExportUtil.format(p));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "SvPowerFlow.q");
            writer.writeCharacters(CgmesExportUtil.format(q));
            writer.writeEndElement();
            CgmesExportUtil.writeReference("SvPowerFlow.Terminal", cgmesTerminalId, cimNamespace, writer, context);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeSvInjection(String svInjectionId, double p, double q, String topologicalNode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            CgmesExportUtil.writeStartId("SvInjection", svInjectionId, false, cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "SvInjection.pInjection");
            writer.writeCharacters(CgmesExportUtil.format(p));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "SvInjection.qInjection");
            writer.writeCharacters(CgmesExportUtil.format(q));
            writer.writeEndElement();
            CgmesExportUtil.writeReference("SvInjection.TopologicalNode", topologicalNode, cimNamespace, writer, context);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeShuntCompensatorSections(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (ShuntCompensator s : network.getShuntCompensators()) {
            if ("true".equals(s.getProperty("CGMES.isEquivalentShunt"))) continue;
            CgmesExportUtil.writeStartId("SvShuntCompensatorSections", CgmesExportUtil.getUniqueRandomId(), false, cimNamespace, writer, context);
            CgmesExportUtil.writeReference("SvShuntCompensatorSections.ShuntCompensator", context.getNamingStrategy().getCgmesId((Identifiable<?>)s), cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "SvShuntCompensatorSections.sections");
            writer.writeCharacters(CgmesExportUtil.format(s.findSolvedSectionCount().orElse(s.getSectionCount())));
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private static void writeTapSteps(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (TwoWindingsTransformer twt : network.getTwoWindingsTransformers()) {
            StateVariablesExport.writeTapStepsTwoWindingsTransformer(twt, cimNamespace, writer, context);
        }
        for (TwoWindingsTransformer twt : network.getThreeWindingsTransformers()) {
            StateVariablesExport.writeTapStepsThreeWindingsTransformer((ThreeWindingsTransformer)twt, cimNamespace, writer, context);
        }
    }

    private static void writeTapStepsTwoWindingsTransformer(TwoWindingsTransformer twt, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        int endNumber;
        if (twt.hasPhaseTapChanger()) {
            PhaseTapChanger phaseTapChanger = twt.getPhaseTapChanger();
            endNumber = twt.getAliasFromType("CGMES.PhaseTapChanger1").isPresent() ? 1 : 2;
            String ptcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.PhaseTapChanger" + endNumber);
            StateVariablesExport.writeSvTapStep(ptcId, phaseTapChanger.findSolvedTapPosition().orElse(phaseTapChanger.getTapPosition()), cimNamespace, writer, context);
            StateVariablesExport.writeSvTapStepHidden(twt, ptcId, cimNamespace, writer, context);
        }
        if (twt.hasRatioTapChanger()) {
            RatioTapChanger ratioTapChanger = twt.getRatioTapChanger();
            endNumber = twt.getAliasFromType("CGMES.RatioTapChanger1").isPresent() ? 1 : 2;
            String rtcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.RatioTapChanger" + endNumber);
            StateVariablesExport.writeSvTapStep(rtcId, ratioTapChanger.findSolvedTapPosition().orElse(ratioTapChanger.getTapPosition()), cimNamespace, writer, context);
            StateVariablesExport.writeSvTapStepHidden(twt, rtcId, cimNamespace, writer, context);
        }
    }

    private static void writeTapStepsThreeWindingsTransformer(ThreeWindingsTransformer twt, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        int endNumber = 1;
        for (ThreeWindingsTransformer.Leg leg : Arrays.asList(twt.getLeg1(), twt.getLeg2(), twt.getLeg3())) {
            if (leg.hasPhaseTapChanger()) {
                String ptcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.PhaseTapChanger" + endNumber);
                PhaseTapChanger phaseTapChanger = leg.getPhaseTapChanger();
                StateVariablesExport.writeSvTapStep(ptcId, phaseTapChanger.findSolvedTapPosition().orElse(phaseTapChanger.getTapPosition()), cimNamespace, writer, context);
                StateVariablesExport.writeSvTapStepHidden(twt, ptcId, cimNamespace, writer, context);
            }
            if (leg.hasRatioTapChanger()) {
                String rtcId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)twt, "CGMES.RatioTapChanger" + endNumber);
                RatioTapChanger ratioTapChanger = leg.getRatioTapChanger();
                StateVariablesExport.writeSvTapStep(rtcId, ratioTapChanger.findTapPosition().orElse(ratioTapChanger.getTapPosition()), cimNamespace, writer, context);
                StateVariablesExport.writeSvTapStepHidden(twt, rtcId, cimNamespace, writer, context);
            }
            ++endNumber;
        }
    }

    private static <C extends Connectable<C>> void writeSvTapStepHidden(Connectable<C> eq, String tcId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesTapChangers cgmesTcs = (CgmesTapChangers)eq.getExtension(CgmesTapChangers.class);
        if (cgmesTcs != null && !context.isExportEquipment()) {
            for (CgmesTapChanger cgmesTc : cgmesTcs.getTapChangers()) {
                if (!cgmesTc.isHidden() || !cgmesTc.getCombinedTapChangerId().equals(tcId)) continue;
                int step = cgmesTc.getStep().orElseThrow(() -> new PowsyblException("Non null step expected for tap changer " + cgmesTc.getId()));
                StateVariablesExport.writeSvTapStep(cgmesTc.getId(), step, cimNamespace, writer, context);
            }
        }
    }

    private static void writeSvTapStep(String tapChangerId, int tapPosition, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartId("SvTapStep", CgmesExportUtil.getUniqueRandomId(), false, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, "SvTapStep.position");
        writer.writeCharacters(CgmesExportUtil.format(tapPosition));
        writer.writeEndElement();
        CgmesExportUtil.writeReference("SvTapStep.TapChanger", tapChangerId, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeStatus(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        if (!context.isCim16BusBranchExport()) {
            network.getConnectableStream().forEach(c -> {
                if (context.isExportedEquipment((Identifiable<?>)c)) {
                    StateVariablesExport.writeConnectableStatus(c, cimNamespace, writer, context);
                }
            });
        }
    }

    private static void writeConnectableStatus(Connectable<?> connectable, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        if (CgmesExportUtil.isEquivalentShuntWithZeroSectionCount(connectable)) {
            StateVariablesExport.writeStatus(Boolean.toString(false), context.getNamingStrategy().getCgmesId((Identifiable<?>)connectable), cimNamespace, writer, context);
            return;
        }
        StateVariablesExport.writeStatus(Boolean.toString(connectable.getTerminals().stream().anyMatch(Terminal::isConnected)), context.getNamingStrategy().getCgmesId((Identifiable<?>)connectable), cimNamespace, writer, context);
    }

    private static void writeStatus(String inService, String conductingEquipmentId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) {
        try {
            CgmesExportUtil.writeStartId("SvStatus", CgmesExportUtil.getUniqueRandomId(), false, cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "SvStatus.inService");
            writer.writeCharacters(inService);
            writer.writeEndElement();
            CgmesExportUtil.writeReference("SvStatus.ConductingEquipment", conductingEquipmentId, cimNamespace, writer, context);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeConverters(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (HvdcConverterStation converterStation : network.getHvdcConverterStations()) {
            CgmesExportUtil.writeStartAbout(CgmesExportUtil.converterClassName(converterStation), context.getNamingStrategy().getCgmesId((Identifiable<?>)converterStation), cimNamespace, writer, context);
            writer.writeStartElement(cimNamespace, "ACDCConverter.poleLossP");
            writer.writeCharacters(CgmesExportUtil.format(StateVariablesExport.getPoleLossP(converterStation)));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "ACDCConverter.idc");
            writer.writeCharacters(CgmesExportUtil.format(0));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "ACDCConverter.uc");
            writer.writeCharacters(CgmesExportUtil.format(0));
            writer.writeEndElement();
            writer.writeStartElement(cimNamespace, "ACDCConverter.udc");
            writer.writeCharacters(CgmesExportUtil.format(0));
            writer.writeEndElement();
            if (converterStation instanceof LccConverterStation) {
                writer.writeStartElement(cimNamespace, "CsConverter.alpha");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "CsConverter.gamma");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
            } else if (converterStation instanceof VscConverterStation) {
                writer.writeStartElement(cimNamespace, "VsConverter.delta");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
                writer.writeStartElement(cimNamespace, "VsConverter.uf");
                writer.writeCharacters(CgmesExportUtil.format(0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static double getPoleLossP(HvdcConverterStation<?> converterStation) {
        double poleLoss;
        HvdcLine hvdcLine = converterStation.getHvdcLine();
        if (CgmesExportUtil.isConverterStationRectifier(converterStation)) {
            double p = converterStation.getTerminal().getP();
            if (Double.isNaN(p)) {
                p = hvdcLine.getActivePowerSetpoint();
            }
            poleLoss = p * (double)converterStation.getLossFactor() / 100.0;
        } else {
            double p = converterStation.getTerminal().getP();
            if (!Double.isNaN(p)) {
                poleLoss = Math.abs(p) * (double)converterStation.getLossFactor() / (double)(100.0f - converterStation.getLossFactor());
            } else {
                p = hvdcLine.getActivePowerSetpoint();
                double otherConverterStationLossFactor = converterStation.getOtherConverterStation().map(HvdcConverterStation::getLossFactor).orElse(Float.valueOf(0.0f)).floatValue();
                double pDCRectifier = Math.abs(p) * (1.0 - otherConverterStationLossFactor / 100.0);
                double pDCInverter = pDCRectifier - HvdcUtils.getHvdcLineLosses((double)pDCRectifier, (double)hvdcLine.getNominalV(), (double)hvdcLine.getR());
                poleLoss = pDCInverter * (double)converterStation.getLossFactor() / 100.0;
            }
        }
        return poleLoss;
    }

    private StateVariablesExport() {
    }

    private static final class TopologicalIsland {
        static final String CONVERGED = "converged";
        static final String DIVERGED = "diverged";
        final String key;
        final List<String> topologicalNodes;
        String loadFlowStatus = "converged";
        final double maxPMismatchConverged;
        final double maxQMismatchConverged;
        final Map<Bus, Boolean> checkedBusViewBuses = new HashMap<Bus, Boolean>();
        final boolean checkConvergedInAllBuses;

        private TopologicalIsland(String key, List<String> topologicalNodes, CgmesExportContext context) {
            this.key = key;
            this.checkConvergedInAllBuses = false;
            this.topologicalNodes = topologicalNodes;
            this.maxPMismatchConverged = context.getMaxPMismatchConverged();
            this.maxQMismatchConverged = context.getMaxQMismatchConverged();
        }

        static TopologicalIsland fromSynchronousComponent(String key, CgmesExportContext context) {
            return new TopologicalIsland(key, new ArrayList<String>(), context);
        }

        static TopologicalIsland fromTopologicalNodes(List<String> topologicalNodes, CgmesExportContext context) {
            return new TopologicalIsland(topologicalNodes.get(0), topologicalNodes, context);
        }

        void addNode(String topologicalNode, Bus bus, boolean updateLoadFlowStatus) {
            this.topologicalNodes.add(topologicalNode);
            if (updateLoadFlowStatus) {
                this.updateLoadFlowStatus(bus);
            }
        }

        void updateLoadFlowStatus(Bus bus) {
            if (this.loadFlowStatus.equals(DIVERGED) && !this.checkConvergedInAllBuses) {
                return;
            }
            if (!(this.isValidVoltage(bus.getV()) && this.isValidAngle(bus.getAngle()) && this.isInAccordanceWithKirchhoffsFirstLaw(bus))) {
                this.loadFlowStatus = DIVERGED;
            }
        }

        boolean isValidVoltage(double v) {
            return v >= 0.01;
        }

        boolean isValidAngle(double a) {
            return Double.isFinite(a);
        }

        boolean isInAccordanceWithKirchhoffsFirstLaw(Bus bus) {
            boolean isInAccordance;
            Optional<Bus> optionalBusViewBus = BusTools.getBusViewBus(bus);
            if (optionalBusViewBus.isEmpty()) {
                LOG.error("Cannot check if bus is in accordance with Kirchhoff's first law. No BusView bus can be found for: {}", (Object)bus);
                return false;
            }
            Bus busViewBus = optionalBusViewBus.get();
            if (busViewBus.getConnectedTerminalCount() == 0 || BusTools.isSlack(busViewBus)) {
                return true;
            }
            if (this.checkedBusViewBuses.containsKey(busViewBus)) {
                return this.checkedBusViewBuses.get(busViewBus);
            }
            if (BusTools.hasAnyFinite(busViewBus, Terminal::getP) && BusTools.hasAnyFinite(busViewBus, Terminal::getQ)) {
                double sumP = BusTools.sum(busViewBus, Terminal::getP);
                double sumQ = BusTools.sum(busViewBus, Terminal::getQ);
                boolean bl = isInAccordance = Math.abs(sumP) <= this.maxPMismatchConverged && Math.abs(sumQ) <= this.maxQMismatchConverged;
                if (!isInAccordance && LOG.isInfoEnabled()) {
                    LOG.info("Bus {} is not in accordance with Kirchhoff's first law. Mismatch = {}", (Object)bus, (Object)String.format("(%.4f, %.4f)", sumP, sumQ));
                    BusTools.logDetail(busViewBus);
                    LOG.debug(String.format("  %7.2f  %7.2f  Sum", sumP, sumQ));
                }
            } else {
                isInAccordance = false;
                LOG.info("Bus {} is not in accordance with Kirchhoff's first law. All connected terminals have invalid values", (Object)bus);
                BusTools.logDetail(busViewBus);
            }
            this.checkedBusViewBuses.put(busViewBus, isInAccordance);
            return isInAccordance;
        }
    }

    private static final class BusTools {
        private BusTools() {
        }

        static Optional<Bus> getBusViewBus(Bus bus) {
            if (bus != null) {
                if (bus.getVoltageLevel().getTopologyKind().equals((Object)TopologyKind.BUS_BREAKER)) {
                    return Optional.of(bus.getVoltageLevel().getBusView().getMergedBus(bus.getId()));
                }
                if (bus.getConnectedTerminalCount() > 0) {
                    return bus.getConnectedTerminalStream().map(t -> t.getBusView().getBus()).filter(Objects::nonNull).findFirst();
                }
                return bus.getVoltageLevel().getBusView().getBusStream().filter(busViewBus -> bus.getVoltageLevel().getBusBreakerView().getBusesFromBusViewBusId(busViewBus.getId()).contains(bus)).findFirst();
            }
            return Optional.empty();
        }

        static boolean hasAnyFinite(Bus bus, Function<Terminal, Double> value) {
            return bus.getConnectedTerminalStream().map(value).anyMatch(Double::isFinite);
        }

        static double sum(Bus bus, Function<Terminal, Double> value) {
            return bus.getConnectedTerminalStream().map(value).filter(pq -> !Double.isNaN(pq)).mapToDouble(Double::valueOf).sum();
        }

        static boolean isSlack(Bus bus) {
            SlackTerminal st = (SlackTerminal)bus.getVoltageLevel().getExtension(SlackTerminal.class);
            return st != null && st.getTerminal() != null && st.getTerminal().getBusView().getBus() == bus;
        }

        static void logDetail(Bus bus) {
            if (LOG.isDebugEnabled()) {
                bus.getConnectedTerminalStream().forEach(t -> LOG.debug(String.format("  %7.2f  %7.2f  %s %s %s", t.getP(), t.getQ(), t.getConnectable().getType(), t.getConnectable().getNameOrId(), t.getConnectable().getId())));
            }
        }
    }
}

