/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export;

import com.powsybl.cgmes.conversion.CgmesExport;
import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.cgmes.conversion.naming.CgmesObjectReference;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopologyExport {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyExport.class);
    private static final String TOPOLOGICAL_NODE_CONNECTIVITY_NODE_CONTAINER = "TopologicalNode.ConnectivityNodeContainer";
    private static final String TOPOLOGICAL_NODE_BASE_VOLTAGE = "TopologicalNode.BaseVoltage";

    public static void write(Network network, XMLStreamWriter writer) {
        TopologyExport.write(network, writer, new CgmesExportContext(network).setExportEquipment(false));
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context) {
        CgmesMetadataModel model = CgmesExport.initializeModelForExport(network, CgmesSubset.TOPOLOGY, context, true, false);
        TopologyExport.write(network, writer, context, model);
    }

    public static void write(Network network, XMLStreamWriter writer, CgmesExportContext context, CgmesMetadataModel model) {
        try {
            String cimNamespace = context.getCim().getNamespace();
            CgmesExportUtil.writeRdfRoot(cimNamespace, context.getCim().getEuPrefix(), context.getCim().getEuNamespace(), writer);
            if (context.getCimVersion() >= 16) {
                CgmesExportUtil.writeModelDescription(network, CgmesSubset.TOPOLOGY, writer, model, context);
            }
            TopologyExport.writeTopologicalNodes(network, cimNamespace, writer, context);
            TopologyExport.writeTerminals(network, cimNamespace, writer, context);
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void writeTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        TopologyExport.writeConnectableTerminals(network, cimNamespace, writer, context);
        TopologyExport.writeBoundaryTerminals(network, cimNamespace, writer, context);
        TopologyExport.writeSwitchesTerminals(network, cimNamespace, writer, context);
        TopologyExport.writeDcTerminals(network, cimNamespace, writer, context);
        if (!context.isExportEquipment()) {
            TopologyExport.writeBusbarSectionTerminalsFromBusBranchCgmesModel(network, cimNamespace, writer, context);
        }
    }

    private static void writeBusbarSectionTerminalsFromBusBranchCgmesModel(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Bus b : network.getBusBreakerView().getBuses()) {
            String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)b);
            String bbsTerminals = b.getProperty("CGMES.busbarSectionTerminals", "");
            if (bbsTerminals.isEmpty()) continue;
            for (String bbsTerminal : bbsTerminals.split(",")) {
                TopologyExport.writeTerminal(bbsTerminal, topologicalNodeId, cimNamespace, writer, context);
            }
        }
    }

    private static void writeConnectableTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Connectable c : network.getConnectables()) {
            if (!context.isExportedEquipment((Identifiable<?>)c)) continue;
            for (Terminal t : c.getTerminals()) {
                Bus b = t.getBusBreakerView().getBus();
                if (b == null) {
                    b = t.getBusBreakerView().getConnectableBus();
                }
                String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)b);
                TopologyExport.writeTerminal(CgmesExportUtil.getTerminalId(t, context), topologicalNodeId, cimNamespace, writer, context);
            }
        }
    }

    private static void writeBoundaryTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        ArrayList<String> exported = new ArrayList<String>();
        for (DanglingLine dl : network.getDanglingLines(DanglingLineFilter.ALL)) {
            TopologyExport.writeBoundaryTerminal(dl, exported, cimNamespace, writer, context);
        }
    }

    private static String getBusCgmesId(VoltageLevel vl, Bus bus, int node, CgmesExportContext context) {
        return bus == null ? TopologyExport.findOrCreateTopologicalNode(vl, node, context) : context.getNamingStrategy().getCgmesId((Identifiable<?>)bus);
    }

    private static void writeSwitchesTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Switch sw : network.getSwitches()) {
            String tname2;
            String tn2;
            Bus bus2;
            String tname1;
            String tn1;
            Bus bus1;
            if (!context.isExportedEquipment((Identifiable<?>)sw)) continue;
            VoltageLevel vl = sw.getVoltageLevel();
            if (vl.getTopologyKind().equals((Object)TopologyKind.BUS_BREAKER)) {
                bus1 = vl.getBusBreakerView().getBus1(sw.getId());
                tn1 = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus1);
                tname1 = vl.getBusBreakerView().getBus1(sw.getId()).getNameOrId();
                bus2 = vl.getBusBreakerView().getBus2(sw.getId());
                tn2 = context.getNamingStrategy().getCgmesId((Identifiable<?>)bus2);
                tname2 = vl.getBusBreakerView().getBus2(sw.getId()).getNameOrId();
            } else {
                int node1 = vl.getNodeBreakerView().getNode1(sw.getId());
                bus1 = TopologyExport.getBusForBusBreakerViewBus(vl, node1);
                tn1 = TopologyExport.getBusCgmesId(vl, bus1, node1, context);
                tname1 = bus1 == null ? tn1 : bus1.getNameOrId();
                int node2 = vl.getNodeBreakerView().getNode2(sw.getId());
                bus2 = TopologyExport.getBusForBusBreakerViewBus(vl, node2);
                tn2 = TopologyExport.getBusCgmesId(vl, bus2, node2, context);
                tname2 = bus2 == null ? tn2 : bus2.getNameOrId();
            }
            TopologyExport.writeTopologicalNode(tn1, tname1, bus1, vl, cimNamespace, writer, context);
            TopologyExport.writeTopologicalNode(tn2, tname2, bus2, vl, cimNamespace, writer, context);
            String cgmesTerminal1 = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, "CGMES.Terminal1");
            String cgmesTerminal2 = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)sw, "CGMES.Terminal2");
            TopologyExport.writeSwitchTerminal(tn1, cgmesTerminal1, cimNamespace, writer, context);
            TopologyExport.writeSwitchTerminal(tn2, cgmesTerminal2, cimNamespace, writer, context);
        }
    }

    private static String findOrCreateTopologicalNode(VoltageLevel vl, int node, CgmesExportContext context) {
        HashSet<Integer> nodeSet = new HashSet<Integer>();
        nodeSet.add(node);
        VoltageLevel.NodeBreakerView.TopologyTraverser traverser = (node1, sw, node2) -> {
            if (sw != null && (sw.isOpen() || sw.isRetained())) {
                return TraverseResult.TERMINATE_PATH;
            }
            nodeSet.add(node2);
            return TraverseResult.CONTINUE;
        };
        vl.getNodeBreakerView().traverse(node, traverser);
        Optional<Bus> selectedBus = nodeSet.stream().map(n -> TopologyExport.getBusForBusBreakerViewBus(vl, n)).filter(Objects::nonNull).findFirst();
        if (selectedBus.isPresent()) {
            return context.getNamingStrategy().getCgmesId((Identifiable)selectedBus.get());
        }
        Object disconnectedBusId = nodeSet.stream().sorted().findFirst().map(selectedNode -> vl.getId() + "_" + selectedNode).orElseThrow(() -> new PowsyblException("nodeSet is never empty"));
        if (vl.getNetwork().getIdentifiable((String)disconnectedBusId) != null) {
            disconnectedBusId = (String)disconnectedBusId + "_TN";
        }
        return context.getNamingStrategy().getCgmesId((String)disconnectedBusId);
    }

    private static void writeTopologicalNode(String tn, String tname, Bus bus, VoltageLevel voltageLevel, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        if (context.containsTopologicalNode(tn)) {
            return;
        }
        context.putTopologicalNode(tn, bus);
        TopologyExport.writeTopologicalNode(tn, tname, context.getNamingStrategy().getCgmesId((Identifiable<?>)voltageLevel), context.getBaseVoltageByNominalVoltage(voltageLevel.getNominalV()).getId(), cimNamespace, writer, context);
    }

    private static void writeSwitchTerminal(String tn, String cgmesTerminal, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        TopologyExport.writeTerminal(cgmesTerminal, tn, cimNamespace, writer, context);
    }

    private static Bus getBusForBusBreakerViewBus(VoltageLevel vl, int node) {
        Terminal terminal = vl.getNodeBreakerView().getTerminal(node);
        if (terminal == null) {
            return null;
        }
        return terminal.getBusBreakerView().getBus();
    }

    private static void writeDcTerminals(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (HvdcLine line : network.getHvdcLines()) {
            TopologyExport.writeDcTerminals(line, line.getConverterStation1(), 1, cimNamespace, writer, context);
            TopologyExport.writeDcTerminals(line, line.getConverterStation2(), 2, cimNamespace, writer, context);
        }
    }

    private static void writeDcTerminals(HvdcLine line, HvdcConverterStation<?> converter, int side, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        Bus bus = converter.getTerminal().getBusBreakerView().getBus();
        if (bus == null) {
            bus = converter.getTerminal().getBusBreakerView().getConnectableBus();
        }
        String dcTopologicalNode = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(bus), CgmesObjectReference.Part.DC_TOPOLOGICAL_NODE);
        String dcNode = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DCNODE, CgmesObjectReference.ref(side));
        TopologyExport.writeDCNode(dcNode, dcTopologicalNode, cimNamespace, writer, context);
        String dcTerminal = (String)line.getAliasFromType("CGMES.DCTerminal" + side).orElseThrow(PowsyblException::new);
        TopologyExport.writeDCTerminal(dcTerminal, dcTopologicalNode, cimNamespace, writer, context);
        String acdcConverterDcTerminal = (String)converter.getAliasFromType("CGMES.DCTerminal1").orElseThrow(PowsyblException::new);
        TopologyExport.writeAcdcConverterDCTerminal(acdcConverterDcTerminal, dcTopologicalNode, cimNamespace, writer, context);
        String dcTopologicalNodeG = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(bus), CgmesObjectReference.Part.DC_TOPOLOGICAL_NODE, CgmesObjectReference.ref(side + "G"));
        String dcNodeG = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DCNODE, CgmesObjectReference.ref(side + "G"));
        TopologyExport.writeDCNode(dcNodeG, dcTopologicalNodeG, cimNamespace, writer, context);
        String dcTerminalG = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(line), CgmesObjectReference.Part.DC_TERMINAL, CgmesObjectReference.ref(side + "G"));
        TopologyExport.writeDCTerminal(dcTerminalG, dcTopologicalNodeG, cimNamespace, writer, context);
        String acdcConverterDcTerminalG = (String)converter.getAliasFromType("CGMES.DCTerminal2").orElseThrow(PowsyblException::new);
        TopologyExport.writeAcdcConverterDCTerminal(acdcConverterDcTerminalG, dcTopologicalNodeG, cimNamespace, writer, context);
    }

    private static void writeDCNode(String dcNode, String dcTopologicalNode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("DCNode", dcNode, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("DCNode.DCTopologicalNode", dcTopologicalNode, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeAcdcConverterDCTerminal(String acdcConverterDcTerminal, String dcTopologicalNode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("ACDCConverterDCTerminal", acdcConverterDcTerminal, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("DCBaseTerminal.DCTopologicalNode", dcTopologicalNode, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeDCTerminal(String dcTerminal, String dcTopologicalNode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("DCTerminal", dcTerminal, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("DCBaseTerminal.DCTopologicalNode", dcTopologicalNode, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeBoundaryTerminal(DanglingLine dl, List<String> exported, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String boundaryId = context.getNamingStrategy().getCgmesIdFromAlias((Identifiable<?>)dl, "CGMES.Terminal_Boundary");
        String equivalentInjectionTerminalId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)dl, "CGMES.EquivalentInjectionTerminal");
        String topologicalNode = dl.getProperty("CGMES.TopologicalNode_Boundary");
        if (boundaryId != null) {
            TopologyExport.writeTerminal(boundaryId, topologicalNode, cimNamespace, writer, context);
        }
        if (equivalentInjectionTerminalId != null && !exported.contains(equivalentInjectionTerminalId)) {
            TopologyExport.writeTerminal(equivalentInjectionTerminalId, topologicalNode, cimNamespace, writer, context);
            exported.add(equivalentInjectionTerminalId);
        }
    }

    private static void writeTerminal(String terminalId, String topologicalNode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartAbout("Terminal", terminalId, cimNamespace, writer, context);
        CgmesExportUtil.writeReference("Terminal.TopologicalNode", topologicalNode, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeTopologicalNodes(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        TopologyExport.writeBusTopologicalNodes(network, cimNamespace, writer, context);
        TopologyExport.writeDcTopologicalNodes(network, cimNamespace, writer, context);
        TopologyExport.writeDanglingLineTopologicalNodes(network, cimNamespace, writer, context);
    }

    private static void writeDanglingLineTopologicalNodes(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (DanglingLine dl : network.getDanglingLines(DanglingLineFilter.ALL)) {
            String topologicalNodeId = dl.getProperty("CGMES.TopologicalNode_Boundary");
            if (topologicalNodeId != null) continue;
            String baseVoltage = context.getBaseVoltageByNominalVoltage(dl.getTerminal().getVoltageLevel().getNominalV()).getId();
            String containerId = context.getFictitiousContainerFor((Identifiable<?>)dl);
            if (containerId == null) {
                LOG.error("Dangling line {}{} is not connected to a topology node in boundaries files: EQ profile must be exported for consistent results. Dangling line {} is considered entirely inside voltage level {}", new Object[]{dl.getId(), dl.getPairingKey() != null ? " linked to X-node " + dl.getPairingKey() : "", dl.getId(), dl.getTerminal().getVoltageLevel().getId()});
                containerId = context.getNamingStrategy().getCgmesId((Identifiable<?>)dl.getTerminal().getVoltageLevel());
            }
            String fictTopologicalNodeId = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(dl), CgmesObjectReference.Part.TOPOLOGICAL_NODE);
            dl.setProperty("CGMES.TopologicalNode_Boundary", fictTopologicalNodeId);
            TopologyExport.writeTopologicalNode(fictTopologicalNodeId, dl.getNameOrId() + "_NODE", containerId, baseVoltage, cimNamespace, writer, context);
        }
    }

    private static void writeBusTopologicalNodes(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        for (Bus b : network.getBusBreakerView().getBuses()) {
            String topologicalNodeId = context.getNamingStrategy().getCgmesId((Identifiable<?>)b);
            TopologyExport.writeTopologicalNode(topologicalNodeId, b.getNameOrId(), b, b.getVoltageLevel(), cimNamespace, writer, context);
        }
    }

    private static void writeDcTopologicalNodes(Network network, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        HashSet<String> written = new HashSet<String>();
        for (HvdcLine line : network.getHvdcLines()) {
            TopologyExport.writeDCTopologicalNode(line, 1, line.getConverterStation1(), written, cimNamespace, writer, context);
            TopologyExport.writeDCTopologicalNode(line, 2, line.getConverterStation2(), written, cimNamespace, writer, context);
        }
    }

    private static void writeDCTopologicalNode(HvdcLine line, int side, HvdcConverterStation<?> converter, Set<String> written, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        Bus b = converter.getTerminal().getBusBreakerView().getBus();
        if (b == null) {
            b = converter.getTerminal().getBusBreakerView().getConnectableBus();
        }
        if (!written.contains(b.getId())) {
            String id = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(b), CgmesObjectReference.Part.DC_TOPOLOGICAL_NODE);
            String name = line.getNameOrId() + side;
            TopologyExport.writeDCTopologicalNode(id, name, cimNamespace, writer, context);
            id = context.getNamingStrategy().getCgmesId(CgmesObjectReference.refTyped(b), CgmesObjectReference.Part.DC_TOPOLOGICAL_NODE, CgmesObjectReference.ref(side + "G"));
            name = line.getNameOrId() + side + "G";
            TopologyExport.writeDCTopologicalNode(id, name, cimNamespace, writer, context);
            written.add(b.getId());
        }
    }

    private static void writeDCTopologicalNode(String id, String name, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("DCTopologicalNode", id, name, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private static void writeTopologicalNode(String topologicalNode, String topologicalNodeName, String connectivityNodeContainerId, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("TopologicalNode", topologicalNode, topologicalNodeName, cimNamespace, writer, context);
        CgmesExportUtil.writeReference(TOPOLOGICAL_NODE_CONNECTIVITY_NODE_CONTAINER, connectivityNodeContainerId, cimNamespace, writer, context);
        CgmesExportUtil.writeReference(TOPOLOGICAL_NODE_BASE_VOLTAGE, baseVoltageId, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private TopologyExport() {
    }
}

