/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class EquivalentInjectionEq {
    private static final String EQ_EQUIVALENTINJECTION_REGULATIONCAPABILITY = "EquivalentInjection.regulationCapability";
    private static final String EQ_EQUIVALENTINJECTION_MINP = "EquivalentInjection.minP";
    private static final String EQ_EQUIVALENTINJECTION_MAXP = "EquivalentInjection.maxP";
    private static final String EQ_EQUIVALENTINJECTION_MINQ = "EquivalentInjection.minQ";
    private static final String EQ_EQUIVALENTINJECTION_MAXQ = "EquivalentInjection.maxQ";
    private static final String EQ_EQUIVALENTINJECTION_REACTIVE_CAPABILITY_CURVE = "EquivalentInjection.ReactiveCapabilityCurve";

    public static void write(String id, String name, boolean regulationCapability, double minP, double maxP, Double minQ, Double maxQ, String reactiveCapabilityCurveId, String baseVoltageId, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("EquivalentInjection", id, name, cimNamespace, writer, context);
        writer.writeStartElement(cimNamespace, EQ_EQUIVALENTINJECTION_REGULATIONCAPABILITY);
        writer.writeCharacters(CgmesExportUtil.format(regulationCapability));
        writer.writeEndElement();
        if (!CgmesExportUtil.isMinusOrMaxValue(minP)) {
            writer.writeStartElement(cimNamespace, EQ_EQUIVALENTINJECTION_MINP);
            writer.writeCharacters(CgmesExportUtil.format(minP));
            writer.writeEndElement();
        }
        if (!CgmesExportUtil.isMinusOrMaxValue(maxP)) {
            writer.writeStartElement(cimNamespace, EQ_EQUIVALENTINJECTION_MAXP);
            writer.writeCharacters(CgmesExportUtil.format(maxP));
            writer.writeEndElement();
        }
        if (minQ != null && !CgmesExportUtil.isMinusOrMaxValue(minQ)) {
            writer.writeStartElement(cimNamespace, EQ_EQUIVALENTINJECTION_MINQ);
            writer.writeCharacters(CgmesExportUtil.format(minQ));
            writer.writeEndElement();
        }
        if (maxQ != null && !CgmesExportUtil.isMinusOrMaxValue(maxQ)) {
            writer.writeStartElement(cimNamespace, EQ_EQUIVALENTINJECTION_MAXQ);
            writer.writeCharacters(CgmesExportUtil.format(maxQ));
            writer.writeEndElement();
        }
        if (reactiveCapabilityCurveId != null) {
            CgmesExportUtil.writeReference(EQ_EQUIVALENTINJECTION_REACTIVE_CAPABILITY_CURVE, reactiveCapabilityCurveId, cimNamespace, writer, context);
        }
        CgmesExportUtil.writeReference("ConductingEquipment.BaseVoltage", baseVoltageId, cimNamespace, writer, context);
        writer.writeEndElement();
    }

    private EquivalentInjectionEq() {
    }
}

