/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.commons.PowsyblException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class OperationalLimitTypeEq {
    public static final String ABSOLUTEVALUE_LIMITDIRECTION = "OperationalLimitDirectionKind.absoluteValue";
    private static final String PATL = "patl";
    private static final String TATL = "tatl";

    public static void writePatl(String id, String cimNamespace, String euNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("OperationalLimitType", id, "PATL", cimNamespace, writer, context);
        OperationalLimitTypeEq.writeDirection(cimNamespace, writer);
        OperationalLimitTypeEq.writeKind(PATL, euNamespace, writer, context);
        if (context.getCimVersion() == 100) {
            OperationalLimitTypeEq.writeInfiniteDuration(true, cimNamespace, writer);
        }
        writer.writeEndElement();
    }

    public static void writeTatl(String id, int acceptableDuration, String cimNamespace, String euNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        CgmesExportUtil.writeStartIdName("OperationalLimitType", id, "TATL " + acceptableDuration, cimNamespace, writer, context);
        OperationalLimitTypeEq.writeDirection(cimNamespace, writer);
        OperationalLimitTypeEq.writeKind(TATL, euNamespace, writer, context);
        if (context.getCimVersion() == 100) {
            OperationalLimitTypeEq.writeInfiniteDuration(false, cimNamespace, writer);
        }
        writer.writeStartElement(cimNamespace, "OperationalLimitType.acceptableDuration");
        writer.writeCharacters(CgmesExportUtil.format(acceptableDuration));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeDirection(String cimNamespace, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement(cimNamespace, "OperationalLimitType.direction");
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + ABSOLUTEVALUE_LIMITDIRECTION);
    }

    private static void writeKind(String kind, String euNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        writer.writeEmptyElement(euNamespace, OperationalLimitTypeEq.getLimitTypeAttributeName(context));
        writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", String.format("%s%s.%s", euNamespace, OperationalLimitTypeEq.getLimitKindClassName(context), kind));
    }

    private static void writeInfiniteDuration(boolean infiniteDuration, String cimNamespace, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(cimNamespace, "OperationalLimitType.isInfiniteDuration");
        writer.writeCharacters(Boolean.toString(infiniteDuration));
        writer.writeEndElement();
    }

    public static String getLimitTypeAttributeName(CgmesExportContext context) {
        if (context.getCimVersion() == 14) {
            throw new PowsyblException("Undefined limit type attribute name for version 14");
        }
        if (context.getCimVersion() == 16) {
            return "OperationalLimitType.limitType";
        }
        return "OperationalLimitType.kind";
    }

    public static String getLimitKindClassName(CgmesExportContext context) {
        if (context.getCimVersion() == 14) {
            throw new PowsyblException("Undefined limit kind class name for version 14");
        }
        if (context.getCimVersion() == 16) {
            return "LimitTypeKind";
        }
        return "LimitKind";
    }

    private OperationalLimitTypeEq() {
    }
}

