/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.export.elements;

import com.powsybl.cgmes.conversion.export.CgmesExportContext;
import com.powsybl.cgmes.conversion.export.CgmesExportUtil;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class RegulatingControlEq {
    public static final String REGULATING_CONTROL_VOLTAGE = "RegulatingControlModeKind.voltage";
    public static final String REGULATING_CONTROL_REACTIVE_POWER = "RegulatingControlModeKind.reactivePower";
    public static final String REGULATING_CONTROL_ACTIVE_POWER = "RegulatingControlModeKind.activePower";
    public static final String REGULATING_CONTROL_CURRENT_FLOW = "RegulatingControlModeKind.currentFlow";

    public static String writeRegulatingControlEq(Connectable<?> c, String terminalId, Set<String> regulatingControlsWritten, String mode, String cimNamespace, XMLStreamWriter writer, CgmesExportContext context) throws XMLStreamException {
        String regulatingControlId = context.getNamingStrategy().getCgmesIdFromProperty((Identifiable<?>)c, "CGMES.RegulatingControl");
        if (regulatingControlId != null && !regulatingControlsWritten.contains(regulatingControlId)) {
            String regulatingControlName = "RC_" + c.getNameOrId();
            CgmesExportUtil.writeStartIdName("RegulatingControl", regulatingControlId, regulatingControlName, cimNamespace, writer, context);
            CgmesExportUtil.writeReference("RegulatingControl.Terminal", terminalId, cimNamespace, writer, context);
            writer.writeEmptyElement(cimNamespace, "RegulatingControl.mode");
            writer.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", cimNamespace + mode);
            writer.writeEndElement();
            regulatingControlsWritten.add(regulatingControlId);
        }
        return regulatingControlId;
    }

    private RegulatingControlEq() {
    }
}

