/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.conversion.naming;

import com.powsybl.cgmes.conversion.naming.FixedCgmesAliasNamingStrategy;
import com.powsybl.cgmes.conversion.naming.NamingStrategiesServiceLoader;
import com.powsybl.cgmes.conversion.naming.NamingStrategy;
import com.powsybl.cgmes.conversion.naming.NamingStrategyProvider;
import com.powsybl.cgmes.conversion.naming.SimpleCgmesAliasNamingStrategy;
import com.powsybl.commons.PowsyblException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class NamingStrategyFactory {
    public static final String IDENTITY = "identity";
    public static final String CGMES = "cgmes";
    public static final String CGMES_FIX_ALL_INVALID_IDS = "cgmes-fix-all-invalid-ids";
    public static final List<String> LIST = List.of("identity", "cgmes", "cgmes-fix-all-invalid-ids");

    public static NamingStrategy create(String impl, UUID uuidNamespace) {
        Objects.requireNonNull(impl);
        NamingStrategiesServiceLoader serviceLoader = new NamingStrategiesServiceLoader();
        Optional<NamingStrategyProvider> providerOpt = serviceLoader.findProviderByName(impl);
        if (providerOpt.isPresent()) {
            return providerOpt.get().create(uuidNamespace);
        }
        return switch (impl) {
            case IDENTITY -> new NamingStrategy.Identity();
            case CGMES -> new SimpleCgmesAliasNamingStrategy(uuidNamespace);
            case CGMES_FIX_ALL_INVALID_IDS -> new FixedCgmesAliasNamingStrategy(uuidNamespace);
            default -> throw new PowsyblException("Unknown naming strategy: " + impl);
        };
    }

    private NamingStrategyFactory() {
    }
}

