/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.BaseVoltageMapping;
import com.powsybl.cgmes.extensions.BaseVoltageMappingAdder;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Network;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

@AutoService(value={ExtensionSerDe.class})
public class BaseVoltageMappingSerDe
extends AbstractExtensionSerDe<Network, BaseVoltageMapping> {
    public static final String BASE_VOLTAGE_ARRAY_ELEMENT = "baseVoltages";
    public static final String BASE_VOLTAGE_ROOT_ELEMENT = "baseVoltage";

    public BaseVoltageMappingSerDe() {
        super("baseVoltageMapping", "network", BaseVoltageMapping.class, "baseVoltageMapping.xsd", "http://www.powsybl.org/schema/iidm/ext/base_voltage_mapping/1_0", "bv");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(BASE_VOLTAGE_ARRAY_ELEMENT, BASE_VOLTAGE_ROOT_ELEMENT);
    }

    public void write(BaseVoltageMapping extension, SerializerContext context) {
        TreeDataWriter writer = context.getWriter();
        Map sortedBaseVoltages = extension.getBaseVoltages().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        writer.writeStartNodes();
        sortedBaseVoltages.forEach((nominalV, baseVoltageSource) -> {
            writer.writeStartNode(this.getNamespaceUri(), BASE_VOLTAGE_ROOT_ELEMENT);
            writer.writeDoubleAttribute("nominalVoltage", nominalV.doubleValue());
            writer.writeEnumAttribute("source", (Enum)baseVoltageSource.getSource());
            writer.writeStringAttribute("id", baseVoltageSource.getId());
            writer.writeEndNode();
        });
        writer.writeEndNodes();
    }

    public BaseVoltageMapping read(Network extendable, DeserializerContext context) {
        BaseVoltageMappingAdder mappingAdder = (BaseVoltageMappingAdder)extendable.newExtension(BaseVoltageMappingAdder.class);
        mappingAdder.add();
        BaseVoltageMapping mapping = (BaseVoltageMapping)extendable.getExtension(BaseVoltageMapping.class);
        context.getReader().readChildNodes(elementName -> {
            if (!elementName.equals(BASE_VOLTAGE_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'baseVoltageMapping'");
            }
            double nominalV = context.getReader().readDoubleAttribute("nominalVoltage");
            String sourceBV = context.getReader().readStringAttribute("source");
            String baseVoltageId = context.getReader().readStringAttribute("id");
            context.getReader().readEndNode();
            mapping.addBaseVoltage(nominalV, baseVoltageId, Source.valueOf(sourceBV));
        });
        return mapping;
    }

    public boolean isSerializable(BaseVoltageMapping extension) {
        return !extension.isBaseVoltageEmpty();
    }
}

