/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreas;
import com.powsybl.cgmes.extensions.CgmesControlAreasAdder;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class CgmesControlAreasSerDe
extends AbstractExtensionSerDe<Network, CgmesControlAreas> {
    private static final String CONTROL_AREA_ROOT_ELEMENT = "controlArea";
    private static final String CONTROL_AREA_ARRAY_ELEMENT = "controlAreas";
    public static final String TERMINAL_ROOT_ELEMENT = "terminal";
    public static final String TERMINAL_ARRAY_ELEMENT = "terminals";
    public static final String BOUNDARY_ROOT_ELEMENT = "boundary";
    public static final String BOUNDARY_ARRAY_ELEMENT = "boundaries";

    public CgmesControlAreasSerDe() {
        super("cgmesControlAreas", "network", CgmesControlAreas.class, "cgmesControlAreas.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_control_areas/1_0", "cca");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(CONTROL_AREA_ARRAY_ELEMENT, CONTROL_AREA_ROOT_ELEMENT, TERMINAL_ARRAY_ELEMENT, TERMINAL_ROOT_ELEMENT, BOUNDARY_ARRAY_ELEMENT, BOUNDARY_ROOT_ELEMENT);
    }

    public boolean isSerializable(CgmesControlAreas extension) {
        return !extension.getCgmesControlAreas().isEmpty();
    }

    public void write(CgmesControlAreas extension, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        TreeDataWriter writer = networkContext.getWriter();
        writer.writeStartNodes();
        for (CgmesControlArea controlArea : extension.getCgmesControlAreas()) {
            writer.writeStartNode(this.getNamespaceUri(), CONTROL_AREA_ROOT_ELEMENT);
            writer.writeStringAttribute("id", controlArea.getId());
            writer.writeStringAttribute("name", controlArea.getName());
            writer.writeStringAttribute("energyIdentificationCodeEic", controlArea.getEnergyIdentificationCodeEIC());
            writer.writeDoubleAttribute("netInterchange", controlArea.getNetInterchange());
            writer.writeDoubleAttribute("pTolerance", controlArea.getPTolerance());
            writer.writeStartNodes();
            for (Terminal terminal : controlArea.getTerminals()) {
                TerminalRefSerDe.writeTerminalRef((Terminal)terminal, (NetworkSerializerContext)networkContext, (String)this.getNamespaceUri(), (String)TERMINAL_ROOT_ELEMENT);
            }
            writer.writeEndNodes();
            writer.writeStartNodes();
            for (Boundary boundary : controlArea.getBoundaries()) {
                if (boundary.getDanglingLine() == null) continue;
                writer.writeStartNode(this.getNamespaceUri(), BOUNDARY_ROOT_ELEMENT);
                writer.writeStringAttribute("id", networkContext.getAnonymizer().anonymizeString(boundary.getDanglingLine().getId()));
                writer.writeEnumAttribute("side", (Enum)CgmesControlAreasSerDe.getSide(boundary));
                writer.writeEndNode();
            }
            writer.writeEndNodes();
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    private static TwoSides getSide(Boundary boundary) {
        return boundary.getDanglingLine().getTieLine().map(tl -> {
            if (tl.getDanglingLine1() == boundary.getDanglingLine()) {
                return TwoSides.ONE;
            }
            return TwoSides.TWO;
        }).orElse(null);
    }

    public CgmesControlAreas read(Network extendable, DeserializerContext context) {
        NetworkDeserializerContext networkContext = (NetworkDeserializerContext)context;
        TreeDataReader reader = networkContext.getReader();
        ((CgmesControlAreasAdder)extendable.newExtension(CgmesControlAreasAdder.class)).add();
        CgmesControlAreas mapping = (CgmesControlAreas)extendable.getExtension(CgmesControlAreas.class);
        reader.readChildNodes(elementName -> {
            if (!elementName.equals(CONTROL_AREA_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'cgmesControlArea'");
            }
            CgmesControlArea cgmesControlArea = mapping.newCgmesControlArea().setId(reader.readStringAttribute("id")).setName(reader.readStringAttribute("name")).setEnergyIdentificationCodeEic(reader.readStringAttribute("energyIdentificationCodeEic")).setNetInterchange(reader.readDoubleAttribute("netInterchange")).setPTolerance(reader.readDoubleAttribute("pTolerance")).add();
            this.readBoundariesAndTerminals(networkContext, cgmesControlArea, extendable);
        });
        return (CgmesControlAreas)extendable.getExtension(CgmesControlAreas.class);
    }

    private void readBoundariesAndTerminals(NetworkDeserializerContext networkContext, CgmesControlArea cgmesControlArea, Network network) {
        TreeDataReader reader = networkContext.getReader();
        reader.readChildNodes(elementName -> {
            switch (elementName) {
                case "boundary": {
                    String id = networkContext.getAnonymizer().deanonymizeString(reader.readStringAttribute("id"));
                    TwoSides side = (TwoSides)reader.readEnumAttribute("side", TwoSides.class);
                    Identifiable identifiable = network.getIdentifiable(id);
                    if (identifiable instanceof DanglingLine) {
                        DanglingLine dl = (DanglingLine)identifiable;
                        cgmesControlArea.add(dl.getBoundary());
                    } else if (identifiable instanceof TieLine) {
                        TieLine tl = (TieLine)identifiable;
                        cgmesControlArea.add(tl.getDanglingLine(side).getBoundary());
                    } else {
                        throw new PowsyblException("Unexpected Identifiable instance: " + identifiable.getClass());
                    }
                    reader.readEndNode();
                    break;
                }
                case "terminal": {
                    cgmesControlArea.add(TerminalRefSerDe.readTerminal((NetworkDeserializerContext)networkContext, (Network)network));
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'controlArea'");
                }
            }
        });
    }
}

