/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.CgmesMetadataModels;
import com.powsybl.cgmes.extensions.CgmesMetadataModelsAdder;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.Collection;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class CgmesMetadataModelsSerDe
extends AbstractExtensionSerDe<Network, CgmesMetadataModels> {
    private static final String MODEL = "model";
    private static final String PROFILE = "profile";
    private static final String DEPENDENT_ON_MODEL = "dependentOnModel";
    private static final String SUPERSEDES_MODEL = "supersedesModel";
    private static final String MODELS = "models";
    private static final String PROFILES = "profiles";
    private static final String DEPENDENT_ON_MODELS = "dependentOnModels";
    private static final String SUPERSEDES_MODELS = "supersedesModels";

    public CgmesMetadataModelsSerDe() {
        super("cgmesMetadataModels", "network", CgmesMetadataModels.class, "cgmesMetadataModels.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_metadata_models/1_0", "cmm");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(MODELS, MODEL, PROFILES, PROFILE, DEPENDENT_ON_MODELS, DEPENDENT_ON_MODEL, SUPERSEDES_MODELS, SUPERSEDES_MODEL);
    }

    public void write(CgmesMetadataModels extension, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        TreeDataWriter writer = networkContext.getWriter();
        writer.writeStartNodes();
        for (CgmesMetadataModel model : extension.getSortedModels()) {
            this.writeModel(model, context);
        }
        writer.writeEndNodes();
    }

    private void writeModel(CgmesMetadataModel model, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        TreeDataWriter writer = networkContext.getWriter();
        writer.writeStartNode(this.getNamespaceUri(), MODEL);
        writer.writeEnumAttribute("subset", (Enum)model.getSubset());
        writer.writeStringAttribute("modelingAuthoritySet", model.getModelingAuthoritySet());
        writer.writeStringAttribute("id", model.getId());
        writer.writeIntAttribute("version", model.getVersion());
        writer.writeStringAttribute("description", model.getDescription());
        this.writeReferences(CgmesMetadataModelsSerDe.sorted(model.getProfiles(), context), PROFILE, writer);
        this.writeReferences(CgmesMetadataModelsSerDe.sorted(model.getDependentOn(), context), DEPENDENT_ON_MODEL, writer);
        this.writeReferences(CgmesMetadataModelsSerDe.sorted(model.getSupersedes(), context), SUPERSEDES_MODEL, writer);
        writer.writeEndNode();
    }

    private void writeReferences(Collection<String> refs, String refElementName, TreeDataWriter writer) {
        writer.writeStartNodes();
        for (String ref : refs) {
            writer.writeStartNode(this.getNamespaceUri(), refElementName);
            writer.writeNodeContent(ref);
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    private static Collection<String> sorted(Collection<String> strings, SerializerContext context) {
        if (!((NetworkSerializerContext)context).getOptions().isSorted()) {
            return strings.stream().sorted().toList();
        }
        return strings;
    }

    public CgmesMetadataModels read(Network extendable, DeserializerContext context) {
        CgmesMetadataModelsAdder adder = (CgmesMetadataModelsAdder)extendable.newExtension(CgmesMetadataModelsAdder.class);
        context.getReader().readChildNodes(element -> CgmesMetadataModelsSerDe.read(adder.newModel(), context));
        adder.add();
        return (CgmesMetadataModels)extendable.getExtension(CgmesMetadataModels.class);
    }

    private static void read(CgmesMetadataModelsAdder.ModelAdder adder, DeserializerContext context) {
        TreeDataReader reader = context.getReader();
        adder.setSubset((CgmesSubset)reader.readEnumAttribute("subset", CgmesSubset.class)).setModelingAuthoritySet(reader.readStringAttribute("modelingAuthoritySet")).setId(reader.readStringAttribute("id")).setVersion(reader.readIntAttribute("version")).setDescription(reader.readStringAttribute("description"));
        reader.readChildNodes(elementName -> {
            switch (elementName) {
                case "profile": {
                    adder.addProfile(reader.readContent());
                    break;
                }
                case "dependentOnModel": {
                    adder.addDependentOn(reader.readContent());
                    break;
                }
                case "supersedesModel": {
                    adder.addSupersedes(reader.readContent());
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'cgmesMetadataModels'");
                }
            }
        });
        adder.add();
    }
}

