/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangerAdder;
import com.powsybl.cgmes.extensions.CgmesTapChangerImpl;
import com.powsybl.cgmes.extensions.CgmesTapChangersImpl;
import com.powsybl.commons.PowsyblException;

class CgmesTapChangerAdderImpl
implements CgmesTapChangerAdder {
    private final CgmesTapChangersImpl<?> mapping;
    private String id = null;
    private String combinedTapChangerId = null;
    private String type = null;
    private boolean hidden = false;
    private Integer step = null;
    private String controlId = null;

    CgmesTapChangerAdderImpl(CgmesTapChangersImpl<?> mapping) {
        this.mapping = mapping;
    }

    @Override
    public CgmesTapChangerAdder setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public CgmesTapChangerAdder setCombinedTapChangerId(String combinedTapChangerId) {
        this.combinedTapChangerId = combinedTapChangerId;
        return this;
    }

    @Override
    public CgmesTapChangerAdder setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public CgmesTapChangerAdder setHiddenStatus(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public CgmesTapChangerAdder setStep(int step) {
        this.step = step;
        return this;
    }

    @Override
    public CgmesTapChangerAdder setControlId(String controlId) {
        this.controlId = controlId;
        return this;
    }

    @Override
    public CgmesTapChanger add() {
        if (this.id == null) {
            throw new PowsyblException("Tap changer ID should not be null");
        }
        if (!this.hidden) {
            if (this.step != null) {
                throw new PowsyblException("Non-hidden tap changers step positions can be directly found on the tap changer and should not be forced");
            }
            if (this.combinedTapChangerId != null) {
                throw new PowsyblException("Non-hidden tap changers do not have a different ID for the combined tap changer");
            }
        }
        if (this.hidden) {
            if (this.step == null) {
                throw new PowsyblException("Hidden tap changers step positions should be explicit");
            }
            if (this.combinedTapChangerId == null) {
                throw new PowsyblException("Hidden tap changers should have an ID for the combined tap changer");
            }
        }
        return new CgmesTapChangerImpl(this.id, this.combinedTapChangerId, this.type, this.hidden, this.step, this.controlId, this.mapping);
    }
}

