/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangerAdder;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.CgmesTapChangersAdder;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class CgmesTapChangersSerDe<C extends Connectable<C>>
extends AbstractExtensionSerDe<C, CgmesTapChangers<C>> {
    public static final String TAP_CHANGER_ROOT_ELEMENT = "tapChanger";
    private static final String TAP_CHANGER_ARRAY_ELEMENT = "tapChangers";

    public CgmesTapChangersSerDe() {
        super("cgmesTapChangers", "network", CgmesTapChangers.class, "cgmesTapChangers.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_tap_changers/1_0", "ctc");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(TAP_CHANGER_ARRAY_ELEMENT, TAP_CHANGER_ROOT_ELEMENT);
    }

    public void write(CgmesTapChangers<C> extension, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        TreeDataWriter writer = networkContext.getWriter();
        writer.writeStartNodes();
        for (CgmesTapChanger tapChanger : extension.getTapChangers()) {
            writer.writeStartNode(this.getNamespaceUri(), TAP_CHANGER_ROOT_ELEMENT);
            writer.writeStringAttribute("id", tapChanger.getId());
            writer.writeStringAttribute("combinedTapChangerId", tapChanger.getCombinedTapChangerId());
            writer.writeStringAttribute("type", tapChanger.getType());
            writer.writeBooleanAttribute("hidden", tapChanger.isHidden(), false);
            writer.writeOptionalIntAttribute("step", !tapChanger.isHidden() ? null : Integer.valueOf(tapChanger.getStep().orElseThrow(() -> new PowsyblException("Step should be defined"))));
            writer.writeStringAttribute("controlId", tapChanger.getControlId());
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    public CgmesTapChangers<C> read(C extendable, DeserializerContext context) {
        NetworkDeserializerContext networkContext = (NetworkDeserializerContext)context;
        TreeDataReader reader = networkContext.getReader();
        ((CgmesTapChangersAdder)extendable.newExtension(CgmesTapChangersAdder.class)).add();
        CgmesTapChangers tapChangers = (CgmesTapChangers)extendable.getExtension(CgmesTapChangers.class);
        reader.readChildNodes(elementName -> {
            if (!elementName.equals(TAP_CHANGER_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'cgmesTapChangers'");
            }
            CgmesTapChangerAdder adder = tapChangers.newTapChanger().setId(reader.readStringAttribute("id")).setCombinedTapChangerId(reader.readStringAttribute("combinedTapChangerId")).setType(reader.readStringAttribute("type")).setHiddenStatus(reader.readBooleanAttribute("hidden", false)).setControlId(reader.readStringAttribute("controlId"));
            reader.readOptionalIntAttribute("step").ifPresent(adder::setStep);
            context.getReader().readEndNode();
            adder.add();
        });
        return (CgmesTapChangers)extendable.getExtension(CgmesTapChangers.class);
    }
}

