/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.powsybl.cgmes.extensions.CgmesMetadataModels;
import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class CgmesMetadataModelsImpl
extends AbstractExtension<Network>
implements CgmesMetadataModels {
    private final List<CgmesMetadataModel> models = new ArrayList<CgmesMetadataModel>();
    private final EnumMap<CgmesSubset, CgmesMetadataModel> subsetModel = new EnumMap(CgmesSubset.class);

    CgmesMetadataModelsImpl(Set<CgmesMetadataModel> models) {
        this.models.addAll(models);
        models.forEach(m -> this.subsetModel.put(m.getSubset(), (CgmesMetadataModel)m));
    }

    @Override
    public Optional<CgmesMetadataModel> getModelForSubset(CgmesSubset subset) {
        return Optional.ofNullable(this.subsetModel.get(subset));
    }

    @Override
    public Optional<CgmesMetadataModel> getModelForSubsetModelingAuthoritySet(CgmesSubset subset, String modelingAuthoritySet) {
        return this.models.stream().filter(m -> m.getSubset().equals((Object)subset) && m.getModelingAuthoritySet().equals(modelingAuthoritySet)).findFirst();
    }

    @Override
    public Collection<CgmesMetadataModel> getModels() {
        return Collections.unmodifiableCollection(this.models);
    }

    @Override
    public List<CgmesMetadataModel> getSortedModels() {
        return this.models.stream().sorted(Comparator.comparing(CgmesMetadataModel::getModelingAuthoritySet).thenComparing(CgmesMetadataModel::getSubset).thenComparing(CgmesMetadataModel::getVersion).thenComparing(CgmesMetadataModel::getId)).toList();
    }
}

