/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions.compatibility;

import com.google.auto.service.AutoService;
import com.google.common.base.Strings;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import java.util.Map;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ExtensionSerDe.class})
public class CgmesControlAreasSerDe
extends AbstractExtensionSerDe<Network, DummyExt> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CgmesControlAreasSerDe.class);
    private static final String CONTROL_AREA_ROOT_ELEMENT = "controlArea";
    private static final String CONTROL_AREA_ARRAY_ELEMENT = "controlAreas";
    public static final String TERMINAL_ROOT_ELEMENT = "terminal";
    public static final String TERMINAL_ARRAY_ELEMENT = "terminals";
    public static final String BOUNDARY_ROOT_ELEMENT = "boundary";
    public static final String BOUNDARY_ARRAY_ELEMENT = "boundaries";

    public CgmesControlAreasSerDe() {
        super("cgmesControlAreas", "network", DummyExt.class, "cgmesControlAreas.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_control_areas/1_0", "cca");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(CONTROL_AREA_ARRAY_ELEMENT, CONTROL_AREA_ROOT_ELEMENT, TERMINAL_ARRAY_ELEMENT, TERMINAL_ROOT_ELEMENT, BOUNDARY_ARRAY_ELEMENT, BOUNDARY_ROOT_ELEMENT);
    }

    public void write(DummyExt extension, SerializerContext context) {
        throw new IllegalStateException("Should not happen");
    }

    public DummyExt read(Network extendable, DeserializerContext context) {
        NetworkDeserializerContext networkContext = (NetworkDeserializerContext)context;
        TreeDataReader reader = networkContext.getReader();
        reader.readChildNodes(elementName -> {
            if (elementName.equals(CONTROL_AREA_ROOT_ELEMENT)) {
                String id = reader.readStringAttribute("id");
                if (extendable.getArea(id) == null) {
                    Area area = ((AreaAdder)((AreaAdder)extendable.newArea().setAreaType("ControlAreaTypeKind.Interchange").setId(id)).setName(reader.readStringAttribute("name"))).setInterchangeTarget(reader.readDoubleAttribute("netInterchange")).add();
                    OptionalDouble pTolerance = reader.readOptionalDoubleAttribute("pTolerance");
                    pTolerance.ifPresent(t -> area.setProperty("pTolerance", Double.toString(t)));
                    String energyIdentificationCodeEic = reader.readStringAttribute("energyIdentificationCodeEic");
                    if (!Strings.isNullOrEmpty((String)energyIdentificationCodeEic)) {
                        area.addAlias(energyIdentificationCodeEic, "energyIdentCodeEic");
                    }
                    this.readBoundariesAndTerminals(networkContext, area, extendable);
                } else {
                    LOGGER.warn("Area with id {} already exists. Skipping this CgmesControlArea.", (Object)id);
                    reader.skipNode();
                }
            } else {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'cgmesControlArea'");
            }
        });
        return null;
    }

    private void readBoundariesAndTerminals(NetworkDeserializerContext networkContext, Area area, Network network) {
        TreeDataReader reader = networkContext.getReader();
        reader.readChildNodes(elementName -> {
            switch (elementName) {
                case "boundary": {
                    String id = networkContext.getAnonymizer().deanonymizeString(reader.readStringAttribute("id"));
                    Identifiable identifiable = network.getIdentifiable(id);
                    boolean isAc = true;
                    if (identifiable instanceof DanglingLine) {
                        DanglingLine dl = (DanglingLine)identifiable;
                        area.newAreaBoundary().setAc(isAc).setBoundary(dl.getBoundary()).add();
                    } else if (identifiable instanceof TieLine) {
                        TieLine tl = (TieLine)identifiable;
                        TwoSides side = (TwoSides)reader.readEnumAttribute("side", TwoSides.class);
                        area.newAreaBoundary().setAc(isAc).setBoundary(tl.getDanglingLine(side).getBoundary()).add();
                    } else {
                        throw new PowsyblException("Unexpected Identifiable instance: " + identifiable.getClass());
                    }
                    reader.readEndNode();
                    break;
                }
                case "terminal": {
                    Terminal terminal = TerminalRefSerDe.readTerminal((NetworkDeserializerContext)networkContext, (Network)network);
                    area.newAreaBoundary().setAc(terminal.getConnectable().getType() != IdentifiableType.HVDC_CONVERTER_STATION).setTerminal(terminal).add();
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'controlArea'");
                }
            }
        });
    }

    public boolean isSerializable(DummyExt ext) {
        return false;
    }

    public static class DummyExt
    implements Extension<Network> {
        public String getName() {
            return "cgmesControlAreas";
        }

        public Network getExtendable() {
            throw new UnsupportedOperationException("This extension should not be used.");
        }

        public void setExtendable(Network extendable) {
            throw new UnsupportedOperationException("This extension should not be used.");
        }
    }
}

