/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesDcTerminal;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesOnDataSource;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.WindingType;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCgmesModel
implements CgmesModel {
    private final Properties properties = new Properties();
    private String baseName;
    private Map<String, PropertyBags> cachedGroupedTransformerEnds;
    private Map<String, CgmesTerminal> cachedTerminals;
    private Map<String, CgmesContainer> cachedContainers;
    private Map<String, Double> cachedBaseVoltages;
    protected boolean cachedNodes = false;
    protected PropertyBags cachedConnectivityNodes;
    protected PropertyBags cachedTopologicalNodes;
    private Map<String, PropertyBag> cachedNodesById;
    private Map<String, String[]> powerTransformerRatioTapChanger;
    private Map<String, String[]> powerTransformerPhaseTapChanger;
    private Map<String, CgmesDcTerminal> cachedDcTerminals;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCgmesModel.class);
    private static final String SUBSTATION = "Substation";

    protected AbstractCgmesModel() {
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, PropertyBags> groupedTransformerEnds() {
        if (this.cachedGroupedTransformerEnds == null) {
            this.cachedGroupedTransformerEnds = this.computeGroupedTransformerEnds();
        }
        return this.cachedGroupedTransformerEnds;
    }

    @Override
    public Collection<CgmesTerminal> computedTerminals() {
        if (this.cachedTerminals == null) {
            this.cachedTerminals = this.computeTerminals();
        }
        return this.cachedTerminals.values();
    }

    @Override
    public CgmesTerminal terminal(String terminalId) {
        if (this.cachedTerminals == null) {
            this.cachedTerminals = this.computeTerminals();
        }
        return this.cachedTerminals.get(terminalId);
    }

    @Override
    public CgmesDcTerminal dcTerminal(String dcTerminalId) {
        if (this.cachedDcTerminals == null) {
            this.cachedDcTerminals = this.computeDcTerminals();
        }
        return this.cachedDcTerminals.get(dcTerminalId);
    }

    @Override
    public List<String> ratioTapChangerListForPowerTransformer(String powerTransformerId) {
        return this.powerTransformerRatioTapChanger.get(powerTransformerId) == null ? null : Arrays.asList(this.powerTransformerRatioTapChanger.get(powerTransformerId));
    }

    @Override
    public List<String> phaseTapChangerListForPowerTransformer(String powerTransformerId) {
        return this.powerTransformerPhaseTapChanger.get(powerTransformerId) == null ? null : Arrays.asList(this.powerTransformerPhaseTapChanger.get(powerTransformerId));
    }

    @Override
    public String substation(CgmesTerminal t, boolean nodeBreaker) {
        CgmesContainer c = this.container(t, nodeBreaker);
        if (c == null) {
            return null;
        }
        return c.substation();
    }

    @Override
    public String voltageLevel(CgmesTerminal t, boolean nodeBreaker) {
        CgmesContainer c = this.container(t, nodeBreaker);
        if (c == null) {
            return null;
        }
        return c.voltageLevel();
    }

    @Override
    public CgmesContainer container(String containerId) {
        if (this.cachedContainers == null) {
            this.cachedContainers = this.computeContainers();
        }
        if (this.cachedContainers.get(containerId) == null) {
            String fixedContainerId = this.connectivityNodeContainers().stream().filter(p -> p.containsKey((Object)SUBSTATION)).filter(p -> p.getId(SUBSTATION).equals(containerId)).findFirst().map(p -> p.getId("VoltageLevel")).orElseThrow(() -> new CgmesModelException(containerId + " should be a connectivity node container containing at least one voltage level"));
            LOG.warn("{} is a substation, not a voltage level, a line or a bay but contains nodes. The first CGMES voltage level found in this substation ({}}) is used instead.", (Object)containerId, (Object)fixedContainerId);
            this.cachedContainers.put(containerId, this.cachedContainers.get(fixedContainerId));
        }
        return this.cachedContainers.get(containerId);
    }

    @Override
    public double nominalVoltage(String baseVoltageId) {
        if (this.cachedBaseVoltages == null) {
            this.cachedBaseVoltages = new HashMap<String, Double>();
            this.baseVoltages().forEach(bv -> this.cachedBaseVoltages.put(bv.getId("BaseVoltage"), bv.asDouble("nominalVoltage")));
        }
        if (this.cachedBaseVoltages.containsKey(baseVoltageId)) {
            return this.cachedBaseVoltages.get(baseVoltageId);
        }
        return Double.NaN;
    }

    private CgmesContainer container(CgmesTerminal t, boolean nodeBreaker) {
        String nodeId;
        this.cacheNodes();
        String containerId = null;
        String string = nodeId = nodeBreaker && t.connectivityNode() != null ? t.connectivityNode() : t.topologicalNode();
        if (nodeId != null) {
            PropertyBag node = this.cachedNodesById.get(nodeId);
            if (node != null) {
                containerId = node.getId("ConnectivityNodeContainer");
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Missing node {} from terminal {}", (Object)nodeId, (Object)t.id());
            }
        }
        return containerId == null ? null : this.container(containerId);
    }

    private Map<String, PropertyBags> computeGroupedTransformerEnds() {
        String endNumber = "endNumber";
        HashMap<String, PropertyBags> gends = new HashMap<String, PropertyBags>();
        this.powerTransformerRatioTapChanger = new HashMap<String, String[]>();
        this.powerTransformerPhaseTapChanger = new HashMap<String, String[]>();
        this.transformerEnds().forEach(end -> {
            String id = end.getId("PowerTransformer");
            PropertyBags ends = gends.computeIfAbsent(id, x -> new PropertyBags());
            ends.add(end);
            if (end.getId("PhaseTapChanger") != null) {
                this.powerTransformerPhaseTapChanger.computeIfAbsent(id, s -> new String[3]);
                this.powerTransformerPhaseTapChanger.get((Object)id)[end.asInt((String)endNumber, (int)1) - 1] = end.getId("PhaseTapChanger");
            }
            if (end.getId("RatioTapChanger") != null) {
                this.powerTransformerRatioTapChanger.computeIfAbsent(id, s -> new String[3]);
                this.powerTransformerRatioTapChanger.get((Object)id)[end.asInt((String)endNumber, (int)1) - 1] = end.getId("RatioTapChanger");
            }
        });
        gends.entrySet().forEach(tends -> {
            PropertyBags tends1 = new PropertyBags((Collection)((PropertyBags)tends.getValue()).stream().sorted(Comparator.comparing(WindingType::fromTransformerEnd).thenComparing(end -> end.asInt(endNumber, -1))).collect(Collectors.toList()));
            tends.setValue(tends1);
        });
        return gends;
    }

    protected void cacheNodes() {
        if (!this.cachedNodes) {
            this.cachedConnectivityNodes = this.connectivityNodes();
            this.cachedTopologicalNodes = this.topologicalNodes();
            this.cachedNodesById = new HashMap<String, PropertyBag>();
            this.cachedConnectivityNodes.forEach(cn -> this.cachedNodesById.put(cn.getId("ConnectivityNode"), (PropertyBag)cn));
            this.cachedTopologicalNodes.forEach(tn -> this.cachedNodesById.put(tn.getId("TopologicalNode"), (PropertyBag)tn));
            this.cachedNodes = true;
        }
    }

    private Map<String, CgmesTerminal> computeTerminals() {
        HashMap<String, CgmesTerminal> ts = new HashMap<String, CgmesTerminal>();
        this.terminals().forEach(t -> {
            CgmesTerminal td = new CgmesTerminal((PropertyBag)t);
            if (ts.containsKey(td.id())) {
                return;
            }
            ts.put(td.id(), td);
        });
        return ts;
    }

    private Map<String, CgmesDcTerminal> computeDcTerminals() {
        HashMap<String, CgmesDcTerminal> ts = new HashMap<String, CgmesDcTerminal>();
        this.dcTerminals().forEach(t -> {
            CgmesDcTerminal td = new CgmesDcTerminal((PropertyBag)t);
            if (ts.containsKey(td.id())) {
                return;
            }
            ts.put(td.id(), td);
        });
        return ts;
    }

    private Map<String, CgmesContainer> computeContainers() {
        HashMap<String, CgmesContainer> cs = new HashMap<String, CgmesContainer>();
        this.connectivityNodeContainers().forEach(c -> {
            String id = c.getId("ConnectivityNodeContainer");
            String voltageLevel = c.getId("VoltageLevel");
            String substation = c.getId(SUBSTATION);
            cs.put(id, new CgmesContainer(voltageLevel, substation));
        });
        return cs;
    }

    @Override
    public void setBasename(String baseName) {
        this.baseName = Objects.requireNonNull(baseName);
    }

    @Override
    public String getBasename() {
        return this.baseName;
    }

    @Override
    public void read(ReadOnlyDataSource mainDataSource, ReadOnlyDataSource alternativeDataSourceForBoundary, ReportNode reportNode) {
        this.setBasename(CgmesModel.baseName(mainDataSource));
        this.read(mainDataSource, reportNode);
        if (!this.hasBoundary() && alternativeDataSourceForBoundary != null) {
            this.read(alternativeDataSourceForBoundary, reportNode);
        }
    }

    @Override
    public void read(ReadOnlyDataSource ds, ReportNode reportNode) {
        Objects.requireNonNull(reportNode);
        this.invalidateCaches();
        CgmesOnDataSource cds = new CgmesOnDataSource(ds);
        for (String name : cds.names()) {
            LOG.info("Reading [{}]", (Object)name);
            ((ReportNodeAdder)((ReportNodeAdder)((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("CGMESFileRead", "Instance file ${instanceFile}")).withTypedValue("instanceFile", name, "FILENAME")).withSeverity(TypedValue.INFO_SEVERITY)).add();
            try {
                InputStream is = cds.dataSource().newInputStream(name);
                try {
                    this.read(is, this.baseName, name, reportNode);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                String msg = String.format("Reading [%s]", name);
                LOG.warn(msg);
                throw new CgmesModelException(msg, e);
            }
        }
    }

    protected void invalidateCaches() {
        this.cachedGroupedTransformerEnds = null;
        this.powerTransformerRatioTapChanger = null;
        this.powerTransformerPhaseTapChanger = null;
        this.cachedTerminals = null;
        this.cachedContainers = null;
        this.cachedBaseVoltages = null;
        this.cachedNodes = false;
        this.cachedConnectivityNodes = null;
        this.cachedTopologicalNodes = null;
        this.cachedNodesById = null;
        this.cachedDcTerminals = null;
    }
}

