/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesMetadataModel;
import com.powsybl.cgmes.model.CgmesSubset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class CgmesMetadataModelImpl
implements CgmesMetadataModel {
    private final CgmesSubset subset;
    private String id;
    private String description;
    private int version;
    private String modelingAuthoritySet;
    private final Set<String> profiles = new HashSet<String>();
    private final Set<String> dependentOn = new HashSet<String>();
    private final Set<String> supersedes = new HashSet<String>();

    public CgmesMetadataModelImpl(CgmesSubset subset, String modelingAuthoritySet) {
        this.subset = subset;
        this.modelingAuthoritySet = modelingAuthoritySet;
        this.version = 1;
        this.description = subset.getIdentifier() + " Model";
    }

    @Override
    public CgmesSubset getSubset() {
        return this.subset;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getModelingAuthoritySet() {
        return this.modelingAuthoritySet;
    }

    @Override
    public Set<String> getProfiles() {
        return this.profiles;
    }

    @Override
    public Set<String> getDependentOn() {
        return this.dependentOn;
    }

    @Override
    public Set<String> getSupersedes() {
        return this.supersedes;
    }

    @Override
    public CgmesMetadataModelImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public CgmesMetadataModelImpl setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public CgmesMetadataModelImpl setProfile(String profile) {
        Objects.requireNonNull(profile);
        this.profiles.clear();
        this.profiles.add(profile);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl addProfiles(Collection<String> profiles) {
        this.profiles.addAll(profiles);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public CgmesMetadataModelImpl addSupersedes(String id) {
        CgmesMetadataModelImpl.addIfNonEmpty(id, this.supersedes);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl addDependentOn(String id) {
        CgmesMetadataModelImpl.addIfNonEmpty(id, this.dependentOn);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl addDependentOn(Collection<String> dependentOn) {
        this.dependentOn.addAll(dependentOn);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl addSupersedes(Collection<String> supersedes) {
        this.supersedes.addAll(supersedes);
        return this;
    }

    @Override
    public CgmesMetadataModelImpl setModelingAuthoritySet(String modelingAuthoritySet) {
        this.modelingAuthoritySet = modelingAuthoritySet;
        return this;
    }

    @Override
    public CgmesMetadataModelImpl clearDependencies() {
        this.dependentOn.clear();
        return this;
    }

    @Override
    public CgmesMetadataModelImpl clearSupersedes() {
        this.supersedes.clear();
        return this;
    }

    private static void addIfNonEmpty(String id, Collection<String> ids) {
        if (id != null && !id.isEmpty()) {
            ids.add(id);
        }
    }
}

