/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.cgmes.model.NamespaceReader;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class CgmesOnDataSource {
    private final ReadOnlyDataSource dataSource;
    private static final String REGEX_VALID_NAME = "(?i)^.*\\.XML$";

    public CgmesOnDataSource(ReadOnlyDataSource ds) {
        this.dataSource = ds;
    }

    public ReadOnlyDataSource dataSource() {
        return this.dataSource;
    }

    public boolean exists() {
        Set<String> foundNamespaces = this.namespaces();
        if (!foundNamespaces.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            return false;
        }
        return foundNamespaces.contains("http://iec.ch/TC57/2013/CIM-schema-cim16#") || foundNamespaces.contains("http://iec.ch/TC57/CIM100#");
    }

    public boolean existsCim14() {
        Set<String> foundNamespaces = this.namespaces();
        if (!foundNamespaces.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            return false;
        }
        if (!foundNamespaces.contains("http://iec.ch/TC57/2009/CIM-schema-cim14#")) {
            return false;
        }
        return this.names().stream().anyMatch(CgmesSubset.EQUIPMENT::isValidName);
    }

    public String baseName() {
        return this.names().stream().map(n -> {
            String string;
            block8: {
                InputStream is = this.dataSource.newInputStream(n);
                try {
                    string = NamespaceReader.base(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException x) {
                        throw new UncheckedIOException(x);
                    }
                }
                is.close();
            }
            return string;
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            String name = this.dataSource.getBaseName().toLowerCase();
            if (name.isEmpty()) {
                name = "default-cgmes-model";
            }
            return "http://" + name;
        });
    }

    public Set<String> names() {
        try {
            Set allNames = this.dataSource.listNames(REGEX_VALID_NAME);
            allNames.removeIf(n -> !this.containsValidNamespace((String)n));
            return allNames;
        }
        catch (IOException x) {
            throw new CgmesModelException(String.format("Listing CGMES names in data source %s", this.dataSource), x);
        }
    }

    private boolean containsValidNamespace(String name) {
        boolean bl;
        block9: {
            InputStream is = this.dataSource.newInputStream(name);
            try {
                Set<String> ns = NamespaceReader.namespaces1(is);
                boolean bl2 = bl = ns.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && ns.stream().anyMatch(CgmesNamespace::isValid);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    return false;
                }
                catch (IOException x) {
                    throw new CgmesModelException(String.format("Listing CGMES names in data source %s", this.dataSource), x);
                }
            }
            is.close();
        }
        return bl;
    }

    public Set<String> namespaces() {
        HashSet<String> ns = new HashSet<String>();
        this.names().forEach(n -> {
            try (InputStream is = this.dataSource.newInputStream(n);){
                ns.addAll(NamespaceReader.namespaces(is));
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        });
        return ns;
    }

    public String cimNamespace() {
        return this.namespaces().stream().filter(CgmesNamespace::isValid).findFirst().orElseThrow(() -> new CgmesModelException("CIM Namespace not found"));
    }
}

