/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CgmesSubset {
    EQUIPMENT("EQ"){

        @Override
        public boolean isValidName(String contextName) {
            return super.isValidName(contextName) && !CgmesSubset.isBoundary(contextName);
        }
    }
    ,
    TOPOLOGY("TP"){

        @Override
        public boolean isValidName(String contextName) {
            return super.isValidName(contextName) && !CgmesSubset.isBoundary(contextName);
        }
    }
    ,
    STATE_VARIABLES("SV"),
    STEADY_STATE_HYPOTHESIS("SSH"),
    DYNAMIC("DY"),
    DIAGRAM_LAYOUT("DL"),
    GEOGRAPHICAL_LOCATION("GL"),
    EQUIPMENT_BOUNDARY("EQ_BD"){

        @Override
        public boolean isValidName(String contextName) {
            return super.isValidName(contextName) || EQUIPMENT.isValidName(contextName) && CgmesSubset.isBoundary(contextName);
        }
    }
    ,
    TOPOLOGY_BOUNDARY("TP_BD"){

        @Override
        public boolean isValidName(String contextName) {
            return super.isValidName(contextName) || TOPOLOGY.isValidName(contextName) && CgmesSubset.isBoundary(contextName);
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public boolean isValidName(String contextName) {
            return false;
        }
    };

    private final String identifier;
    private final String validName0;
    private final String validName1;
    private static final Map<String, String> PROFILE;

    private CgmesSubset(String identifier) {
        this.identifier = identifier;
        this.validName0 = "_" + identifier + "_";
        this.validName1 = "_" + identifier + ".";
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getProfile() {
        return PROFILE.get(this.identifier);
    }

    public boolean isValidName(String contextName) {
        return contextName.contains(this.validName0) || contextName.contains(this.validName1);
    }

    private static boolean isBoundary(String contextName) {
        return contextName.contains("_BD") || contextName.contains("BOUNDARY");
    }

    static {
        PROFILE = Map.of("SV", "StateVariables", "EQ", "EquipmentCore", "SSH", "SteadyStateHypothesis", "TP", "Topology");
    }
}

