/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.xml.XmlUtil;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FullModel {
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(() -> {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory;
    });
    private final String id;
    private final ZonedDateTime scenarioTime;
    private final ZonedDateTime created;
    private final String description;
    private final int version;
    private final List<String> profiles;
    private final List<String> dependentOn;
    private final List<String> supersedes;
    private final String modelingAuthoritySet;

    public FullModel(String id, ZonedDateTime scenarioTime, ZonedDateTime created, String description, int version, List<String> profiles, List<String> dependentOn, List<String> supersedes, String modelingAuthoritySet) {
        this.id = Objects.requireNonNull(id, "ID is missing");
        this.scenarioTime = Objects.requireNonNull(scenarioTime, "Scenario time is missing");
        this.created = Objects.requireNonNull(created, "Created time is missing");
        this.description = description;
        this.version = version;
        if (profiles == null || profiles.isEmpty()) {
            throw new PowsyblException("At least one profile is required");
        }
        this.profiles = new ArrayList<String>(profiles);
        this.dependentOn = new ArrayList<String>((Collection)Objects.requireNonNull(dependentOn));
        this.supersedes = new ArrayList<String>((Collection)Objects.requireNonNull(supersedes));
        this.modelingAuthoritySet = Objects.requireNonNull(modelingAuthoritySet, "Modeling authority set is missing");
    }

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getScenarioTime() {
        return this.scenarioTime;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public int getVersion() {
        return this.version;
    }

    public List<String> getProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public List<String> getDependentOn() {
        return Collections.unmodifiableList(this.dependentOn);
    }

    public List<String> getSupersedes() {
        return Collections.unmodifiableList(this.supersedes);
    }

    public String getModelingAuthoritySet() {
        return this.modelingAuthoritySet;
    }

    public String toString() {
        return "FullModel(id='" + this.id + "', scenarioTime=" + this.scenarioTime + ", created=" + this.created + ", description='" + this.description + "', version=" + this.version + ", profiles=" + this.profiles + ", dependentOn=" + this.dependentOn + ", supersedes=" + this.supersedes + ", modelingAuthoritySet='" + this.modelingAuthoritySet + "')";
    }

    public static FullModel parse(Reader reader) {
        Objects.requireNonNull(reader);
        ParsingContext context = new ParsingContext();
        try {
            XMLStreamReader xmlReader = XML_INPUT_FACTORY_SUPPLIER.get().createXMLStreamReader(reader);
            try {
                XmlUtil.readUntilStartElement((String[])new String[]{"/", "RDF", "FullModel"}, (XMLStreamReader)xmlReader, elementName1 -> {
                    context.id = xmlReader.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
                    XmlUtil.readSubElements((XMLStreamReader)xmlReader, subElementName -> FullModel.readSubElement(subElementName, context, xmlReader));
                });
            }
            finally {
                xmlReader.close();
                XmlUtil.gcXmlInputFactory((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get());
            }
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
        if (context.version == null) {
            throw new PowsyblException("Version is missing");
        }
        return new FullModel(context.id, context.scenarioTime, context.created, context.description, context.version, context.profiles, context.dependentOn, context.supersedes, context.modelingAuthoritySet);
    }

    private static void readSubElement(String subElementName, ParsingContext context, XMLStreamReader xmlReader) {
        try {
            switch (subElementName) {
                case "Model.scenarioTime": {
                    context.scenarioTime = ZonedDateTime.parse(xmlReader.getElementText());
                    break;
                }
                case "Model.created": {
                    context.created = ZonedDateTime.parse(xmlReader.getElementText());
                    break;
                }
                case "Model.description": {
                    context.description = XmlUtil.readText((XMLStreamReader)xmlReader);
                    break;
                }
                case "Model.version": {
                    context.version = Integer.parseInt(xmlReader.getElementText());
                    break;
                }
                case "Model.profile": {
                    context.profiles.add(XmlUtil.readText((XMLStreamReader)xmlReader));
                    break;
                }
                case "Model.DependentOn": {
                    context.dependentOn.add(xmlReader.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource"));
                    XmlUtil.readEndElementOrThrow((XMLStreamReader)xmlReader);
                    break;
                }
                case "Model.Supersedes": {
                    context.supersedes.add(xmlReader.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource"));
                    XmlUtil.readEndElementOrThrow((XMLStreamReader)xmlReader);
                    break;
                }
                case "Model.modelingAuthoritySet": {
                    context.modelingAuthoritySet = XmlUtil.readText((XMLStreamReader)xmlReader);
                    break;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static final class ParsingContext {
        private String id;
        private ZonedDateTime scenarioTime;
        private ZonedDateTime created;
        private String description;
        private Integer version;
        private final List<String> profiles = new ArrayList<String>();
        private final List<String> dependentOn = new ArrayList<String>();
        private final List<String> supersedes = new ArrayList<String>();
        private String modelingAuthoritySet;

        private ParsingContext() {
        }
    }
}

