/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.AbstractGridModelReference;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.ResourceDataSource;
import com.powsybl.commons.datasource.ResourceSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridModelReferenceResources
extends AbstractGridModelReference {
    private final ResourceSet[] resourceSets;
    private static final Logger LOG = LoggerFactory.getLogger(GridModelReferenceResources.class);

    public GridModelReferenceResources(String name, CgmesModel expected, ResourceSet ... resourceSets) {
        super(name, expected);
        this.resourceSets = resourceSets;
    }

    @Override
    public ReadOnlyDataSource dataSource() {
        ResourceDataSource ds = new ResourceDataSource(this.baseNameFromResourceNames(), this.resourceSets);
        if (LOG.isInfoEnabled()) {
            try {
                LOG.info("List of names in data source for {} = {}", (Object)this.name(), (Object)Arrays.toString(ds.listNames(".*").toArray()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return ds;
    }

    private String baseNameFromResourceNames() {
        for (ResourceSet resourceSet : this.resourceSets) {
            for (String fileName : resourceSet.getFileNames()) {
                if (fileName.contains("Boundary") || fileName.contains("_BD_")) continue;
                return fileName.replaceAll("^.*\\/", "").replaceAll("(?i)_(EQ|TP|SV|SSH|DL|GL|DY).*XML", "");
            }
        }
        throw new CgmesModelException("Data source does not contain valid data");
    }
}

