/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.google.common.base.Suppliers;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.commons.xml.XmlUtil;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class NamespaceReader {
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLInputFactory::newInstance);

    private NamespaceReader() {
    }

    public static Set<String> namespaces(InputStream is) {
        try {
            return NamespaceReader.namespaces1(is);
        }
        catch (XMLStreamException x) {
            throw new CgmesModelException("namespaces", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> namespaces1(InputStream is) throws XMLStreamException {
        HashSet<String> found = new HashSet<String>();
        XMLStreamReader xmlsr = XML_INPUT_FACTORY_SUPPLIER.get().createXMLStreamReader(is);
        try {
            boolean root = false;
            while (xmlsr.hasNext() && !root) {
                int eventType = xmlsr.next();
                if (eventType != 1) continue;
                root = true;
                for (int k = 0; k < xmlsr.getNamespaceCount(); ++k) {
                    found.add(xmlsr.getNamespaceURI(k));
                }
            }
        }
        finally {
            xmlsr.close();
            XmlUtil.gcXmlInputFactory((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get());
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String base(InputStream is) {
        try {
            XMLStreamReader xmlsr = XML_INPUT_FACTORY_SUPPLIER.get().createXMLStreamReader(is);
            try {
                int eventType;
                do {
                    if (!xmlsr.hasNext()) return null;
                } while ((eventType = xmlsr.next()) != 1);
                String string = xmlsr.getAttributeValue(null, "base");
                return string;
            }
            finally {
                xmlsr.close();
                XmlUtil.gcXmlInputFactory((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get());
            }
        }
        catch (XMLStreamException e) {
            throw new CgmesModelException("base", e);
        }
    }
}

