/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesModelReports;
import com.powsybl.cgmes.model.CgmesOnDataSource;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCgmesModel
implements CgmesModel {
    private final Properties properties = new Properties();
    private String baseName;
    private Map<String, CgmesTerminal> cachedTerminals;
    private Map<String, CgmesContainer> cachedContainers;
    private Map<String, Double> cachedBaseVoltages;
    protected boolean cachedNodes = false;
    protected PropertyBags cachedConnectivityNodes;
    protected PropertyBags cachedTopologicalNodes;
    private Map<String, PropertyBag> cachedNodesById;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCgmesModel.class);
    private static final String SUBSTATION = "Substation";

    protected AbstractCgmesModel() {
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Collection<CgmesTerminal> computedTerminals() {
        if (this.cachedTerminals == null) {
            this.cachedTerminals = this.computeTerminals();
        }
        return this.cachedTerminals.values();
    }

    @Override
    public CgmesTerminal terminal(String terminalId) {
        if (this.cachedTerminals == null) {
            this.cachedTerminals = this.computeTerminals();
        }
        return this.cachedTerminals.get(terminalId);
    }

    @Override
    public String substation(CgmesTerminal t, boolean nodeBreaker) {
        CgmesContainer c = this.container(t, nodeBreaker);
        if (c == null) {
            return null;
        }
        return c.substation();
    }

    @Override
    public String voltageLevel(CgmesTerminal t, boolean nodeBreaker) {
        CgmesContainer c = this.container(t, nodeBreaker);
        if (c == null) {
            return null;
        }
        return c.voltageLevel();
    }

    @Override
    public CgmesContainer container(String containerId) {
        if (this.cachedContainers == null) {
            this.cachedContainers = this.computeContainers();
        }
        if (this.cachedContainers.get(containerId) == null) {
            throw new CgmesModelException("Unexpected CgmesContainer for containerId: " + containerId);
        }
        return this.cachedContainers.get(containerId);
    }

    @Override
    public double nominalVoltage(String baseVoltageId) {
        if (this.cachedBaseVoltages == null) {
            this.cachedBaseVoltages = new HashMap<String, Double>();
            this.baseVoltages().forEach(bv -> this.cachedBaseVoltages.put(bv.getId("BaseVoltage"), bv.asDouble("nominalVoltage")));
        }
        return this.cachedBaseVoltages.getOrDefault(baseVoltageId, Double.NaN);
    }

    @Override
    public Optional<String> node(CgmesTerminal t, boolean nodeBreaker) {
        this.cacheNodes();
        String nodeId = nodeBreaker && t.connectivityNode() != null ? t.connectivityNode() : t.topologicalNode();
        return nodeId != null ? Optional.of(nodeId) : Optional.empty();
    }

    @Override
    public Optional<CgmesContainer> nodeContainer(String nodeId) {
        this.cacheNodes();
        String containerId = null;
        if (nodeId != null) {
            PropertyBag node = this.cachedNodesById.get(nodeId);
            if (node != null) {
                containerId = node.getId("ConnectivityNodeContainer");
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Missing node {}", (Object)nodeId);
            }
        }
        return containerId == null ? Optional.empty() : Optional.of(this.container(containerId));
    }

    private CgmesContainer container(CgmesTerminal t, boolean nodeBreaker) {
        String nodeId;
        this.cacheNodes();
        String containerId = null;
        String string = nodeId = nodeBreaker && t.connectivityNode() != null ? t.connectivityNode() : t.topologicalNode();
        if (nodeId != null) {
            PropertyBag node = this.cachedNodesById.get(nodeId);
            if (node != null) {
                containerId = node.getId("ConnectivityNodeContainer");
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Missing node {} from terminal {}", (Object)nodeId, (Object)t.id());
            }
        }
        return containerId == null ? null : this.container(containerId);
    }

    protected void cacheNodes() {
        if (!this.cachedNodes) {
            this.cachedConnectivityNodes = this.connectivityNodes();
            this.cachedTopologicalNodes = this.topologicalNodes();
            this.cachedNodesById = new HashMap<String, PropertyBag>();
            this.cachedConnectivityNodes.forEach(cn -> this.cachedNodesById.put(cn.getId("ConnectivityNode"), (PropertyBag)cn));
            this.cachedTopologicalNodes.forEach(tn -> this.cachedNodesById.put(tn.getId("TopologicalNode"), (PropertyBag)tn));
            this.cachedNodes = true;
        }
    }

    private Map<String, CgmesTerminal> computeTerminals() {
        HashMap<String, CgmesTerminal> ts = new HashMap<String, CgmesTerminal>();
        this.terminals().forEach(t -> {
            CgmesTerminal td = new CgmesTerminal((PropertyBag)t);
            if (ts.containsKey(td.id())) {
                return;
            }
            ts.put(td.id(), td);
        });
        return ts;
    }

    private Map<String, CgmesContainer> computeContainers() {
        HashMap<String, CgmesContainer> cs = new HashMap<String, CgmesContainer>();
        this.connectivityNodeContainers().forEach(c -> {
            String id = c.getId("ConnectivityNodeContainer");
            String voltageLevel = c.getId("VoltageLevel");
            String substation = c.getId(SUBSTATION);
            String type = c.getId("connectivityNodeContainerType");
            String line = type != null && type.contains("Line") ? id : null;
            String name = (String)c.get((Object)"name");
            cs.put(id, new CgmesContainer(voltageLevel, substation, line, name));
        });
        return cs;
    }

    @Override
    public void setBasename(String baseName) {
        this.baseName = Objects.requireNonNull(baseName);
    }

    @Override
    public String getBasename() {
        return this.baseName;
    }

    @Override
    public void read(ReadOnlyDataSource mainDataSource, ReadOnlyDataSource alternativeDataSourceForBoundary, ReportNode reportNode) {
        this.setBasename(CgmesModel.baseName(mainDataSource));
        this.read(mainDataSource, reportNode);
        if (!this.hasBoundary() && alternativeDataSourceForBoundary != null) {
            this.read(alternativeDataSourceForBoundary, reportNode);
        }
    }

    @Override
    public void read(ReadOnlyDataSource ds, ReportNode reportNode) {
        Objects.requireNonNull(reportNode);
        this.invalidateCaches();
        CgmesOnDataSource cds = new CgmesOnDataSource(ds);
        for (String name : cds.names()) {
            LOG.info("Reading [{}]", (Object)name);
            CgmesModelReports.readFile(reportNode, name);
            try {
                InputStream is = cds.dataSource().newInputStream(name);
                try {
                    this.read(is, this.baseName, name, reportNode);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                String msg = String.format("Reading [%s]", name);
                LOG.warn(msg);
                throw new CgmesModelException(msg, e);
            }
        }
    }

    protected void invalidateCaches() {
        this.cachedTerminals = null;
        this.cachedContainers = null;
        this.cachedBaseVoltages = null;
        this.cachedNodes = false;
        this.cachedConnectivityNodes = null;
        this.cachedTopologicalNodes = null;
        this.cachedNodesById = null;
    }
}

