/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesOnDataSource;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.PropertyBags;
import com.powsybl.triplestore.api.TripleStore;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

public interface CgmesModel {
    public TripleStore tripleStore();

    public Properties getProperties();

    default public PropertyBags fullModels() {
        return new PropertyBags();
    }

    public boolean hasEquipmentCore();

    public String modelId();

    public String version();

    public ZonedDateTime scenarioTime();

    public ZonedDateTime created();

    public boolean isNodeBreaker();

    public boolean hasBoundary();

    public CgmesTerminal terminal(String var1);

    public Collection<CgmesTerminal> computedTerminals();

    public PropertyBags numObjectsByType();

    public PropertyBags allObjectsOfType(String var1);

    public PropertyBags boundaryNodes();

    public PropertyBags baseVoltages();

    public PropertyBags countrySourcingActors(String var1);

    public PropertyBags sourcingActor(String var1);

    public PropertyBags substations();

    public PropertyBags voltageLevels();

    public PropertyBags terminals();

    public PropertyBags connectivityNodeContainers();

    public PropertyBags operationalLimits();

    public PropertyBags connectivityNodes();

    public PropertyBags topologicalNodes();

    public PropertyBags busBarSections();

    public PropertyBags switches();

    public PropertyBags acLineSegments();

    public PropertyBags equivalentBranches();

    public PropertyBags seriesCompensators();

    public PropertyBags transformers();

    public PropertyBags transformerEnds();

    public PropertyBags ratioTapChangers();

    public PropertyBags ratioTapChangerTablePoints();

    public PropertyBags phaseTapChangers();

    public PropertyBags phaseTapChangerTablePoints();

    public PropertyBags regulatingControls();

    public PropertyBags energyConsumers();

    public PropertyBags energySources();

    public PropertyBags shuntCompensators();

    public PropertyBags equivalentShunts();

    public PropertyBags nonlinearShuntCompensatorPoints();

    public PropertyBags staticVarCompensators();

    @Deprecated(since="6.3.0", forRemoval=true)
    default public PropertyBags synchronousMachines() {
        return this.synchronousMachinesGenerators();
    }

    default public PropertyBags synchronousMachinesGenerators() {
        return new PropertyBags();
    }

    default public PropertyBags synchronousMachinesCondensers() {
        return new PropertyBags();
    }

    default public PropertyBags synchronousMachinesAll() {
        PropertyBags p = new PropertyBags((Collection)this.synchronousMachinesGenerators());
        p.addAll((Collection)this.synchronousMachinesCondensers());
        return p;
    }

    public PropertyBags equivalentInjections();

    public PropertyBags externalNetworkInjections();

    public PropertyBags svInjections();

    public PropertyBags asynchronousMachines();

    public PropertyBags reactiveCapabilityCurveData();

    public PropertyBags controlAreas();

    public PropertyBags dcSwitches();

    public PropertyBags dcGrounds();

    public PropertyBags acDcConverters();

    public PropertyBags dcLineSegments();

    public PropertyBags dcTerminals();

    default public PropertyBags tieFlows() {
        return new PropertyBags();
    }

    default public PropertyBags topologicalIslands() {
        return new PropertyBags();
    }

    default public PropertyBags graph() {
        return new PropertyBags();
    }

    default public PropertyBags grounds() {
        return new PropertyBags();
    }

    public void clear(CgmesSubset var1);

    public void add(CgmesSubset var1, String var2, PropertyBags var3);

    default public void add(String context, String type, PropertyBags objects) {
        throw new UnsupportedOperationException();
    }

    public void print(PrintStream var1);

    public void print(Consumer<String> var1);

    public static String baseName(ReadOnlyDataSource ds) {
        return new CgmesOnDataSource(ds).baseName();
    }

    public void setBasename(String var1);

    public String getBasename();

    public void write(DataSource var1);

    default public void write(DataSource ds, CgmesSubset subset) {
        throw new UnsupportedOperationException();
    }

    public void read(ReadOnlyDataSource var1, ReportNode var2);

    public void read(ReadOnlyDataSource var1, ReadOnlyDataSource var2, ReportNode var3);

    public void read(InputStream var1, String var2, String var3, ReportNode var4);

    public String substation(CgmesTerminal var1, boolean var2);

    public String voltageLevel(CgmesTerminal var1, boolean var2);

    public Optional<String> node(CgmesTerminal var1, boolean var2);

    public Optional<CgmesContainer> nodeContainer(String var1);

    public CgmesContainer container(String var1);

    public double nominalVoltage(String var1);

    public PropertyBags modelProfiles();
}

