/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.re2j.Pattern;
import com.powsybl.commons.PowsyblException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CgmesNamespace {
    private static final Logger LOG = LoggerFactory.getLogger(CgmesNamespace.class);
    public static final String CIM_100_NAMESPACE = "http://iec.ch/TC57/CIM100#";
    public static final String CIM_16_NAMESPACE = "http://iec.ch/TC57/2013/CIM-schema-cim16#";
    private static final Set<String> VALID_CIM_NAMESPACES = Set.of("http://iec.ch/TC57/2013/CIM-schema-cim16#", "http://iec.ch/TC57/CIM100#");
    private static final Pattern CIM_100_PLUS_NAMESPACE_PATTERN = Pattern.compile((String)".*/CIM\\d+#$");
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String ENTSOE_NAMESPACE = "http://entsoe.eu/CIM/SchemaExtension/3/1#";
    public static final String EU_NAMESPACE = "http://iec.ch/TC57/CIM100-European#";
    public static final String MD_NAMESPACE = "http://iec.ch/TC57/61970-552/ModelDescription/1#";
    public static final String CIM_16_EQ_PROFILE = "http://entsoe.eu/CIM/EquipmentCore/3/1";
    public static final String CIM_16_EQ_OPERATION_PROFILE = "http://entsoe.eu/CIM/EquipmentOperation/3/1";
    public static final String CIM_16_TP_PROFILE = "http://entsoe.eu/CIM/Topology/4/1";
    public static final String CIM_16_SV_PROFILE = "http://entsoe.eu/CIM/StateVariables/4/1";
    public static final String CIM_16_SSH_PROFILE = "http://entsoe.eu/CIM/SteadyStateHypothesis/1/1";
    public static final String CIM_16_EQ_BD_PROFILE = "http://entsoe.eu/CIM/EquipmentBoundary/3/1";
    public static final String CIM_16_TP_BD_PROFILE = "http://entsoe.eu/CIM/TopologyBoundary/3/1";
    public static final String CGMES_EQ_3_OR_GREATER_PREFIX = "http://iec.ch/TC57/ns/CIM/CoreEquipment-EU/";
    public static final String CIM_100_EQ_PROFILE = "http://iec.ch/TC57/ns/CIM/CoreEquipment-EU/3.0";
    public static final String CIM_100_EQ_OPERATION_PROFILE = "http://iec.ch/TC57/ns/CIM/Operation-EU/3.0";
    public static final String CIM_100_TP_PROFILE = "http://iec.ch/TC57/ns/CIM/Topology-EU/3.0";
    public static final String CIM_100_SV_PROFILE = "http://iec.ch/TC57/ns/CIM/StateVariables-EU/3.0";
    public static final String CIM_100_SSH_PROFILE = "http://iec.ch/TC57/ns/CIM/SteadyStateHypothesis-EU/3.0";
    public static final String CIM_100_EQ_BD_PROFILE = "http://iec.ch/TC57/ns/CIM/EquipmentBoundary-EU/3.0";
    public static final Cim CIM_16 = new Cim16();
    public static final Cim CIM_100 = new Cim100();
    public static final List<Cim> CIM_LIST = List.of(CIM_16, CIM_100);

    private CgmesNamespace() {
    }

    public static boolean isValid(String ns) {
        return VALID_CIM_NAMESPACES.contains(ns) || CIM_100_PLUS_NAMESPACE_PATTERN.matcher((CharSequence)ns).matches();
    }

    public static Cim getCim(int cimVersion) {
        switch (cimVersion) {
            case 16: {
                return CIM_16;
            }
            case 100: {
                return CIM_100;
            }
        }
        if (cimVersion > 100) {
            LOG.info("CIM version is above 100 ({}), will be considered 100", (Object)cimVersion);
            return CIM_100;
        }
        throw new PowsyblException("Unsupported CIM version " + cimVersion);
    }

    public static String getProfile(String profileUri) {
        for (Cim cim : CIM_LIST) {
            if (!cim.hasProfileUri(profileUri)) continue;
            return cim.getProfile(profileUri);
        }
        return null;
    }

    public static interface Cim {
        public int getVersion();

        public String getNamespace();

        public boolean hasProfileUri(String var1);

        public String getProfileUri(String var1);

        public String getProfile(String var1);

        public String getEuPrefix();

        public String getEuNamespace();
    }

    private static final class Cim16
    extends AbstractCim {
        private Cim16() {
            super(16, CgmesNamespace.CIM_16_NAMESPACE, "entsoe", CgmesNamespace.ENTSOE_NAMESPACE, Map.of("EQ", CgmesNamespace.CIM_16_EQ_PROFILE, "EQ_OP", CgmesNamespace.CIM_16_EQ_OPERATION_PROFILE, "SSH", CgmesNamespace.CIM_16_SSH_PROFILE, "SV", CgmesNamespace.CIM_16_SV_PROFILE, "TP", CgmesNamespace.CIM_16_TP_PROFILE, "EQ_BD", CgmesNamespace.CIM_16_EQ_BD_PROFILE, "TP_BD", CgmesNamespace.CIM_16_TP_BD_PROFILE));
        }
    }

    private static final class Cim100
    extends AbstractCim {
        private Cim100() {
            super(100, CgmesNamespace.CIM_100_NAMESPACE, "eu", CgmesNamespace.EU_NAMESPACE, Map.of("EQ", CgmesNamespace.CIM_100_EQ_PROFILE, "EQ_OP", CgmesNamespace.CIM_100_EQ_OPERATION_PROFILE, "SSH", CgmesNamespace.CIM_100_SSH_PROFILE, "SV", CgmesNamespace.CIM_100_SV_PROFILE, "TP", CgmesNamespace.CIM_100_TP_PROFILE, "EQ_BD", CgmesNamespace.CIM_100_EQ_BD_PROFILE));
        }
    }

    private static abstract class AbstractCim
    implements Cim {
        private final int version;
        private final String namespace;
        private final String euPrefix;
        private final String euNamespace;
        private final BiMap<String, String> profiles = HashBiMap.create();

        private AbstractCim(int version, String namespace, String euPrefix, String euNamespace, Map<String, String> profiles) {
            this.version = version;
            this.namespace = namespace;
            this.euPrefix = euPrefix;
            this.euNamespace = euNamespace;
            this.profiles.putAll(profiles);
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getEuPrefix() {
            return this.euPrefix;
        }

        @Override
        public String getEuNamespace() {
            return this.euNamespace;
        }

        @Override
        public boolean hasProfileUri(String profileUri) {
            return this.profiles.containsValue((Object)profileUri);
        }

        @Override
        public String getProfileUri(String profile) {
            return (String)this.profiles.get((Object)profile);
        }

        @Override
        public String getProfile(String profileUri) {
            return (String)this.profiles.inverse().get((Object)profileUri);
        }
    }
}

