/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesNamespace;
import com.powsybl.cgmes.model.NamespaceReader;
import com.powsybl.commons.compress.SafeZipInputStream;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;

public class CgmesOnDataSource {
    private static final String LISTING_CGMES_NAMES_IN_DATA_SOURCE = "Listing CGMES names in data source %s";
    private static final String EXTENSION = "xml";
    private final ReadOnlyDataSource dataSource;
    private static final String REGEX_VALID_NAME = "(?i)^.*\\.(XML|ZIP)$";

    public CgmesOnDataSource(ReadOnlyDataSource ds) {
        this.dataSource = ds;
    }

    public ReadOnlyDataSource dataSource() {
        return this.dataSource;
    }

    private boolean checkIfMainFileNotWithCgmesData() throws IOException {
        if (this.dataSource.getDataExtension() == null || this.dataSource.getDataExtension().isEmpty() || !this.dataSource.exists(null, this.dataSource.getDataExtension())) {
            return false;
        }
        if (EXTENSION.equals(this.dataSource.getDataExtension())) {
            try (InputStream is = this.dataSource.newInputStream(null, EXTENSION);){
                boolean bl = !this.existsNamespaces(NamespaceReader.namespaces(is));
                return bl;
            }
        }
        return true;
    }

    public boolean exists() throws IOException {
        if (this.checkIfMainFileNotWithCgmesData()) {
            return false;
        }
        return this.existsNamespaces(this.namespaces());
    }

    private boolean existsNamespaces(Set<String> namespaces) {
        if (!namespaces.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            return false;
        }
        return namespaces.contains("http://iec.ch/TC57/2013/CIM-schema-cim16#") || namespaces.contains("http://iec.ch/TC57/CIM100#");
    }

    public String baseName() {
        return this.names().stream().map(n -> this.loadInputStreamAndGetNamespace((String)n, NamespaceReader::base)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            String name = this.dataSource.getBaseName().toLowerCase();
            if (name.isEmpty()) {
                name = "default-cgmes-model";
            }
            return "http://" + name;
        });
    }

    public Set<String> names() {
        try {
            Set allNames = this.dataSource.listNames(REGEX_VALID_NAME);
            allNames.removeIf(n -> !this.existsInDatasource((String)n) || !this.containsValidNamespace((String)n));
            return allNames;
        }
        catch (IOException x) {
            throw new CgmesModelException(String.format(LISTING_CGMES_NAMES_IN_DATA_SOURCE, this.dataSource), x);
        }
    }

    private boolean existsInDatasource(String fileName) {
        try {
            return this.dataSource.exists(fileName);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T loadInputStreamAndGetNamespace(String n, Function<InputStream, T> namespaceGetter) {
        try (InputStream in = this.dataSource.newInputStream(n);){
            String fileExtension = n.substring(n.lastIndexOf(46) + 1);
            if (fileExtension.equals(CompressionFormat.ZIP.getExtension())) {
                try (SafeZipInputStream zis = new SafeZipInputStream(new ZipInputStream(in), 1, 1024000L);){
                    zis.getNextEntry();
                    InputStream inputStream = namespaceGetter.apply((InputStream)zis);
                    return (T)inputStream;
                }
            }
            InputStream inputStream = namespaceGetter.apply(in);
            return (T)inputStream;
        }
        catch (IOException e) {
            throw new CgmesModelException(String.format(LISTING_CGMES_NAMES_IN_DATA_SOURCE, this.dataSource), e);
        }
    }

    private boolean containsValidNamespace(String name) {
        Set ns = this.loadInputStreamAndGetNamespace(name, NamespaceReader::namespacesOrEmpty);
        return ns.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && ns.stream().anyMatch(CgmesNamespace::isValid);
    }

    public Set<String> namespaces() {
        return this.names().stream().map(name -> this.loadInputStreamAndGetNamespace((String)name, NamespaceReader::namespaces)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String cimNamespace() {
        return this.namespaces().stream().filter(CgmesNamespace::isValid).findFirst().orElseThrow(() -> new CgmesModelException("CIM Namespace not found"));
    }
}

