/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model.triplestore;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.powsybl.cgmes.model.AbstractCgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.PrefixNamespace;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import com.powsybl.triplestore.api.QueryCatalog;
import com.powsybl.triplestore.api.TripleStore;
import com.powsybl.triplestore.api.TripleStoreException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgmesModelTripleStore
extends AbstractCgmesModel {
    private static final Pattern CIM_NAMESPACE_VERSION_PATTERN_UNTIL_16 = Pattern.compile((String)"^.*CIM-schema-cim(\\d+)#$");
    private static final Pattern CIM_NAMESPACE_VERSION_PATTERN_FROM_100 = Pattern.compile((String)"^.*/CIM(\\d+)#$");
    private final String cimNamespace;
    private final int cimVersion;
    private final TripleStore tripleStore;
    private final QueryCatalog queryCatalog;
    private Boolean nodeBreaker = null;
    private static final String MODEL_PROFILES = "modelProfiles";
    private static final String PROFILE = "profile";
    private static final Logger LOG = LoggerFactory.getLogger(CgmesModelTripleStore.class);
    private static final String[] PARAMETER_REFERENCE = new String[]{"{0}", "{1}", "{2}", "{3}", "{4}", "{5}", "{6}", "{7}", "{8}", "{9}"};

    public CgmesModelTripleStore(String cimNamespace, TripleStore tripleStore) {
        this.cimNamespace = cimNamespace;
        this.cimVersion = CgmesModelTripleStore.cimVersionFromCimNamespace(cimNamespace);
        this.tripleStore = tripleStore;
        tripleStore.defineQueryPrefix("cim", cimNamespace);
        tripleStore.defineQueryPrefix("entsoe", "http://entsoe.eu/CIM/SchemaExtension/3/1#");
        tripleStore.defineQueryPrefix("eu", "http://iec.ch/TC57/CIM100-European#");
        this.queryCatalog = this.queryCatalogFor(this.cimVersion);
        Objects.requireNonNull(this.queryCatalog);
    }

    @Override
    public void read(InputStream is, String baseName, String contextName, ReportNode reportNode) {
        this.nodeBreaker = null;
        this.tripleStore.read(is, baseName, contextName);
    }

    @Override
    public void print(PrintStream out) {
        this.tripleStore.print(out);
    }

    @Override
    public void print(Consumer<String> liner) {
        this.tripleStore.print(liner);
    }

    @Override
    public void write(DataSource ds) {
        try {
            this.tripleStore.write(ds);
        }
        catch (TripleStoreException x) {
            throw new CgmesModelException(String.format("Writing. Triple store problem %s", ds), x);
        }
    }

    @Override
    public void write(DataSource ds, CgmesSubset subset) {
        try {
            this.tripleStore.write(ds, this.contextNameFor(subset));
        }
        catch (TripleStoreException e) {
            throw new CgmesModelException(String.format("Writing. Triple store problem %s", ds), e);
        }
    }

    private static boolean isEquipmentCore(String profile) {
        return profile.contains("/EquipmentCore/") || profile.contains("/CIM/CoreEquipment");
    }

    private static boolean isEquipmentOperation(String profile) {
        return profile.contains("/EquipmentOperation/") || profile.contains("/CIM/Operation");
    }

    @Override
    public boolean hasEquipmentCore() {
        PropertyBags r = this.namedQuery(MODEL_PROFILES, new String[0]);
        if (r == null) {
            return false;
        }
        for (PropertyBag m : r) {
            String p = (String)m.get((Object)PROFILE);
            if (p == null || !CgmesModelTripleStore.isEquipmentCore(p)) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("Model contains Equipment Core data profile in model {}", m.get((Object)"FullModel"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBoundary() {
        boolean hasEquipmentBoundary = false;
        boolean hasTopologyBoundary = false;
        PropertyBags r = this.namedQuery(MODEL_PROFILES, new String[0]);
        if (r == null) {
            return false;
        }
        for (PropertyBag m : r) {
            String p = (String)m.get((Object)PROFILE);
            String mid = (String)m.get((Object)"FullModel");
            if (p != null && p.contains("/EquipmentBoundary/")) {
                LOG.info("Model contains EquipmentBoundary data in model {}", (Object)mid);
                hasEquipmentBoundary = true;
            }
            if (p == null || !p.contains("/TopologyBoundary/")) continue;
            LOG.info("Model contains TopologyBoundary data in model {}", (Object)mid);
            hasTopologyBoundary = true;
        }
        return hasEquipmentBoundary && hasTopologyBoundary;
    }

    @Override
    public boolean isNodeBreaker() {
        if (this.nodeBreaker == null) {
            this.nodeBreaker = this.computeIsNodeBreaker();
        }
        return this.nodeBreaker;
    }

    private boolean computeIsNodeBreaker() {
        PropertyBags r = this.namedQuery(MODEL_PROFILES, new String[0]);
        if (r == null) {
            return false;
        }
        if (this.allEqCgmes3OrGreater(r) && !this.connectivityNodes().isEmpty()) {
            return true;
        }
        Map<String, Boolean> modelHasOperationProfile = this.computeModelHasOperationProfile(r);
        boolean consideredNodeBreaker = modelHasOperationProfile.values().stream().allMatch(Boolean::valueOf);
        if (LOG.isInfoEnabled()) {
            this.logNodeBreaker(consideredNodeBreaker, modelHasOperationProfile);
        }
        return consideredNodeBreaker;
    }

    private boolean allEqCgmes3OrGreater(PropertyBags modelProfiles) {
        for (PropertyBag mp : modelProfiles) {
            String p = (String)mp.get((Object)PROFILE);
            if (p == null || !CgmesModelTripleStore.isEquipmentCore(p) || CgmesModelTripleStore.isEqCgmes3OrGreater(p)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqCgmes3OrGreater(String profile) {
        return profile.startsWith("http://iec.ch/TC57/ns/CIM/CoreEquipment-EU/") && profile.compareTo("http://iec.ch/TC57/ns/CIM/CoreEquipment-EU/3.0") >= 0;
    }

    private void logNodeBreaker(boolean consideredNodeBreaker, Map<String, Boolean> modelHasOperationProfile) {
        if (consideredNodeBreaker) {
            LOG.info("All FullModel objects have EquipmentOperation profile, so conversion will be considered node-breaker");
        } else {
            LOG.info("Following FullModel objects do not have EquipmentOperation profile, so conversion will not be considered node-breaker:");
            modelHasOperationProfile.entrySet().forEach(meqop -> {
                if (!((Boolean)meqop.getValue()).booleanValue()) {
                    LOG.info("    {}", meqop.getKey());
                }
            });
        }
    }

    private Map<String, Boolean> computeModelHasOperationProfile(PropertyBags modelProfiles) {
        HashMap<String, Boolean> modelHasOperationProfile = new HashMap<String, Boolean>();
        HashMap<String, Boolean> modelHasBoundaryOperationProfile = new HashMap<String, Boolean>();
        for (PropertyBag mp : modelProfiles) {
            String m2 = (String)mp.get((Object)"FullModel");
            String p = (String)mp.get((Object)PROFILE);
            if (p == null) continue;
            this.updateModelHasOperationProfile(modelHasOperationProfile, modelHasBoundaryOperationProfile, m2, p);
        }
        modelHasBoundaryOperationProfile.forEach((m, v) -> modelHasOperationProfile.merge((String)m, (Boolean)v, (vm, vbd) -> vm != false && vbd != false));
        return modelHasOperationProfile;
    }

    private void updateModelHasOperationProfile(Map<String, Boolean> modelHasOperationProfile, Map<String, Boolean> modelHasBoundaryOperationProfile, String model, String profile) {
        if (CgmesModelTripleStore.isEquipmentCore(profile)) {
            modelHasOperationProfile.putIfAbsent(model, false);
        }
        if (CgmesModelTripleStore.isEquipmentOperation(profile)) {
            modelHasOperationProfile.put(model, true);
            LOG.info("Model {} is considered node-breaker", (Object)model);
        }
        if (profile.contains("/EquipmentBoundary/")) {
            modelHasBoundaryOperationProfile.putIfAbsent(model, false);
        }
        if (profile.contains("/EquipmentBoundaryOperation/")) {
            modelHasBoundaryOperationProfile.put(model, true);
            LOG.info("Model {} boundary is considered node-breaker", (Object)model);
        }
    }

    @Override
    public PropertyBags fullModels() {
        return this.namedQuery("fullModels", new String[0]);
    }

    @Override
    public String modelId() {
        PropertyBags r;
        String modelId = "unknown";
        if (this.queryCatalog.containsKey((Object)"modelIds") && (r = this.namedQuery("modelIds", new String[0])) != null && !r.isEmpty()) {
            String v;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Candidates to model identifier:{}{}", (Object)System.lineSeparator(), (Object)r.tabulateLocals());
            }
            if ((v = (String)((PropertyBag)r.get(0)).get((Object)"FullModel")) != null) {
                modelId = v;
            }
        }
        return modelId;
    }

    @Override
    public ZonedDateTime scenarioTime() {
        ZonedDateTime defaultScenarioTime = ZonedDateTime.now();
        return this.queryDate("scenarioTime", defaultScenarioTime);
    }

    @Override
    public ZonedDateTime created() {
        ZonedDateTime defaultCreated = ZonedDateTime.now();
        return this.queryDate("created", defaultCreated);
    }

    private ZonedDateTime queryDate(String propertyName, ZonedDateTime defaultValue) {
        PropertyBags r;
        ZonedDateTime d = defaultValue;
        if (this.queryCatalog.containsKey((Object)"modelDates") && (r = this.namedQuery("modelDates", new String[0])) != null && !r.isEmpty()) {
            String s;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Candidates to modelDates:{}{}", (Object)System.lineSeparator(), (Object)r.tabulateLocals());
            }
            if ((s = (String)((PropertyBag)r.get(0)).get((Object)propertyName)) != null && !s.isEmpty()) {
                try {
                    d = this.parseDateTime(s);
                }
                catch (DateTimeParseException e) {
                    LOG.error("Invalid date: {}. The date has been fixed to {}.", (Object)s, (Object)defaultValue);
                    return defaultValue;
                }
            }
        }
        return d;
    }

    private ZonedDateTime parseDateTime(String dateAsString) {
        DateTimeFormatter dateTimeFormatterLocalised = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendPattern("[VV][x][xx][xxx]").toFormatter();
        TemporalAccessor dateParsed = dateTimeFormatterLocalised.parseBest(dateAsString, ZonedDateTime::from, LocalDateTime::from);
        if (dateParsed instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)dateParsed;
            return zonedDateTime;
        }
        return ZonedDateTime.of((LocalDateTime)dateParsed, ZoneOffset.UTC);
    }

    @Override
    public String version() {
        String v;
        String version = "unknown";
        PropertyBags r = this.namedQuery("version", new String[0]);
        if (r != null && !r.isEmpty() && (v = (String)((PropertyBag)r.get(0)).get((Object)"version")) != null) {
            version = v;
        }
        return version;
    }

    @Override
    public PropertyBags numObjectsByType() {
        Objects.requireNonNull(this.cimNamespace);
        return this.namedQuery("numObjectsByType", this.cimNamespace);
    }

    @Override
    public PropertyBags allObjectsOfType(String type) {
        Objects.requireNonNull(type);
        return this.namedQuery("allObjectsOfType", type);
    }

    @Override
    public PropertyBags boundaryNodes() {
        return this.namedQuery("boundaryNodes", new String[0]);
    }

    @Override
    public PropertyBags baseVoltages() {
        return this.namedQuery("baseVoltages", new String[0]);
    }

    @Override
    public PropertyBags countrySourcingActors(String countryName) {
        return this.namedQuery("countrySourcingActors", countryName);
    }

    @Override
    public PropertyBags sourcingActor(String sourcingActor) {
        return this.namedQuery("sourcingActor", sourcingActor);
    }

    @Override
    public PropertyBags substations() {
        return this.namedQuery("substations", new String[0]);
    }

    @Override
    public PropertyBags voltageLevels() {
        return this.namedQuery("voltageLevels", new String[0]);
    }

    @Override
    public PropertyBags terminals() {
        return this.namedQuery("terminals", new String[0]);
    }

    @Override
    public PropertyBags connectivityNodes() {
        if (this.cachedNodes) {
            return this.cachedConnectivityNodes;
        }
        return this.namedQuery("connectivityNodes", new String[0]);
    }

    @Override
    public PropertyBags topologicalNodes() {
        if (this.cachedNodes) {
            return this.cachedTopologicalNodes;
        }
        return this.namedQuery("topologicalNodes", new String[0]);
    }

    @Override
    public PropertyBags connectivityNodeContainers() {
        return this.namedQuery("connectivityNodeContainers", new String[0]);
    }

    @Override
    public PropertyBags operationalLimits() {
        return this.namedQuery("operationalLimits", new String[0]);
    }

    @Override
    public PropertyBags busBarSections() {
        return this.namedQuery("busbarSections", new String[0]);
    }

    @Override
    public PropertyBags switches() {
        return this.namedQuery("switches", new String[0]);
    }

    @Override
    public PropertyBags acLineSegments() {
        return this.namedQuery("acLineSegments", new String[0]);
    }

    @Override
    public PropertyBags equivalentBranches() {
        return this.namedQuery("equivalentBranches", new String[0]);
    }

    @Override
    public PropertyBags seriesCompensators() {
        return this.namedQuery("seriesCompensators", new String[0]);
    }

    @Override
    public PropertyBags transformers() {
        return this.namedQuery("transformers", new String[0]);
    }

    @Override
    public PropertyBags transformerEnds() {
        return this.namedQuery("transformerEnds", new String[0]);
    }

    @Override
    public PropertyBags ratioTapChangers() {
        return this.namedQuery("ratioTapChangers", new String[0]);
    }

    @Override
    public PropertyBags ratioTapChangerTablePoints() {
        return this.namedQuery("ratioTapChangerTablePoints", new String[0]);
    }

    @Override
    public PropertyBags phaseTapChangers() {
        return this.namedQuery("phaseTapChangers", new String[0]);
    }

    @Override
    public PropertyBags phaseTapChangerTablePoints() {
        return this.namedQuery("phaseTapChangerTablePoints", new String[0]);
    }

    @Override
    public PropertyBags regulatingControls() {
        return this.namedQuery("regulatingControls", new String[0]);
    }

    @Override
    public PropertyBags energyConsumers() {
        return this.namedQuery("energyConsumers", new String[0]);
    }

    @Override
    public PropertyBags energySources() {
        return this.namedQuery("energySources", new String[0]);
    }

    @Override
    public PropertyBags shuntCompensators() {
        return this.namedQuery("shuntCompensators", new String[0]);
    }

    @Override
    public PropertyBags equivalentShunts() {
        return this.namedQuery("equivalentShunts", new String[0]);
    }

    @Override
    public PropertyBags nonlinearShuntCompensatorPoints() {
        return this.namedQuery("nonlinearShuntCompensatorPoints", new String[0]);
    }

    @Override
    public PropertyBags staticVarCompensators() {
        return this.namedQuery("staticVarCompensators", new String[0]);
    }

    @Override
    public PropertyBags synchronousMachinesGenerators() {
        return this.namedQuery("synchronousMachinesGenerators", new String[0]);
    }

    @Override
    public PropertyBags synchronousMachinesCondensers() {
        return this.namedQuery("synchronousMachinesCondensers", new String[0]);
    }

    @Override
    public PropertyBags equivalentInjections() {
        return this.namedQuery("equivalentInjections", new String[0]);
    }

    @Override
    public PropertyBags externalNetworkInjections() {
        return this.namedQuery("externalNetworkInjections", new String[0]);
    }

    @Override
    public PropertyBags svInjections() {
        return this.namedQuery("svInjections", new String[0]);
    }

    @Override
    public PropertyBags asynchronousMachines() {
        return this.namedQuery("asynchronousMachines", new String[0]);
    }

    @Override
    public PropertyBags reactiveCapabilityCurveData() {
        return this.namedQuery("reactiveCapabilityCurveData", new String[0]);
    }

    @Override
    public PropertyBags controlAreas() {
        return this.namedQuery("controlAreas", new String[0]);
    }

    @Override
    public PropertyBags dcSwitches() {
        return this.namedQuery("dcSwitches", new String[0]);
    }

    @Override
    public PropertyBags dcGrounds() {
        return this.namedQuery("dcGrounds", new String[0]);
    }

    @Override
    public PropertyBags acDcConverters() {
        return this.namedQuery("acDcConverters", new String[0]);
    }

    @Override
    public PropertyBags dcLineSegments() {
        return this.namedQuery("dcLineSegments", new String[0]);
    }

    @Override
    public PropertyBags dcTerminals() {
        return this.namedQuery("dcTerminals", new String[0]);
    }

    @Override
    public PropertyBags tieFlows() {
        return this.namedQuery("tieFlows", new String[0]);
    }

    @Override
    public PropertyBags topologicalIslands() {
        return this.namedQuery("topologicalIslands", new String[0]);
    }

    @Override
    public PropertyBags graph() {
        return this.namedQuery("graph", new String[0]);
    }

    @Override
    public PropertyBags grounds() {
        return this.namedQuery("grounds", new String[0]);
    }

    @Override
    public PropertyBags modelProfiles() {
        return this.namedQuery(MODEL_PROFILES, new String[0]);
    }

    public PropertyBags namedQuery(String name, String ... params) {
        String queryText = (String)this.queryCatalog.get((Object)name);
        if (queryText == null) {
            LOG.warn("Query [{}] not found in catalog", (Object)name);
            return new PropertyBags();
        }
        queryText = this.injectParams(queryText, params);
        long t0 = System.currentTimeMillis();
        PropertyBags r = this.query(queryText);
        long t1 = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("results query {}{}{}", new Object[]{name, System.lineSeparator(), r.tabulateLocals()});
            LOG.debug("dt query {} {} ms, result set size = {}", new Object[]{name, t1 - t0, r.size()});
        }
        return r;
    }

    public void namedQueryUpdate(String name, String ... params) {
        String queryText = (String)this.queryCatalog.get((Object)name);
        if (queryText == null) {
            LOG.warn("Query [{}] not found in catalog", (Object)name);
        }
        queryText = this.injectParams(queryText, params);
        this.update(queryText);
    }

    public String getCimNamespace() {
        return this.cimNamespace;
    }

    public int getCimVersion() {
        return this.cimVersion;
    }

    public PropertyBags query(String queryText) {
        return this.tripleStore.query(queryText);
    }

    public void update(String queryText) {
        this.tripleStore.update(queryText);
    }

    @Override
    public TripleStore tripleStore() {
        return this.tripleStore;
    }

    public void update(String queryName, String context, String baseName, String subject, String predicate, String value, boolean valueIsUri) {
        String value1;
        Objects.requireNonNull(this.cimNamespace);
        String baseUri = this.getBaseUri(baseName);
        String string = value1 = valueIsUri ? baseUri.concat(value) : value;
        if (value.contains("cim:")) {
            value1 = this.cimNamespace.concat(value.substring(4));
        }
        this.namedQueryUpdate(queryName, context, baseUri.concat(subject), predicate, value1, String.valueOf(valueIsUri));
    }

    private String getBaseUri(String baseName) {
        if (this.tripleStore.getImplementationName().equals("rdf4j")) {
            return baseName.concat("/#");
        }
        return baseName.concat("#");
    }

    @Override
    public void clear(CgmesSubset subset) {
        Set contextNames = this.tripleStore.contextNames();
        for (String contextName : contextNames) {
            if (!subset.isValidName(contextName)) continue;
            this.tripleStore.clear(contextName);
        }
    }

    @Override
    public void add(CgmesSubset subset, String type, PropertyBags objects) {
        String contextName = this.contextNameFor(subset);
        try {
            this.tripleStore.add(contextName, this.cimNamespace, type, objects);
        }
        catch (TripleStoreException x) {
            String msg = String.format("Adding objects of type %s to subset %s, context %s", new Object[]{type, subset, contextName});
            throw new CgmesModelException(msg, x);
        }
    }

    @Override
    public void add(String context, String type, PropertyBags objects) {
        String contextName = EnumUtils.isValidEnum(CgmesSubset.class, (String)context) ? this.contextNameFor(CgmesSubset.valueOf(context)) : context;
        try {
            if (type.equals("FullModel")) {
                this.tripleStore.add(contextName, this.mdNamespace(), type, objects);
            } else {
                this.tripleStore.add(contextName, this.cimNamespace, type, objects);
            }
        }
        catch (TripleStoreException x) {
            String msg = String.format("Adding objects of type %s to context %s", type, context);
            throw new CgmesModelException(msg, x);
        }
    }

    private String mdNamespace() {
        PrefixNamespace def = new PrefixNamespace("md", "http://iec.ch/TC57/61970-552/ModelDescription/1#");
        return this.tripleStore.getNamespaces().stream().filter(ns -> ns.getPrefix().equals("md")).findFirst().orElse(def).getNamespace();
    }

    private static int cimVersionFromCimNamespace(String cimNamespace) {
        Matcher m = CIM_NAMESPACE_VERSION_PATTERN_UNTIL_16.matcher((CharSequence)cimNamespace);
        if (m.matches()) {
            return Integer.valueOf(m.group(1));
        }
        m = CIM_NAMESPACE_VERSION_PATTERN_FROM_100.matcher((CharSequence)cimNamespace);
        if (m.matches()) {
            return Integer.valueOf(m.group(1));
        }
        return -1;
    }

    private String contextNameFor(CgmesSubset subset) {
        for (String context : this.tripleStore.contextNames()) {
            if (!subset.isValidName(context)) continue;
            return context;
        }
        return this.modelId() + "_" + subset + ".xml";
    }

    private QueryCatalog queryCatalogFor(int cimVersion) {
        QueryCatalog qc = null;
        String resourceName = null;
        if (cimVersion > 0) {
            resourceName = String.format("CIM%d.sparql", cimVersion);
        }
        if (resourceName != null) {
            qc = new QueryCatalog(resourceName);
        }
        return qc;
    }

    private String injectParams(String queryText, String ... params) {
        int k;
        String injected = queryText;
        for (k = 0; k < Math.min(PARAMETER_REFERENCE.length, params.length); ++k) {
            injected = injected.replace(PARAMETER_REFERENCE[k], params[k]);
        }
        while (k < params.length) {
            String paramRef = "{" + k + "}";
            injected = injected.replace(paramRef, params[k]);
            ++k;
        }
        return injected;
    }
}

