/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.cgmes.model.CgmesOnDataSource;
import com.powsybl.cgmes.model.triplestore.CgmesModelTripleStore;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.TripleStore;
import com.powsybl.triplestore.api.TripleStoreFactory;
import com.powsybl.triplestore.api.TripleStoreOptions;
import java.util.Objects;

public final class CgmesModelFactory {
    private CgmesModelFactory() {
    }

    public static CgmesModel create(ReadOnlyDataSource dataSource) {
        return CgmesModelFactory.create(dataSource, "rdf4j", ReportNode.NO_OP);
    }

    public static CgmesModel create(ReadOnlyDataSource dataSource, String implementation) {
        ReadOnlyDataSource alternativeDataSourceForBoundary = null;
        return CgmesModelFactory.create(dataSource, alternativeDataSourceForBoundary, implementation, ReportNode.NO_OP);
    }

    public static CgmesModel create(ReadOnlyDataSource dataSource, String implementation, ReportNode reportNode) {
        ReadOnlyDataSource alternativeDataSourceForBoundary = null;
        return CgmesModelFactory.create(dataSource, alternativeDataSourceForBoundary, implementation, reportNode);
    }

    public static CgmesModel create(ReadOnlyDataSource mainDataSource, ReadOnlyDataSource alternativeDataSourceForBoundary, String implementation, ReportNode reportNode) {
        return CgmesModelFactory.create(mainDataSource, alternativeDataSourceForBoundary, implementation, reportNode, new TripleStoreOptions());
    }

    public static CgmesModel create(ReadOnlyDataSource mainDataSource, ReadOnlyDataSource alternativeDataSourceForBoundary, String implementation, ReportNode reportNode, TripleStoreOptions tripleStoreOptions) {
        Objects.requireNonNull(mainDataSource);
        Objects.requireNonNull(implementation);
        Objects.requireNonNull(reportNode);
        Objects.requireNonNull(tripleStoreOptions);
        CgmesModel cgmes = CgmesModelFactory.createImplementation(implementation, tripleStoreOptions, mainDataSource, alternativeDataSourceForBoundary);
        cgmes.read(mainDataSource, alternativeDataSourceForBoundary, reportNode);
        return cgmes;
    }

    private static CgmesModel createImplementation(String implementation, TripleStoreOptions tripleStoreOptions, ReadOnlyDataSource ds, ReadOnlyDataSource alternativeDataSourceForBoundary) {
        TripleStore tripleStore = TripleStoreFactory.create((String)implementation, (TripleStoreOptions)tripleStoreOptions);
        String cimNamespace = CgmesModelFactory.obtainCimNamespace(ds, alternativeDataSourceForBoundary);
        return new CgmesModelTripleStore(cimNamespace, tripleStore, tripleStoreOptions.queryCatalog());
    }

    private static String obtainCimNamespace(ReadOnlyDataSource ds, ReadOnlyDataSource dsBoundary) {
        try {
            return new CgmesOnDataSource(ds).cimNamespace();
        }
        catch (CgmesModelException x) {
            if (dsBoundary != null) {
                try {
                    return new CgmesOnDataSource(dsBoundary).cimNamespace();
                }
                catch (CgmesModelException x2) {
                    throw x;
                }
            }
            throw x;
        }
    }
}

