/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.PowerFlow;
import com.powsybl.triplestore.api.PropertyBag;
import java.util.Objects;

public class CgmesTerminal {
    private final String id;
    private final String name;
    private final String conductingEquipment;
    private final String conductingEquipmentType;
    private final boolean connected;
    private final PowerFlow flow;
    private final String connectivityNode;
    private final String topologicalNode;
    private final int sequenceNumber;

    public static String topologicalNode(PropertyBag t) {
        String tp = t.getId("TopologicalNodeTerminal");
        if (tp == null) {
            tp = t.getId("TopologicalNodeConnectivityNode");
        }
        return tp;
    }

    public CgmesTerminal(PropertyBag t) {
        Objects.requireNonNull(t);
        this.id = t.getId("Terminal");
        this.name = (String)t.get((Object)"name");
        this.conductingEquipment = t.getId("ConductingEquipment");
        this.conductingEquipmentType = t.getLocal("conductingEquipmentType");
        this.connectivityNode = t.getId("ConnectivityNode");
        this.topologicalNode = CgmesTerminal.topologicalNode(t);
        this.connected = t.asBoolean("connected", true);
        this.flow = new PowerFlow(t, "p", "q");
        this.sequenceNumber = t.asInt("sequenceNumber", 0);
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String conductingEquipment() {
        return this.conductingEquipment;
    }

    public String conductingEquipmentType() {
        return this.conductingEquipmentType;
    }

    public String connectivityNode() {
        return this.connectivityNode;
    }

    public String topologicalNode() {
        return this.topologicalNode;
    }

    public boolean connected() {
        return this.connected;
    }

    public PowerFlow flow() {
        return this.flow;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }
}

