/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesContainer;
import com.powsybl.cgmes.model.CgmesModel;
import com.powsybl.cgmes.model.CgmesSubset;
import com.powsybl.cgmes.model.CgmesTerminal;
import com.powsybl.cgmes.model.EmptyTripleStore;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.triplestore.api.PropertyBag;
import com.powsybl.triplestore.api.PropertyBags;
import com.powsybl.triplestore.api.TripleStore;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

public final class InMemoryCgmesModel
implements CgmesModel {
    private final Properties properties = new Properties();
    private String modelId = "fakeModel0";
    private String version = "unknown";
    private boolean isNodeBreaker = false;
    private ZonedDateTime created = ZonedDateTime.now();
    private ZonedDateTime scenarioTime = ZonedDateTime.now();
    private PropertyBags substations = new PropertyBags();
    private PropertyBags voltageLevels = new PropertyBags();
    private PropertyBags terminals = new PropertyBags();
    private PropertyBags operationalLimits = new PropertyBags();
    private PropertyBags connectivityNodes = new PropertyBags();
    private PropertyBags topologicalNodes = new PropertyBags();
    private PropertyBags busbarSections = new PropertyBags();
    private PropertyBags switches = new PropertyBags();
    private PropertyBags acLineSegments = new PropertyBags();
    private PropertyBags equivalentBranches = new PropertyBags();
    private PropertyBags seriesCompensators = new PropertyBags();
    private PropertyBags transformers = new PropertyBags();
    private PropertyBags transformerEnds = new PropertyBags();
    private PropertyBags ratioTapChangers = new PropertyBags();
    private PropertyBags phaseTapChangers = new PropertyBags();
    private PropertyBags regulatingControls = new PropertyBags();
    private PropertyBags energyConsumers = new PropertyBags();
    private PropertyBags energySources = new PropertyBags();
    private PropertyBags shuntCompensators = new PropertyBags();
    private PropertyBags shuntCompensatorPoints = new PropertyBags();
    private PropertyBags staticVarCompensators;
    private PropertyBags equivalentShunts = new PropertyBags();
    private PropertyBags synchronousMachinesGenerators;
    private PropertyBags equivalentInjections;
    private PropertyBags externalNetworkInjections;
    private PropertyBags svInjections;
    private PropertyBags asynchronousMachines;
    private PropertyBags acDcConverters;
    private PropertyBags dcLineSegments;
    private PropertyBags dcTerminals;
    private PropertyBags controlAreas;
    private PropertyBags tieFlows;
    private PropertyBags numObjectsByType;
    private PropertyBags modelProfiles;
    private PropertyBags generatingUnits;
    private PropertyBags svVoltages;

    public InMemoryCgmesModel() {
        this.staticVarCompensators = new PropertyBags();
        this.synchronousMachinesGenerators = new PropertyBags();
        this.equivalentInjections = new PropertyBags();
        this.externalNetworkInjections = new PropertyBags();
        this.svInjections = new PropertyBags();
        this.asynchronousMachines = new PropertyBags();
        this.acDcConverters = new PropertyBags();
        this.dcLineSegments = new PropertyBags();
        this.dcTerminals = new PropertyBags();
        this.controlAreas = new PropertyBags();
        this.tieFlows = new PropertyBags();
        this.numObjectsByType = new PropertyBags();
        this.modelProfiles = new PropertyBags();
        this.generatingUnits = new PropertyBags();
        this.svVoltages = new PropertyBags();
    }

    @Override
    public TripleStore tripleStore() {
        return new EmptyTripleStore();
    }

    @Override
    public boolean hasEquipmentCore() {
        return true;
    }

    public InMemoryCgmesModel modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public InMemoryCgmesModel version(String version) {
        this.version = version;
        return this;
    }

    public InMemoryCgmesModel nodeBreaker(boolean b) {
        this.isNodeBreaker = b;
        return this;
    }

    @Override
    public boolean isNodeBreaker() {
        return this.isNodeBreaker;
    }

    @Override
    public boolean hasBoundary() {
        return false;
    }

    public InMemoryCgmesModel substations(String ... ids) {
        this.fakeObjectsFromIdentifiers("Substation", ids, this.substations);
        this.substations.forEach(s -> {
            s.put((Object)"SubRegion", (Object)"SubRegion0");
            s.put((Object)"subRegionName", (Object)"SubRegionName0");
            s.put((Object)"Region", (Object)"Region0");
            s.put((Object)"regionName", (Object)"regionName0");
        });
        return this;
    }

    public InMemoryCgmesModel voltageLevels(String ... ids) {
        this.fakeObjectsFromIdentifiers("VoltageLevel", ids, this.voltageLevels);
        return this;
    }

    public InMemoryCgmesModel terminals(String ... ids) {
        this.fakeObjectsFromIdentifiers("Terminal", ids, this.terminals);
        return this;
    }

    public InMemoryCgmesModel operationalLimits(String ... ids) {
        this.fakeObjectsFromIdentifiers("OperationalLimit", ids, this.operationalLimits);
        return this;
    }

    public InMemoryCgmesModel topologicalNodes(String ... ids) {
        this.fakeObjectsFromIdentifiers("TopologicalNode", ids, this.topologicalNodes);
        return this;
    }

    public InMemoryCgmesModel busBarSections(String ... ids) {
        this.fakeObjectsFromIdentifiers("BusbarSection", ids, this.busbarSections);
        return this;
    }

    public InMemoryCgmesModel switches(String ... ids) {
        this.fakeObjectsFromIdentifiers("Switch", ids, this.switches);
        return this;
    }

    public InMemoryCgmesModel acLineSegments(String ... ids) {
        this.fakeObjectsFromIdentifiers("ACLineSegment", ids, this.acLineSegments);
        return this;
    }

    @Override
    public PropertyBags equivalentBranches() {
        return this.equivalentBranches;
    }

    @Override
    public PropertyBags seriesCompensators() {
        return this.seriesCompensators;
    }

    public InMemoryCgmesModel transformers(String ... ids) {
        this.fakeObjectsFromIdentifiers("PowerTransformer", ids, this.transformers);
        return this;
    }

    public InMemoryCgmesModel transformerEnds(String ... ids) {
        this.fakeObjectsFromIdentifiers("TransformerEnd", ids, this.transformerEnds);
        return this;
    }

    public InMemoryCgmesModel ratioTapChangers(String ... ids) {
        this.fakeObjectsFromIdentifiers("RatioTapChanger", ids, this.ratioTapChangers);
        return this;
    }

    public InMemoryCgmesModel phaseTapChangers(String ... ids) {
        this.fakeObjectsFromIdentifiers("PhaseTapChanger", ids, this.phaseTapChangers);
        return this;
    }

    public InMemoryCgmesModel energyConsumers(String ... ids) {
        this.fakeObjectsFromIdentifiers("EnergyConsumer", ids, this.energyConsumers);
        return this;
    }

    public InMemoryCgmesModel shuntCompensators(String ... ids) {
        this.fakeObjectsFromIdentifiers("ShuntCompensator", ids, this.shuntCompensators);
        return this;
    }

    public InMemoryCgmesModel shuntCompensatorsPoints(String ... ids) {
        this.fakeObjectsFromIdentifiers("NonlinearShuntCompensatorPoint", ids, this.shuntCompensatorPoints);
        return this;
    }

    public InMemoryCgmesModel staticVarCompensators(String ... ids) {
        this.fakeObjectsFromIdentifiers("StaticVarCompensator", ids, this.staticVarCompensators);
        return this;
    }

    public InMemoryCgmesModel synchronousMachinesGenerators(String ... ids) {
        this.fakeObjectsFromIdentifiers("SynchronousMachine", ids, this.synchronousMachinesGenerators);
        return this;
    }

    public InMemoryCgmesModel asynchronousMachines(String ... ids) {
        this.fakeObjectsFromIdentifiers("AsynchronousMachine", ids, this.asynchronousMachines);
        return this;
    }

    public InMemoryCgmesModel acDcConverters(String ... ids) {
        this.fakeObjectsFromIdentifiers("ACDCConverter", ids, this.acDcConverters);
        return this;
    }

    public InMemoryCgmesModel dcLineSegments(String ... ids) {
        this.fakeObjectsFromIdentifiers("DCLineSegment", ids, this.dcLineSegments);
        return this;
    }

    public InMemoryCgmesModel dcTerminals(String ... ids) {
        this.fakeObjectsFromIdentifiers("DCTerminal", ids, this.dcTerminals);
        return this;
    }

    public InMemoryCgmesModel tieFlows(String ... ids) {
        this.fakeObjectsFromIdentifiers("TieFlow", ids, this.tieFlows);
        return this;
    }

    public InMemoryCgmesModel modelProfiles(String ... ids) {
        this.fakeObjectsFromIdentifiers("FullModel", ids, this.modelProfiles);
        return this;
    }

    private void fakeObjectsFromIdentifiers(String propertyNameId, String[] ids, PropertyBags objects) {
        String[] propertyNames = new String[]{propertyNameId};
        for (String id : ids) {
            PropertyBag p = new PropertyBag(Arrays.asList(propertyNames), true);
            p.put((Object)propertyNameId, (Object)id);
            objects.add((Object)p);
        }
        PropertyBag p = new PropertyBag(Arrays.asList("Type", "numObjects"), true);
        p.put((Object)"Type", (Object)propertyNameId);
        p.put((Object)"numObjects", (Object)("" + ids.length));
        this.numObjectsByType.add((Object)p);
    }

    @Override
    public PropertyBags controlAreas() {
        return this.controlAreas;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public ZonedDateTime scenarioTime() {
        return this.scenarioTime;
    }

    @Override
    public ZonedDateTime created() {
        return this.created;
    }

    @Override
    public PropertyBags boundaryNodes() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags baseVoltages() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags numObjectsByType() {
        return this.numObjectsByType;
    }

    @Override
    public PropertyBags allObjectsOfType(String type) {
        return new PropertyBags();
    }

    @Override
    public PropertyBags countrySourcingActors(String countryName) {
        return new PropertyBags();
    }

    @Override
    public PropertyBags sourcingActor(String sourcingActor) {
        return new PropertyBags();
    }

    @Override
    public PropertyBags substations() {
        return this.substations;
    }

    @Override
    public PropertyBags voltageLevels() {
        return this.voltageLevels;
    }

    @Override
    public PropertyBags terminals() {
        return this.terminals;
    }

    @Override
    public PropertyBags connectivityNodeContainers() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags operationalLimits() {
        return this.operationalLimits;
    }

    @Override
    public PropertyBags generatingUnits() {
        return this.generatingUnits;
    }

    @Override
    public PropertyBags connectivityNodes() {
        return this.connectivityNodes;
    }

    @Override
    public PropertyBags topologicalNodes() {
        return this.topologicalNodes;
    }

    @Override
    public PropertyBags busBarSections() {
        return this.busbarSections;
    }

    @Override
    public PropertyBags switches() {
        return this.switches;
    }

    @Override
    public PropertyBags acLineSegments() {
        return this.acLineSegments;
    }

    @Override
    public PropertyBags transformers() {
        return this.transformers;
    }

    @Override
    public PropertyBags transformerEnds() {
        return this.transformerEnds;
    }

    @Override
    public PropertyBags ratioTapChangers() {
        return this.ratioTapChangers;
    }

    @Override
    public PropertyBags ratioTapChangerTablePoints() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags phaseTapChangers() {
        return this.phaseTapChangers;
    }

    @Override
    public PropertyBags phaseTapChangerTablePoints() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags regulatingControls() {
        return this.regulatingControls;
    }

    @Override
    public PropertyBags energyConsumers() {
        return this.energyConsumers;
    }

    @Override
    public PropertyBags energySources() {
        return this.energySources;
    }

    @Override
    public PropertyBags shuntCompensators() {
        return this.shuntCompensators;
    }

    @Override
    public PropertyBags nonlinearShuntCompensatorPoints() {
        return this.shuntCompensatorPoints;
    }

    @Override
    public PropertyBags equivalentShunts() {
        return this.equivalentShunts;
    }

    @Override
    public PropertyBags staticVarCompensators() {
        return this.staticVarCompensators;
    }

    @Override
    public PropertyBags synchronousMachinesGenerators() {
        return this.synchronousMachinesGenerators;
    }

    @Override
    public PropertyBags equivalentInjections() {
        return this.equivalentInjections;
    }

    @Override
    public PropertyBags externalNetworkInjections() {
        return this.externalNetworkInjections;
    }

    @Override
    public PropertyBags svInjections() {
        return this.svInjections;
    }

    @Override
    public PropertyBags asynchronousMachines() {
        return this.asynchronousMachines;
    }

    @Override
    public PropertyBags modelProfiles() {
        return this.modelProfiles;
    }

    @Override
    public PropertyBags reactiveCapabilityCurveData() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags dcSwitches() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags dcGrounds() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags acDcConverters() {
        return this.acDcConverters;
    }

    @Override
    public PropertyBags dcLineSegments() {
        return this.dcLineSegments;
    }

    @Override
    public PropertyBags dcTerminals() {
        return this.dcTerminals;
    }

    @Override
    public PropertyBags tieFlows() {
        return this.tieFlows;
    }

    @Override
    public PropertyBags svVoltages() {
        return this.svVoltages;
    }

    @Override
    public PropertyBags topologicalIslands() {
        return new PropertyBags();
    }

    @Override
    public PropertyBags graph() {
        return new PropertyBags();
    }

    @Override
    public void print(PrintStream out) {
    }

    @Override
    public void print(Consumer<String> liner) {
    }

    @Override
    public void write(DataSource ds) {
    }

    @Override
    public void write(DataSource ds, CgmesSubset subset) {
    }

    @Override
    public void clear(CgmesSubset subset) {
    }

    @Override
    public void add(CgmesSubset subset, String type, PropertyBags objects) {
    }

    @Override
    public void add(String contextOrSubset, String type, PropertyBags objects) {
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Collection<CgmesTerminal> computedTerminals() {
        return Collections.emptyList();
    }

    @Override
    public CgmesTerminal terminal(String terminalId) {
        return null;
    }

    @Override
    public String substation(CgmesTerminal t, boolean nodeBreaker) {
        return null;
    }

    @Override
    public String voltageLevel(CgmesTerminal t, boolean nodeBreaker) {
        return null;
    }

    @Override
    public Optional<String> node(CgmesTerminal t, boolean nodeBreaker) {
        return Optional.empty();
    }

    @Override
    public Optional<CgmesContainer> nodeContainer(String nodeId) {
        return Optional.empty();
    }

    @Override
    public CgmesContainer container(String containerId) {
        return null;
    }

    @Override
    public double nominalVoltage(String baseVoltageId) {
        return Double.NaN;
    }

    @Override
    public void setBasename(String baseName) {
    }

    @Override
    public String getBasename() {
        return null;
    }

    @Override
    public void read(ReadOnlyDataSource ds, ReportNode reportNode) {
    }

    @Override
    public void read(ReadOnlyDataSource mainDataSource, ReadOnlyDataSource alternativeDataSourceForBoundary, ReportNode reportNode) {
    }

    @Override
    public void read(InputStream is, String baseName, String contextName, ReportNode reportNode) {
    }
}

