/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.model;

import com.powsybl.cgmes.model.CgmesModelException;
import com.powsybl.triplestore.api.PropertyBag;

public class PowerFlow {
    public static final PowerFlow UNDEFINED = new PowerFlow(false, Double.NaN, Double.NaN);
    private final double p;
    private final double q;
    private final boolean defined;

    private PowerFlow(boolean defined, double p, double q) {
        this.defined = defined;
        this.p = p;
        this.q = q;
    }

    public PowerFlow(double p, double q) {
        this.defined = true;
        this.p = p;
        this.q = q;
    }

    public PowerFlow(PropertyBag b, String pname, String qname) {
        this.p = b.asDouble(pname);
        this.q = b.asDouble(qname);
        this.defined = b.containsKey((Object)pname) && b.containsKey((Object)qname);
    }

    public boolean defined() {
        return this.defined;
    }

    public double p() {
        return this.p;
    }

    public double q() {
        return this.q;
    }

    public PowerFlow sum(PowerFlow f) {
        if (!this.defined || !f.defined) {
            throw new CgmesModelException("PowerFlow invalid operation sum");
        }
        return new PowerFlow(this.p + f.p, this.q + f.q);
    }
}

