/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.test;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.powsybl.commons.test.ComparisonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractConverterTest {
    protected FileSystem fileSystem;
    protected Path tmpDir;

    @BeforeEach
    public void setUp() throws IOException {
        this.fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
        this.tmpDir = Files.createDirectory(this.fileSystem.getPath("tmp", new String[0]), new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.fileSystem.close();
    }

    protected <T> T roundTripXmlTest(T data, BiConsumer<T, Path> out, Function<Path, T> in, String ref) throws IOException {
        return this.roundTripTest(data, out, in, ComparisonUtils::compareXml, ref);
    }

    protected <T> T roundTripTest(T data, BiConsumer<T, Path> out, Function<Path, T> in, String ref) throws IOException {
        return this.roundTripTest(data, out, in, ComparisonUtils::compareTxt, ref);
    }

    protected <T> Path writeXmlTest(T data, BiConsumer<T, Path> out, String ref) throws IOException {
        return this.writeTest(data, out, ComparisonUtils::compareXml, ref);
    }

    protected <T> Path writeTest(T data, BiConsumer<T, Path> out, BiConsumer<InputStream, InputStream> compare, String ref) throws IOException {
        Path xmlFile = this.tmpDir.resolve("data");
        out.accept(data, xmlFile);
        try (InputStream is = Files.newInputStream(xmlFile, new OpenOption[0]);){
            compare.accept(this.getClass().getResourceAsStream(ref), is);
        }
        return xmlFile;
    }

    protected <T> T roundTripTest(T data, BiConsumer<T, Path> out, Function<Path, T> in, BiConsumer<InputStream, InputStream> compare, String ref) throws IOException {
        Path xmlFile = this.writeTest(data, out, compare, ref);
        try (InputStream is1 = Files.newInputStream(xmlFile, new OpenOption[0]);){
            compare.accept(this.getClass().getResourceAsStream(ref), is1);
        }
        T data2 = in.apply(xmlFile);
        Path xmlFile2 = this.tmpDir.resolve("data2");
        out.accept(data2, xmlFile2);
        try (InputStream is2 = Files.newInputStream(xmlFile2, new OpenOption[0]);){
            compare.accept(this.getClass().getResourceAsStream(ref), is2);
        }
        return data2;
    }
}

