/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.test;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.powsybl.commons.test.ComparisonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractSerDeTest {
    protected FileSystem fileSystem;
    protected Path tmpDir;

    @BeforeEach
    public void setUp() throws IOException {
        this.fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
        this.tmpDir = Files.createDirectory(this.fileSystem.getPath("tmp", new String[0]), new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.fileSystem.close();
    }

    protected <T> T roundTripXmlTest(T data, BiFunction<T, Path, T> transformer, BiConsumer<T, Path> write, Function<Path, T> read, String ref) throws IOException {
        return this.roundTripTest(data, transformer, write, read, ComparisonUtils::compareXml, ref);
    }

    protected <T> T roundTripTest(T data, BiConsumer<T, Path> write, Function<Path, T> read, String ref) throws IOException {
        return this.roundTripTest(data, write, read, ComparisonUtils::compareTxt, ref);
    }

    protected <T> Path writeXmlTest(T data, BiConsumer<T, Path> write, String ref) throws IOException {
        return this.writeTest(data, write, ComparisonUtils::compareXml, ref);
    }

    protected <T> Path writeTest(T data, BiConsumer<T, Path> write, BiConsumer<InputStream, InputStream> compare, String ref) throws IOException {
        Path file = this.tmpDir.resolve("data");
        write.accept(data, file);
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            compare.accept(this.getClass().getResourceAsStream(ref), is);
        }
        return file;
    }

    protected <T> T roundTripTest(T data, BiConsumer<T, Path> write, Function<Path, T> read, BiConsumer<InputStream, InputStream> compare, String ref) throws IOException {
        return (T)this.roundTripTest(data, (t, p) -> t, write, read, compare, ref);
    }

    protected <T> T roundTripTest(T data, BiFunction<T, Path, T> transformer, BiConsumer<T, Path> write, Function<Path, T> read, BiConsumer<InputStream, InputStream> compare, String ref) throws IOException {
        Path transformFile = this.tmpDir.resolve("data");
        T transformedData = transformer.apply(data, transformFile);
        Path file1 = this.writeTest(transformedData, write, compare, ref);
        T data2 = read.apply(file1);
        Path file2 = this.tmpDir.resolve("data2");
        write.accept(data, file2);
        Assertions.assertEquals((long)-1L, (long)Files.mismatch(file1, file2), (String)"File A written after transforming given data differs from file B obtained after reading A and writing the resulting data");
        return data2;
    }
}

