/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.test;

import com.google.common.io.ByteStreams;
import com.powsybl.commons.test.TestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public final class ComparisonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonUtils.class);

    private ComparisonUtils() {
    }

    public static void compareXml(InputStream expected, InputStream actual) {
        Diff myDiff = DiffBuilder.compare((Object)expected).withTest((Object)actual).ignoreWhitespace().ignoreComments().build();
        boolean hasDiff = myDiff.hasDifferences();
        if (hasDiff) {
            LOGGER.error("{}", (Object)myDiff);
        }
        Assertions.assertFalse((boolean)hasDiff);
    }

    public static void compareTxt(InputStream expected, InputStream actual) {
        try {
            ComparisonUtils.compareTxt(expected, new String(ByteStreams.toByteArray((InputStream)actual), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void compareTxt(InputStream expected, InputStream actual, List<Integer> excludedLines) {
        BufferedReader expectedReader = new BufferedReader(new InputStreamReader(expected));
        List<String> expectedLines = expectedReader.lines().toList();
        BufferedReader actualReader = new BufferedReader(new InputStreamReader(actual));
        List<String> actualLines = actualReader.lines().toList();
        for (int i = 0; i < expectedLines.size(); ++i) {
            if (excludedLines.contains(i)) continue;
            Assertions.assertEquals((Object)expectedLines.get(i), (Object)actualLines.get(i));
        }
    }

    public static void compareTxt(InputStream expected, String actual) {
        try {
            ComparisonUtils.compareTxt(new String(ByteStreams.toByteArray((InputStream)expected), StandardCharsets.UTF_8), actual);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void compareTxt(String expected, InputStream actual) {
        try {
            ComparisonUtils.compareTxt(expected, new String(ByteStreams.toByteArray((InputStream)actual), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void compareTxt(String expected, String actual) {
        String expectedStr = TestUtil.normalizeLineSeparator(expected);
        String actualStr = TestUtil.normalizeLineSeparator(actual);
        Assertions.assertEquals((Object)expectedStr, (Object)actualStr);
    }
}

