/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.test;

import com.google.common.io.ByteStreams;
import com.powsybl.commons.test.TestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public final class ComparisonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonUtils.class);

    private ComparisonUtils() {
    }

    public static void assertXmlEquals(InputStream expected, InputStream actual) {
        Diff myDiff = DiffBuilder.compare((Object)expected).withTest((Object)actual).ignoreWhitespace().ignoreComments().build();
        boolean hasDiff = myDiff.hasDifferences();
        if (hasDiff) {
            LOGGER.error("{}", (Object)myDiff);
        }
        Assertions.assertFalse((boolean)hasDiff);
    }

    public static void assertTxtEquals(Path expected, Path actual) {
        try (InputStream expectedStream = Files.newInputStream(expected, new OpenOption[0]);
             InputStream actualStream = Files.newInputStream(actual, new OpenOption[0]);){
            ComparisonUtils.assertTxtEquals(expectedStream, actualStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertTxtEquals(InputStream expected, InputStream actual) {
        try {
            ComparisonUtils.assertTxtEquals(expected, new String(ByteStreams.toByteArray((InputStream)actual), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertBytesEquals(InputStream expected, InputStream actual) {
        try {
            Assertions.assertArrayEquals((byte[])expected.readAllBytes(), (byte[])actual.readAllBytes());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertTxtEquals(InputStream expected, InputStream actual, List<Integer> excludedLines) {
        BufferedReader expectedReader = new BufferedReader(new InputStreamReader(expected));
        List<String> expectedLines = expectedReader.lines().toList();
        BufferedReader actualReader = new BufferedReader(new InputStreamReader(actual));
        List<String> actualLines = actualReader.lines().toList();
        for (int i = 0; i < expectedLines.size(); ++i) {
            if (excludedLines.contains(i)) continue;
            Assertions.assertEquals((Object)expectedLines.get(i), (Object)actualLines.get(i));
        }
    }

    public static void assertTxtEquals(InputStream expected, String actual) {
        try {
            ComparisonUtils.assertTxtEquals(new String(ByteStreams.toByteArray((InputStream)expected), StandardCharsets.UTF_8), actual);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertTxtEquals(String expected, InputStream actual) {
        try {
            ComparisonUtils.assertTxtEquals(expected, new String(ByteStreams.toByteArray((InputStream)actual), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertTxtEquals(String expected, String actual) {
        String expectedStr = TestUtil.normalizeLineSeparator(expected);
        String actualStr = TestUtil.normalizeLineSeparator(actual);
        Assertions.assertEquals((Object)expectedStr, (Object)actualStr);
    }
}

