/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.ModuleConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ModuleConfigUtil {
    private ModuleConfigUtil() {
    }

    public static Optional<Boolean> getOptionalBooleanProperty(ModuleConfig moduleConfig, List<String> names) {
        return ModuleConfigUtil.getOptionalProperty(moduleConfig, names, moduleConfig::getOptionalBooleanProperty);
    }

    public static Optional<String> getOptionalStringProperty(ModuleConfig moduleConfig, List<String> names) {
        return ModuleConfigUtil.getOptionalProperty(moduleConfig, names, moduleConfig::getOptionalStringProperty);
    }

    public static Optional<List<String>> getOptionalStringListProperty(ModuleConfig moduleConfig, List<String> names) {
        return ModuleConfigUtil.getOptionalProperty(moduleConfig, names, moduleConfig::getOptionalStringListProperty);
    }

    public static OptionalDouble getOptionalDoubleProperty(ModuleConfig moduleConfig, List<String> names) {
        return ModuleConfigUtil.getOptionalProperty(moduleConfig, names, moduleConfig::getOptionalDoubleProperty, OptionalDouble::empty, OptionalDouble::isPresent);
    }

    private static <T> Optional<T> getOptionalProperty(ModuleConfig moduleConfig, List<String> names, Function<String, Optional<T>> supplier) {
        return ModuleConfigUtil.getOptionalProperty(moduleConfig, names, supplier, Optional::empty, Optional::isPresent);
    }

    private static <T> T getOptionalProperty(ModuleConfig moduleConfig, List<String> names, Function<String, T> supplier, Supplier<T> factory, Predicate<T> isPresent) {
        Objects.requireNonNull(moduleConfig);
        Objects.requireNonNull(names);
        T res = factory.get();
        Iterator<String> it = names.iterator();
        while (!isPresent.test(res) && it.hasNext()) {
            res = supplier.apply(it.next());
        }
        return res;
    }
}

