/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.AbstractModuleConfigRepository;
import com.powsybl.commons.config.MapModuleConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class YamlModuleConfigRepository
extends AbstractModuleConfigRepository {
    public YamlModuleConfigRepository(Path yamlConfigFile) {
        Objects.requireNonNull(yamlConfigFile);
        try (BufferedReader reader = Files.newBufferedReader(yamlConfigFile, StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml();
            Object data = yaml.load((Reader)reader);
            if (!(data instanceof Map)) {
                throw new PowsyblException("Named modules are expected at the first level of the YAML");
            }
            for (Map.Entry e : ((Map)data).entrySet()) {
                String moduleName = (String)e.getKey();
                if (!(e.getValue() instanceof Map)) {
                    throw new PowsyblException("Properties are expected at the second level of the YAML");
                }
                this.configs.put(moduleName, new MapModuleConfig((Map)e.getValue(), yamlConfigFile.getFileSystem()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

