/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.Bzip2FileDataSource;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.FileDataSource;
import com.powsybl.commons.datasource.GzFileDataSource;
import com.powsybl.commons.datasource.ZipFileDataSource;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public interface DataSourceUtil {
    public static String getFileName(String baseName, String suffix, String ext) {
        Objects.requireNonNull(baseName);
        return baseName + (suffix != null ? suffix : "") + (String)(ext == null || ext.isEmpty() ? "" : "." + ext);
    }

    public static OpenOption[] getOpenOptions(boolean append) {
        OpenOption[] defaultOpenOptions = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        OpenOption[] appendOpenOptions = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.WRITE};
        return append ? appendOpenOptions : defaultOpenOptions;
    }

    public static String getBaseName(Path file) {
        return DataSourceUtil.getBaseName(file.getFileName().toString());
    }

    public static String getBaseName(String fileName) {
        Objects.requireNonNull(fileName);
        int pos = fileName.indexOf(46);
        return pos == -1 ? fileName : fileName.substring(0, pos);
    }

    public static DataSource createDataSource(Path directory, String basename, CompressionFormat compressionExtension, DataSourceObserver observer) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(basename);
        if (compressionExtension == null) {
            return new FileDataSource(directory, basename, observer);
        }
        switch (compressionExtension) {
            case GZIP: {
                return new GzFileDataSource(directory, basename, observer);
            }
            case BZIP2: {
                return new Bzip2FileDataSource(directory, basename, observer);
            }
            case ZIP: {
                return new ZipFileDataSource(directory, basename, observer);
            }
        }
        throw new AssertionError((Object)("Unexpected CompressionFormat value: " + compressionExtension));
    }

    public static DataSource createDataSource(Path directory, String fileNameOrBaseName, DataSourceObserver observer) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(fileNameOrBaseName);
        if (fileNameOrBaseName.endsWith(".zip")) {
            return new ZipFileDataSource(directory, fileNameOrBaseName, DataSourceUtil.getBaseName(fileNameOrBaseName.substring(0, fileNameOrBaseName.length() - 4)), observer);
        }
        if (fileNameOrBaseName.endsWith(".gz")) {
            return new GzFileDataSource(directory, DataSourceUtil.getBaseName(fileNameOrBaseName.substring(0, fileNameOrBaseName.length() - 3)), observer);
        }
        if (fileNameOrBaseName.endsWith(".bz2")) {
            return new Bzip2FileDataSource(directory, DataSourceUtil.getBaseName(fileNameOrBaseName.substring(0, fileNameOrBaseName.length() - 4)), observer);
        }
        return new FileDataSource(directory, DataSourceUtil.getBaseName(fileNameOrBaseName), observer);
    }
}

