/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.ResourceSet;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ResourceDataSource
implements ReadOnlyDataSource {
    private final String baseName;
    private final List<ResourceSet> resourceSets;

    public ResourceDataSource(String baseName, ResourceSet ... resourceSets) {
        this(baseName, Arrays.asList(resourceSets));
    }

    public ResourceDataSource(String baseName, List<ResourceSet> resourceSets) {
        this.baseName = Objects.requireNonNull(baseName);
        this.resourceSets = Objects.requireNonNull(resourceSets);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean exists(String suffix, String ext) {
        return this.exists(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public boolean exists(String fileName) {
        Objects.requireNonNull(fileName);
        return this.resourceSets.stream().anyMatch(resourceSet -> resourceSet.getFileNames().contains(fileName));
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) {
        Objects.requireNonNull(fileName);
        return this.resourceSets.stream().filter(resourceSet -> resourceSet.exists(fileName)).map(resourceSet -> resourceSet.newInputStream(fileName)).findFirst().orElseThrow(() -> new IllegalArgumentException("File '" + fileName + "' not found"));
    }

    @Override
    public Set<String> listNames(String regex) {
        Pattern p = Pattern.compile(regex);
        return this.resourceSets.stream().flatMap(resourceSet -> resourceSet.getFileNames().stream()).filter(name -> p.matcher((CharSequence)name).matches()).collect(Collectors.toSet());
    }
}

