/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.ReporterModel;
import com.powsybl.commons.reporter.ReporterModelJsonModule;
import com.powsybl.commons.reporter.TypedValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ReporterModelSerializer
extends StdSerializer<ReporterModel> {
    private static final String VERSION = "1.0";

    ReporterModelSerializer() {
        super(ReporterModel.class);
    }

    public void serialize(ReporterModel reporter, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        generator.writeStartObject();
        generator.writeStringField("version", VERSION);
        generator.writeFieldName("reportTree");
        this.writeReporterModel(reporter, generator, dictionary);
        this.writeDictionaryEntries(generator, dictionary);
        generator.writeEndObject();
    }

    private void writeDictionaryEntries(JsonGenerator generator, Map<String, String> dictionary) throws IOException {
        generator.writeFieldName("dics");
        generator.writeStartObject();
        generator.writeObjectField("default", dictionary);
        generator.writeEndObject();
    }

    private void writeReporterModel(ReporterModel reporter, JsonGenerator generator, Map<String, String> dictionary) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("taskKey", reporter.getTaskKey());
        if (!reporter.getTaskValues().isEmpty()) {
            generator.writeObjectField("taskValues", reporter.getTaskValues());
        }
        if (!reporter.getReports().isEmpty()) {
            generator.writeFieldName("reports");
            generator.writeStartArray();
            for (Report report : reporter.getReports()) {
                this.writeReport(report, generator, dictionary);
            }
            generator.writeEndArray();
        }
        if (!reporter.getSubReporters().isEmpty()) {
            generator.writeFieldName("subReporters");
            generator.writeStartArray();
            for (ReporterModel subReporter : reporter.getSubReporters()) {
                this.writeReporterModel(subReporter, generator, dictionary);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
        dictionary.put(reporter.getTaskKey(), reporter.getDefaultName());
    }

    private void writeReport(Report report, JsonGenerator generator, Map<String, String> dictionary) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("reportKey", report.getReportKey());
        if (!report.getValues().isEmpty()) {
            generator.writeObjectField("values", report.getValues());
        }
        generator.writeEndObject();
        dictionary.put(report.getReportKey(), report.getDefaultMessage());
    }

    public static void write(ReporterModel reporter, Path jsonFile) {
        Objects.requireNonNull(reporter);
        Objects.requireNonNull(jsonFile);
        try (OutputStream os = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            ReporterModelSerializer.createObjectMapper().writerWithDefaultPrettyPrinter().writeValue(os, (Object)reporter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new ReporterModelJsonModule());
    }

    protected static final class TypedValueSerializer
    extends StdSerializer<TypedValue> {
        protected TypedValueSerializer() {
            super(TypedValue.class);
        }

        public void serialize(TypedValue typedValue, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
            generator.writeStartObject();
            generator.writeObjectField("value", typedValue.getValue());
            if (!"UNTYPED".equals(typedValue.getType())) {
                generator.writeStringField("type", typedValue.getType());
            }
            generator.writeEndObject();
        }
    }
}

