/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.DefaultDataSourceObserver;
import com.powsybl.commons.datasource.ObservableOutputStream;
import com.powsybl.commons.datasource.ReadOnlyMemDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class MemDataSource
extends ReadOnlyMemDataSource
implements DataSource {
    @Override
    public OutputStream newOutputStream(String suffix, String ext, boolean append) throws IOException {
        return this.newOutputStream(DataSourceUtil.getFileName("", suffix, ext), append);
    }

    @Override
    public OutputStream newOutputStream(final String fileName, boolean append) throws IOException {
        byte[] ba;
        Objects.requireNonNull(fileName);
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (append && (ba = this.getData(fileName)) != null) {
            os.write(ba, 0, ba.length);
        }
        return new ObservableOutputStream(os, fileName, new DefaultDataSourceObserver(){

            @Override
            public void closed(String streamName) {
                MemDataSource.this.putData(fileName, os.toByteArray());
            }
        });
    }
}

