/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import java.io.InputStream;
import java.util.Objects;

public abstract class AbstractExtensionXmlSerializer<T extends Extendable, E extends Extension<T>>
implements ExtensionXmlSerializer<T, E> {
    private final String extensionName;
    private final String categoryName;
    private final Class<? super E> extensionClass;
    private final boolean subElements;
    private final String xsdFileName;
    private final String namespaceUri;
    private final String namespacePrefix;

    protected AbstractExtensionXmlSerializer(String extensionName, String categoryName, Class<? super E> extensionClass, boolean subElements, String xsdFileName, String namespaceUri, String namespacePrefix) {
        this.extensionName = Objects.requireNonNull(extensionName);
        this.categoryName = Objects.requireNonNull(categoryName);
        this.extensionClass = Objects.requireNonNull(extensionClass);
        this.subElements = subElements;
        this.xsdFileName = Objects.requireNonNull(xsdFileName);
        this.namespaceUri = Objects.requireNonNull(namespaceUri);
        this.namespacePrefix = Objects.requireNonNull(namespacePrefix);
    }

    @Override
    public String getExtensionName() {
        return this.extensionName;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public Class<? super E> getExtensionClass() {
        return this.extensionClass;
    }

    @Override
    public boolean hasSubElements() {
        return this.subElements;
    }

    @Override
    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/" + this.xsdFileName);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }
}

