/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class FileUtil {
    private FileUtil() {
    }

    public static void removeDir(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    public static void copyDir(Path source, Path dest) throws IOException {
        Files.walkFileTree(source, new CopyDirVisitor(source, dest, StandardCopyOption.REPLACE_EXISTING));
    }

    public static Path createDirectory(Path directory) {
        Objects.requireNonNull(directory);
        try {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return directory;
    }

    public static ByteSource asByteSource(final Path path, final OpenOption ... openOptions) {
        Objects.requireNonNull(path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"Path %s is not readable.", (Object)path);
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return Files.newInputStream(path, openOptions);
            }
        };
    }

    private static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final CopyOption copyOption;

        public CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path relativize = this.fromPath.relativize(dir);
            Path targetPath = this.toPath.resolve(relativize.toString());
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            Path relativize = this.fromPath.relativize(path);
            Files.copy(path, this.toPath.resolve(relativize.toString()), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

