/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io.table;

import com.powsybl.commons.io.table.AbstractTableFormatter;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.HorizontalAlignment;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.Table;

public class AsciiTableFormatter
extends AbstractTableFormatter {
    private final String title;
    private final Table table;
    private final int cellsCount;
    private int rowCellIndex = 0;
    private int cellIndex = 0;

    public AsciiTableFormatter(Writer writer, String title, TableFormatterConfig config, Column ... columns) {
        super(writer, config, columns);
        this.title = title;
        this.cellsCount = Arrays.stream(columns).mapToInt(Column::getColspan).sum();
        this.table = new Table(this.cellsCount, BorderStyle.CLASSIC_WIDE);
        for (Column column : columns) {
            this.table.addCell(column.getName(), AsciiTableFormatter.convertCellStyle(column.getTitleHorizontalAlignment()), column.getColspan());
        }
    }

    public AsciiTableFormatter(String title, Column ... columns) {
        this((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), title, TableFormatterConfig.load(), columns);
    }

    public AsciiTableFormatter(Writer writer, String title, Column ... columns) {
        this(writer, title, TableFormatterConfig.load(), columns);
    }

    @Override
    public TableFormatter writeEmptyLine() throws IOException {
        return this.writeEmptyCells(this.cellsCount - this.rowCellIndex);
    }

    @Override
    public TableFormatter writeComment(String comment) {
        return this;
    }

    @Override
    public TableFormatter writeCell(String value, int colspan) {
        if (colspan > this.columns[this.column].getColspan() - this.cellIndex) {
            throw new IllegalArgumentException("You have exceded the authorized colspan");
        }
        HorizontalAlignment horizontalAlignment = colspan == 1 ? this.columns[this.column].getHorizontalAlignment() : HorizontalAlignment.CENTER;
        this.table.addCell(value, AsciiTableFormatter.convertCellStyle(horizontalAlignment), colspan);
        this.rowCellIndex = (this.rowCellIndex + 1) % this.cellsCount;
        this.cellIndex = (this.cellIndex + colspan) % this.columns[this.column].getColspan();
        if (this.cellIndex == 0) {
            this.column = (this.column + 1) % this.columns.length;
        }
        return this;
    }

    @Override
    protected TableFormatter write(String value) throws IOException {
        return this.writeCell(value, 1);
    }

    @Override
    public void close() throws IOException {
        if (!StringUtils.isEmpty((CharSequence)this.title)) {
            this.writer.write(this.title + ":" + System.lineSeparator());
        }
        this.writer.write(this.table.render() + System.lineSeparator());
        this.writer.flush();
    }

    private static CellStyle convertCellStyle(HorizontalAlignment horizontalAlignment) {
        switch (horizontalAlignment) {
            case LEFT: {
                return new CellStyle(CellStyle.HorizontalAlign.left);
            }
            case CENTER: {
                return new CellStyle(CellStyle.HorizontalAlign.center);
            }
            case RIGHT: {
                return new CellStyle(CellStyle.HorizontalAlign.right);
            }
        }
        return new CellStyle();
    }
}

