/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.plugins;

import java.util.Objects;

public class PluginInfo<T> {
    private final Class<T> pluginClass;
    private final String pluginName;

    public PluginInfo(Class<T> pluginClass) {
        this(pluginClass, pluginClass.getSimpleName());
    }

    public PluginInfo(Class<T> pluginClass, String pluginName) {
        this.pluginClass = Objects.requireNonNull(pluginClass);
        this.pluginName = Objects.requireNonNull(pluginName);
    }

    public Class<T> getPluginClass() {
        return this.pluginClass;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getId(T pluginImpl) {
        return pluginImpl.getClass().getName();
    }

    public String toString() {
        return "PluginInfo(" + this.pluginClass.getName() + " - " + this.pluginName + ")";
    }
}

