/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.commons.reporter.TypedValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringSubstitutor;

public abstract class AbstractReporter
implements Reporter {
    protected final String taskKey;
    protected final String defaultName;
    protected final Map<String, TypedValue> taskValues;

    public AbstractReporter(String taskKey, String defaultName, Map<String, TypedValue> taskValues) {
        this.taskKey = Objects.requireNonNull(taskKey);
        this.defaultName = defaultName;
        this.taskValues = new HashMap<String, TypedValue>();
        Objects.requireNonNull(taskValues).forEach(this::addTaskValue);
    }

    private void addTaskValue(String key, TypedValue typedValue) {
        Objects.requireNonNull(typedValue);
        this.taskValues.put(key, typedValue);
    }

    @Override
    public Reporter createSubReporter(String taskKey, String defaultName) {
        return this.createSubReporter(taskKey, defaultName, Collections.emptyMap());
    }

    @Override
    public Reporter createSubReporter(String taskKey, String defaultName, String key, Object value) {
        return this.createSubReporter(taskKey, defaultName, key, value, "UNTYPED");
    }

    @Override
    public Reporter createSubReporter(String taskKey, String defaultName, String key, Object value, String type) {
        return this.createSubReporter(taskKey, defaultName, Map.of(key, new TypedValue(value, type)));
    }

    @Override
    public void report(String reportKey, String defaultMessage, Map<String, TypedValue> values) {
        this.report(new Report(reportKey, defaultMessage, values));
    }

    @Override
    public void report(String reportKey, String defaultMessage) {
        this.report(reportKey, defaultMessage, Collections.emptyMap());
    }

    @Override
    public void report(String reportKey, String defaultMessage, String valueKey, Object value) {
        this.report(reportKey, defaultMessage, valueKey, value, "UNTYPED");
    }

    @Override
    public void report(String reportKey, String defaultMessage, String valueKey, Object value, String type) {
        this.report(reportKey, defaultMessage, Map.of(valueKey, new TypedValue(value, type)));
    }

    protected static String formatReportMessage(Report report, Map<String, TypedValue> taskValues) {
        return new StringSubstitutor(taskValues).replace(new StringSubstitutor(report.getValues()).replace(report.getDefaultMessage()));
    }

    protected static String formatMessage(String message, Map<String, TypedValue> values) {
        return new StringSubstitutor(values).replace(message);
    }
}

